/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.Column;
import org.hsqldb.Expression;
import org.hsqldb.HsqlName;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.TableFilter;
import org.hsqldb.Trace;

class Select {
    boolean isPreProcess;
    boolean isDistinctSelect;
    private boolean isDistinctAggregate;
    private boolean isAggregated;
    private boolean isGrouped;
    private Object[] aggregateRow;
    private int aggregateCount;
    TableFilter[] tFilter;
    Expression eCondition;
    Expression havingCondition;
    Expression[] eColumn;
    int iResultLen;
    int iGroupLen;
    int iOrderLen;
    Select sUnion;
    HsqlName sIntoTable;
    int intoType = 2;
    boolean isIntoTableQuoted;
    int iUnionType;
    static final int UNION = 1;
    static final int UNIONALL = 2;
    static final int INTERSECT = 3;
    static final int EXCEPT = 4;
    int limitStart = 0;
    int limitCount = 0;

    Select() {
    }

    void setPreProcess() {
        this.isPreProcess = true;
    }

    void resolve() throws SQLException {
        int n = this.tFilter.length;
        for (int i = 0; i < n; ++i) {
            this.resolve(this.tFilter[i], true);
        }
    }

    void resolve(TableFilter tableFilter, boolean bl) throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.resolve(tableFilter);
            if (tableFilter != null && bl) {
                tableFilter.setCondition(this.eCondition);
            }
        }
        int n = this.eColumn.length;
        for (int i = 0; i < n; ++i) {
            this.eColumn[i].resolve(tableFilter);
        }
    }

    void checkResolved() throws SQLException {
        if (this.eCondition != null) {
            this.eCondition.checkResolved();
        }
        int n = this.eColumn.length;
        for (int i = 0; i < n; ++i) {
            this.eColumn[i].checkResolved();
        }
    }

    Object getValue(int n) throws SQLException {
        this.resolve();
        Result result = this.getResult(2);
        int n2 = result.getSize();
        int n3 = result.getColumnCount();
        Trace.check(n2 == 1 && n3 == 1, 17);
        Object object = result.rRoot.data[0];
        if (result.colType[0] == n) {
            return object;
        }
        return Column.convertObject(object, n);
    }

    Result getResult(int n) throws SQLException {
        Object object;
        int n2;
        int n3;
        this.resolve();
        this.checkResolved();
        if (this.sUnion != null && this.sUnion.iResultLen != this.iResultLen) {
            throw Trace.error(5);
        }
        if (this.iGroupLen > 0) {
            this.isGrouped = true;
        }
        int n4 = this.eColumn.length;
        Result result = new Result(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            Expression expression = this.eColumn[n3];
            result.colType[n3] = expression.getDataType();
            result.colSize[n3] = expression.getColumnSize();
            result.colScale[n3] = expression.getColumnScale();
            if (!expression.isAggregate()) continue;
            this.isAggregated = true;
            if (this.isGrouped || !expression.isDistinctAggregate()) continue;
            this.isDistinctAggregate = true;
        }
        if (this.isAggregated) {
            this.aggregateRow = new Object[n4];
        }
        if (n == 0) {
            n = this.limitCount;
        } else if (this.limitCount == 0) {
            this.limitCount = n;
        } else {
            this.limitCount = n > this.limitCount ? this.limitCount : n;
            n = this.limitCount;
        }
        n3 = 0;
        if (!(n == 0 || this.isDistinctSelect || this.isDistinctAggregate || this.isGrouped || this.sUnion != null || this.iOrderLen != 0)) {
            n3 = 1;
        }
        int n5 = n3 != 0 ? this.limitStart + n : Integer.MAX_VALUE;
        this.buildResult(result, n5);
        if (this.isAggregated && !this.isGrouped && !this.isDistinctAggregate) {
            this.addAggregateRow(result, this.aggregateRow, n4, this.aggregateCount);
        } else if (this.isGrouped) {
            this.groupResult(result);
        } else if (this.isDistinctAggregate) {
            result.removeDuplicates();
            this.buildDistinctAggregates(result);
            for (n2 = 0; n2 < n4; ++n2) {
                object = this.eColumn[n2];
                ((Expression)object).setDistinctAggregate(false);
                result.colType[n2] = ((Expression)object).getDataType();
                result.colSize[n2] = ((Expression)object).getColumnSize();
                result.colScale[n2] = ((Expression)object).getColumnScale();
            }
        }
        if (this.isDistinctSelect) {
            n2 = result.getColumnCount();
            result.setColumnCount(this.iResultLen);
            result.removeDuplicates();
            result.setColumnCount(n2);
        }
        if (this.iOrderLen != 0) {
            int[] nArray = new int[this.iOrderLen];
            object = new int[this.iOrderLen];
            int n6 = this.iResultLen + (this.isGrouped ? this.iGroupLen : 0);
            for (int i = 0; i < this.iOrderLen; ++i) {
                nArray[i] = n6;
                object[i] = this.eColumn[n6].isDescending() ? -1 : 1;
                ++n6;
            }
            result.sortResult(nArray, (int[])object);
        }
        result.setColumnCount(this.iResultLen);
        for (int i = 0; i < this.iResultLen; ++i) {
            object = this.eColumn[i];
            result.sLabel[i] = ((Expression)object).getAlias();
            result.isLabelQuoted[i] = ((Expression)object).isAliasQuoted();
            result.sTable[i] = ((Expression)object).getTableName();
            result.sName[i] = ((Expression)object).getColumnName();
        }
        result.trimResult(this.limitStart, this.limitCount);
        if (this.sUnion != null) {
            Result result2 = this.sUnion.getResult(0);
            if (this.iUnionType == 1) {
                result.append(result2);
                result.removeDuplicates();
            } else if (this.iUnionType == 2) {
                result.append(result2);
            } else if (this.iUnionType == 3) {
                result.removeDifferent(result2);
            } else if (this.iUnionType == 4) {
                result.removeSecond(result2);
            }
        }
        return result;
    }

    private void updateAggregateRow(Object[] objectArray, Object[] objectArray2, int n) throws SQLException {
        block6: for (int i = 0; i < n; ++i) {
            int n2 = this.eColumn[i].getDataType();
            switch (this.eColumn[i].getType()) {
                case 45: {
                    Integer n3 = objectArray2[i] == null ? Expression.INTEGER_0 : Expression.INTEGER_1;
                    objectArray[i] = Column.sum(objectArray[i], n3, 4);
                    continue block6;
                }
                case 40: 
                case 41: 
                case 44: {
                    objectArray[i] = Column.sum(objectArray[i], objectArray2[i], n2);
                    continue block6;
                }
                case 42: {
                    objectArray[i] = Column.min(objectArray[i], objectArray2[i], n2);
                    continue block6;
                }
                case 43: {
                    objectArray[i] = Column.max(objectArray[i], objectArray2[i], n2);
                    continue block6;
                }
                default: {
                    objectArray[i] = objectArray2[i];
                }
            }
        }
    }

    private void addAggregateRow(Result result, Object[] objectArray, int n, int n2) throws SQLException {
        for (int i = 0; i < n; ++i) {
            int n3 = this.eColumn[i].getType();
            if (n3 == 44) {
                objectArray[i] = Column.avg(objectArray[i], this.eColumn[i].getDataType(), n2);
                continue;
            }
            if (n3 != 40 || objectArray[i] != null) continue;
            objectArray[i] = Expression.INTEGER_0;
        }
        result.add(objectArray);
    }

    private void buildResult(Result result, int n) throws SQLException {
        boolean bl;
        int n2 = this.eColumn.length;
        int n3 = 0;
        int n4 = this.tFilter.length;
        boolean[] blArray = new boolean[n4];
        int n5 = 0;
        boolean bl2 = bl = this.isAggregated && !this.isGrouped && !this.isDistinctAggregate;
        while (n5 >= 0 && !this.isPreProcess) {
            boolean bl3;
            TableFilter tableFilter = this.tFilter[n5];
            blArray[n5] = !blArray[n5] ? (bl3 = tableFilter.findFirst()) : (bl3 = tableFilter.next());
            if (!bl3) {
                --n5;
                continue;
            }
            if (n5 < n4 - 1) {
                ++n5;
                continue;
            }
            if (this.eCondition != null && !this.eCondition.test()) continue;
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                objectArray[i] = this.eColumn[i].getValue();
            }
            ++n3;
            if (bl) {
                this.updateAggregateRow(this.aggregateRow, objectArray, n2);
                continue;
            }
            result.add(objectArray);
            if (n3 < n) continue;
        }
        if (bl) {
            this.aggregateCount = n3;
        }
    }

    private void groupResult(Result result) throws SQLException {
        int n = this.eColumn.length;
        int n2 = 0;
        int[] nArray = new int[this.iGroupLen];
        int[] nArray2 = new int[this.iGroupLen];
        int n3 = this.iResultLen;
        for (int i = 0; i < this.iGroupLen; ++i) {
            nArray[i] = n3++;
            nArray2[i] = 1;
        }
        result.sortResult(nArray, nArray2);
        Record record = result.rRoot;
        Result result2 = new Result(n);
        do {
            Object[] objectArray = new Object[n];
            n2 = 0;
            boolean bl = false;
            while (record != null && !bl) {
                ++n2;
                for (int i = this.iResultLen; i < this.iResultLen + this.iGroupLen; ++i) {
                    if (record.next == null) {
                        bl = true;
                        continue;
                    }
                    if (Column.compare(record.data[i], record.next.data[i], result.colType[i]) == 0) continue;
                    bl = true;
                }
                this.updateAggregateRow(objectArray, record.data, n);
                record = record.next;
            }
            if (!this.isAggregated && n2 <= 0) continue;
            this.addAggregateRow(result2, objectArray, n, n2);
        } while (record != null);
        result.setRows(result2);
    }

    private void buildDistinctAggregates(Result result) throws SQLException {
        int n = this.eColumn.length;
        int n2 = 0;
        Record record = result.rRoot;
        Result result2 = new Result(n);
        Object[] objectArray = new Object[n];
        n2 = 0;
        while (record != null) {
            ++n2;
            this.updateAggregateRow(objectArray, record.data, n);
            record = record.next;
        }
        if (this.isAggregated || n2 > 0) {
            this.addAggregateRow(result2, objectArray, n, n2);
        }
        result.setRows(result2);
    }
}

