/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.CachedRow;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Table;

class Row {
    protected Object[] oData;
    protected Node nPrimaryNode;

    static Row newRow(Table table, Object[] objectArray) throws SQLException {
        if (table.isCached()) {
            return new CachedRow(table, objectArray);
        }
        return new Row(table, objectArray);
    }

    Row() {
    }

    Row(Table table, Object[] objectArray) throws SQLException {
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, i, table);
        }
        this.oData = objectArray;
    }

    void setPrimaryNode(Node node) {
        this.nPrimaryNode = node;
    }

    Node getNode(int n) {
        Node node = this.nPrimaryNode;
        while (n-- > 0) {
            node = node.nNext;
        }
        return node;
    }

    Node getNextNode(Node node) {
        node = node == null ? this.nPrimaryNode : node.nNext;
        return node;
    }

    Object[] getData() {
        return this.oData;
    }

    void delete() throws SQLException {
        ++Record.memoryRecords;
        this.oData = null;
        this.nPrimaryNode = null;
    }
}

