/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Vector;
import org.hsqldb.Column;
import org.hsqldb.Database;
import org.hsqldb.DatabaseScript;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.HsqlName;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.TextTable;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.View;
import org.hsqldb.lib.StringUtil;

class Parser {
    private Database dDatabase;
    private Tokenizer tTokenizer;
    private Session cSession;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;
    private static boolean sql_enforce_size;

    Parser(Database database, Tokenizer tokenizer, Session session) {
        this.dDatabase = database;
        this.tTokenizer = tokenizer;
        this.cSession = session;
    }

    static void setEnforceSize(boolean bl) {
        sql_enforce_size = bl;
    }

    Result processSelect() throws SQLException {
        Select select = this.parseSelect();
        if (select.sIntoTable == null) {
            return select.getResult(this.cSession.getMaxRows());
        }
        for (int i = 0; i < select.eColumn.length; ++i) {
            if (select.eColumn[i].getAlias().length() != 0) continue;
            throw Trace.error(45);
        }
        if (this.dDatabase.findUserTable(select.sIntoTable.name, this.cSession) != null) {
            throw Trace.error(21, select.sIntoTable.name);
        }
        Result result = select.getResult(0);
        Table table = select.intoType == 5 ? new TextTable(this.dDatabase, select.sIntoTable, select.intoType, this.cSession) : new Table(this.dDatabase, select.sIntoTable, select.intoType, this.cSession);
        table.addColumns(result);
        table.createPrimaryKey();
        this.dDatabase.linkTable(table);
        if (select.intoType == 5) {
            try {
                String string = StringUtil.toLowerSubset(select.sIntoTable.name, '_') + ".csv";
                table.setDataSource(string, false, this.cSession);
                this.logTableDDL(table);
                table.insert(result, this.cSession);
            }
            catch (SQLException sQLException) {
                this.dDatabase.dropTable(select.sIntoTable.name, false, false, this.cSession);
                throw sQLException;
            }
        } else {
            this.logTableDDL(table);
            table.insert(result, this.cSession);
        }
        int n = result.getSize();
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    void logTableDDL(Table table) throws SQLException {
        if (table.isTemp()) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        DatabaseScript.getTableDDL(this.dDatabase, table, 0, null, null, stringBuffer);
        String string = DatabaseScript.getDataSource(table);
        this.dDatabase.logger.writeToLog(this.cSession, stringBuffer.toString());
        if (string != null) {
            this.dDatabase.logger.writeToLog(this.cSession, string);
        }
    }

    Result processCall() throws SQLException {
        Expression expression = this.parseExpression();
        expression.resolve(null);
        int n = expression.getDataType();
        Object object = expression.getValue();
        Result result = new Result(1);
        result.sTable[0] = "";
        result.colType[0] = n;
        result.sLabel[0] = "";
        result.sName[0] = "";
        Object[] objectArray = new Object[]{object};
        result.add(objectArray);
        return result;
    }

    Result processUpdate() throws SQLException {
        Object object;
        int n;
        Object[] objectArray;
        String string = this.tTokenizer.getString();
        this.cSession.checkReadWrite();
        this.cSession.check(string, 8);
        Table table = this.dDatabase.getTable(string, this.cSession);
        TableFilter tableFilter = new TableFilter(table, null, false);
        if (table.isView()) {
            throw Trace.error(55, string);
        }
        this.tTokenizer.getThis("SET");
        Vector<Integer> vector = new Vector<Integer>();
        Vector<Object[]> vector2 = new Vector<Object[]>();
        int n2 = 0;
        string = null;
        do {
            ++n2;
            int n3 = table.getColumnNr(this.tTokenizer.getString());
            vector.addElement(new Integer(n3));
            this.tTokenizer.getThis("=");
            objectArray = this.parseExpression();
            objectArray.resolve(tableFilter);
            vector2.addElement(objectArray);
        } while ((string = this.tTokenizer.getString()).equals(","));
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        table.fireAll(5);
        objectArray = new Expression[n2];
        vector2.copyInto(objectArray);
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = (Integer)vector.elementAt(n);
            object = table.getColumn(nArray[n]);
            nArray2[n] = ((Column)object).getType();
            nArray3[n] = ((Column)object).getSize();
        }
        n = 0;
        if (tableFilter.findFirst()) {
            Object object2;
            Object object3;
            object = new Result();
            Result result = new Result();
            int n4 = table.getColumnCount();
            do {
                int n5;
                if (expression != null && !expression.test()) continue;
                object3 = tableFilter.oCurrentData;
                ((Result)object).add((Object[])object3);
                object2 = table.getNewRow();
                System.arraycopy(object3, 0, object2, 0, n4);
                if (sql_enforce_size) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        object2[nArray[n5]] = Parser.enforceSize(((Expression)objectArray[n5]).getValue(nArray2[n5]), nArray2[n5], nArray3[n5], true);
                    }
                } else {
                    for (n5 = 0; n5 < n2; ++n5) {
                        object2[nArray[n5]] = ((Expression)objectArray[n5]).getValue(nArray2[n5]);
                    }
                }
                result.add((Object[])object2);
            } while (tableFilter.next());
            this.cSession.beginNestedTransaction();
            try {
                object3 = ((Result)object).rRoot;
                while (object3 != null) {
                    table.fireAll(11, object3.data);
                    table.deleteNoCheck(object3.data, this.cSession, true);
                    object3 = object3.next;
                }
                object2 = result.rRoot;
                while (object2 != null) {
                    table.insertNoCheck(object2.data, this.cSession, true);
                    object2 = object2.next;
                    ++n;
                }
                table.checkUpdate(nArray, (Result)object, result);
                object2 = result.rRoot;
                while (object2 != null) {
                    table.fireAll(8, object2.data);
                    object2 = object2.next;
                }
                this.cSession.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cSession.endNestedTransaction(true);
                throw sQLException;
            }
        }
        table.fireAll(2);
        object = new Result();
        ((Result)object).iUpdateCount = n;
        return object;
    }

    Result processDelete() throws SQLException {
        Result result;
        this.tTokenizer.getThis("FROM");
        String string = this.tTokenizer.getString();
        this.cSession.checkReadWrite();
        this.cSession.check(string, 2);
        Table table = this.dDatabase.getTable(string, this.cSession);
        TableFilter tableFilter = new TableFilter(table, null, false);
        if (table.isView()) {
            throw Trace.error(55, string);
        }
        string = this.tTokenizer.getString();
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
            expression.resolve(tableFilter);
            tableFilter.setCondition(expression);
        } else {
            this.tTokenizer.back();
        }
        Trace.check(!table.isDataReadOnly(), 32);
        table.fireAll(4);
        int n = 0;
        if (tableFilter.findFirst()) {
            result = new Result();
            do {
                if (expression != null && !expression.test()) continue;
                result.add(tableFilter.oCurrentData);
            } while (tableFilter.next());
            Record record = result.rRoot;
            while (record != null) {
                table.delete(record.data, this.cSession);
                ++n;
                record = record.next;
            }
        }
        table.fireAll(1);
        result = new Result();
        result.iUpdateCount = n;
        return result;
    }

    Result processInsert() throws SQLException {
        Object object;
        int n;
        this.tTokenizer.getThis("INTO");
        String string = this.tTokenizer.getString();
        this.cSession.checkReadWrite();
        this.cSession.check(string, 4);
        Table table = this.dDatabase.getTable(string, this.cSession);
        if (table.isView()) {
            throw Trace.error(55, string);
        }
        string = this.tTokenizer.getString();
        Vector<String> vector = null;
        if (string.equals("(")) {
            block19: {
                vector = new Vector<String>();
                n = 0;
                do {
                    vector.addElement(this.tTokenizer.getString());
                    ++n;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block19;
                } while (string.equals(","));
                throw Trace.error(11, string);
            }
            string = this.tTokenizer.getString();
        }
        n = 0;
        int n2 = vector == null ? table.getColumnCount() : vector.size();
        if (string.equals("VALUES")) {
            int n3;
            boolean[] blArray;
            block20: {
                this.tTokenizer.getThis("(");
                object = table.getNewRow();
                blArray = vector == null ? null : new boolean[((Object[])object).length];
                n3 = 0;
                do {
                    int n4;
                    if (vector == null) {
                        n4 = n3;
                        if (n3 == n2) {
                            break block20;
                        }
                    } else {
                        n4 = table.getColumnNr((String)vector.elementAt(n3));
                        blArray[n4] = true;
                    }
                    Column column = table.getColumn(n4);
                    object[n4] = sql_enforce_size ? Parser.enforceSize(this.getValue(column.getType()), column.getType(), column.getSize(), true) : this.getValue(column.getType());
                    ++n3;
                    string = this.tTokenizer.getString();
                    if (string.equals(")")) break block20;
                } while (string.equals(","));
                throw Trace.error(11, string);
            }
            Trace.check(n2 == n3, 5);
            if (vector != null) {
                for (n3 = 0; n3 < blArray.length; ++n3) {
                    String string2;
                    if (blArray[n3] || (string2 = table.getColumn(n3).getDefaultString()) == null) continue;
                    object[n3] = Column.convertObject(string2, table.getColumn(n3).getType());
                }
            }
            table.insert((Object[])object, this.cSession);
            n = 1;
        } else if (string.equals("SELECT")) {
            object = this.processSelect();
            Record record = ((Result)object).rRoot;
            Trace.check(n2 == ((Result)object).getColumnCount(), 5);
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                int n5 = vector == null ? i : table.getColumnNr((String)vector.elementAt(i));
                nArray[i] = n5;
                nArray2[i] = table.getColumn(n5).getType();
            }
            this.cSession.beginNestedTransaction();
            try {
                while (record != null) {
                    int n6;
                    Object[] objectArray = table.getNewRow();
                    boolean[] blArray = new boolean[objectArray.length];
                    for (n6 = 0; n6 < n2; ++n6) {
                        blArray[nArray[n6]] = true;
                        objectArray[nArray[n6]] = nArray2[n6] != ((Result)object).colType[n6] ? Column.convertObject(record.data[n6], nArray2[n6]) : record.data[n6];
                    }
                    for (n6 = 0; n6 < blArray.length; ++n6) {
                        String string3;
                        if (blArray[n6] || (string3 = table.getColumn(n6).getDefaultString()) == null) continue;
                        objectArray[n6] = Column.convertObject(string3, table.getColumn(n6).getType());
                    }
                    table.insert(objectArray, this.cSession);
                    ++n;
                    record = record.next;
                }
                this.cSession.endNestedTransaction(false);
            }
            catch (SQLException sQLException) {
                this.cSession.endNestedTransaction(true);
                throw sQLException;
            }
        } else {
            throw Trace.error(11, string);
        }
        object = new Result();
        ((Result)object).iUpdateCount = n;
        return object;
    }

    static Object enforceSize(Object object, int n, int n2, boolean bl) {
        if (n2 == 0 || object == null) {
            return object;
        }
        switch (n) {
            case 1: {
                return Parser.padOrTrunc((String)object, n2, bl);
            }
            case 12: {
                if (((String)object).length() <= n2) break;
                return ((String)object).substring(0, n2);
            }
        }
        return object;
    }

    static String padOrTrunc(String string, int n, boolean bl) {
        if (string.length() >= n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        if (bl) {
            for (int i = string.length(); i < n; ++i) {
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    Select parseSelect() throws SQLException {
        Object object;
        Object object2;
        Select select = new Select();
        String string = this.tTokenizer.getString();
        if (string.equals("LIMIT")) {
            object2 = this.tTokenizer.getString();
            object = this.tTokenizer.getString();
            try {
                select.limitStart = new Integer((String)object2);
                select.limitCount = new Integer((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(16, "LIMIT n m");
            }
            string = this.tTokenizer.getString();
        } else if (string.equals("TOP")) {
            object2 = this.tTokenizer.getString();
            try {
                select.limitStart = 0;
                select.limitCount = new Integer((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(16, "TOP m");
            }
            string = this.tTokenizer.getString();
        }
        if (string.equals("DISTINCT")) {
            select.isDistinctSelect = true;
        } else {
            this.tTokenizer.back();
        }
        object2 = new Vector();
        do {
            object = this.parseExpression();
            string = this.tTokenizer.getString();
            if (string.equals("AS")) {
                ((Expression)object).setAlias(this.tTokenizer.getName(), this.tTokenizer.wasQuotedIdentifier());
                string = this.tTokenizer.getString();
            } else if (this.tTokenizer.wasName()) {
                ((Expression)object).setAlias(string, this.tTokenizer.wasQuotedIdentifier());
                string = this.tTokenizer.getString();
            }
            ((Vector)object2).addElement(object);
        } while (string.equals(","));
        if (string.equals("INTO")) {
            string = this.tTokenizer.getString();
            if (string.equals("CACHED")) {
                select.intoType = 3;
                select.sIntoTable = new HsqlName(this.tTokenizer.getString(), this.tTokenizer.wasQuotedIdentifier());
            } else if (string.equals("TEMP")) {
                select.intoType = 1;
                select.sIntoTable = new HsqlName(this.tTokenizer.getString(), this.tTokenizer.wasQuotedIdentifier());
            } else if (string.equals("TEXT")) {
                select.intoType = 5;
                select.sIntoTable = new HsqlName(this.tTokenizer.getString(), this.tTokenizer.wasQuotedIdentifier());
            } else {
                select.sIntoTable = new HsqlName(string, this.tTokenizer.wasQuotedIdentifier());
            }
            string = this.tTokenizer.getString();
        }
        if (!string.equals("FROM")) {
            throw Trace.error(11, string);
        }
        object = null;
        Vector<TableFilter> vector = new Vector<TableFilter>();
        vector.addElement(this.parseTableFilter(false));
        while (true) {
            if ((string = this.tTokenizer.getString()).equals("LEFT")) {
                string = this.tTokenizer.getString();
                if (string.equals("OUTER")) {
                    string = this.tTokenizer.getString();
                }
                Trace.check(string.equals("JOIN"), 11, string);
                vector.addElement(this.parseTableFilter(true));
                this.tTokenizer.getThis("ON");
                object = this.addCondition((Expression)object, this.parseOuterJoinCondition());
                continue;
            }
            if (string.equals("INNER")) {
                this.tTokenizer.getThis("JOIN");
                vector.addElement(this.parseTableFilter(false));
                this.tTokenizer.getThis("ON");
                object = this.addCondition((Expression)object, this.parseExpression());
                continue;
            }
            if (!string.equals(",")) break;
            vector.addElement(this.parseTableFilter(false));
        }
        this.tTokenizer.back();
        int n = vector.size();
        Object[] objectArray = new TableFilter[n];
        vector.copyInto(objectArray);
        select.tFilter = objectArray;
        n = ((Vector)object2).size();
        for (int i = 0; i < n; ++i) {
            int n2;
            Expression expression = (Expression)((Vector)object2).elementAt(i);
            if (expression.getType() == 6) {
                n2 = i;
                Table table = null;
                String string2 = expression.getTableName();
                for (int j = 0; j < objectArray.length; ++j) {
                    Object object3 = objectArray[j];
                    expression.resolve((TableFilter)object3);
                    if (string2 != null && !string2.equals(((TableFilter)object3).getName())) continue;
                    table = ((TableFilter)object3).getTable();
                    int n3 = table.getColumnCount();
                    for (int k = 0; k < n3; ++k) {
                        Expression expression2 = new Expression(((TableFilter)object3).getName(), table.getColumn((int)k).columnName.name, table.getColumn((int)k).columnName.isNameQuoted);
                        ((Vector)object2).insertElementAt(expression2, n2++);
                        ++n;
                    }
                }
                Trace.check(table != null, 22, string2);
                --n;
                ((Vector)object2).removeElementAt(n2);
                continue;
            }
            if (expression.getType() != 2 || expression.getTableName() != null) continue;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                expression.resolve((TableFilter)objectArray[n2]);
            }
        }
        select.iResultLen = n;
        string = this.tTokenizer.getString();
        if (string.equals("WHERE")) {
            object = this.addCondition((Expression)object, this.parseExpression());
            string = this.tTokenizer.getString();
        }
        select.eCondition = object;
        if (string.equals("GROUP")) {
            this.tTokenizer.getThis("BY");
            n = 0;
            do {
                Expression expression = this.parseExpression();
                expression = this.doOrderGroup(expression, (Vector)object2);
                ((Vector)object2).addElement(expression);
                string = this.tTokenizer.getString();
                ++n;
            } while (string.equals(","));
            select.iGroupLen = n;
        }
        if (string.equals("HAVING")) {
            Expression expression = null;
            this.addCondition(expression, this.parseExpression());
            select.havingCondition = expression;
            string = this.tTokenizer.getString();
            throw Trace.error(20);
        }
        if (string.equals("ORDER")) {
            this.tTokenizer.getThis("BY");
            n = 0;
            do {
                Expression expression = this.parseExpression();
                expression = this.doOrderGroup(expression, (Vector)object2);
                string = this.tTokenizer.getString();
                if (string.equals("DESC")) {
                    expression.setDescending();
                    string = this.tTokenizer.getString();
                } else if (string.equals("ASC")) {
                    string = this.tTokenizer.getString();
                }
                ((Vector)object2).addElement(expression);
                ++n;
            } while (string.equals(","));
            select.iOrderLen = n;
        }
        n = ((Vector)object2).size();
        select.eColumn = new Expression[n];
        ((Vector)object2).copyInto(select.eColumn);
        if (string.equals("UNION")) {
            string = this.tTokenizer.getString();
            if (string.equals("ALL")) {
                select.iUnionType = 2;
            } else {
                select.iUnionType = 1;
                this.tTokenizer.back();
            }
            this.tTokenizer.getThis("SELECT");
            select.sUnion = this.parseSelect();
        } else if (string.equals("INTERSECT")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 3;
            select.sUnion = this.parseSelect();
        } else if (string.equals("EXCEPT") || string.equals("MINUS")) {
            this.tTokenizer.getThis("SELECT");
            select.iUnionType = 4;
            select.sUnion = this.parseSelect();
        } else {
            this.tTokenizer.back();
        }
        return select;
    }

    private Expression doOrderGroup(Expression expression, Vector vector) throws SQLException {
        block3: {
            block2: {
                if (expression.getType() != 1) break block2;
                if (expression.getDataType() != 4) break block3;
                int n = (Integer)expression.getValue();
                expression = (Expression)vector.elementAt(n - 1);
                break block3;
            }
            if (expression.getType() == 2 && expression.getTableName() == null) {
                String string = expression.getColumnName();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    Expression expression2 = (Expression)vector.elementAt(i);
                    if (!string.equals(expression2.getAlias())) continue;
                    expression = expression2;
                    break;
                }
            }
        }
        return expression;
    }

    private TableFilter parseTableFilter(boolean bl) throws SQLException {
        Object object;
        String string = this.tTokenizer.getString();
        Table table = null;
        if (string.equals("(")) {
            this.tTokenizer.getThis("SELECT");
            object = this.parseSelect();
            Result result = ((Select)object).getResult(0);
            table = new Table(this.dDatabase, new HsqlName("SYSTEM_SUBQUERY", false), 0, null);
            this.tTokenizer.getThis(")");
            table.addColumns(result);
            table.createPrimaryKey();
            table.insert(result, this.cSession);
        } else {
            this.cSession.check(string, 1);
            table = this.dDatabase.getTable(string, this.cSession);
            if (table.isView()) {
                object = string;
                int n = this.tTokenizer.getPosition();
                int n2 = this.tTokenizer.getLength();
                int n3 = string.length();
                int n4 = n;
                string = this.tTokenizer.getString();
                if (string.equals("AS")) {
                    object = this.tTokenizer.getName();
                    n4 = this.tTokenizer.getPosition();
                } else if (this.tTokenizer.wasName()) {
                    object = string;
                    n4 = this.tTokenizer.getPosition();
                } else {
                    this.tTokenizer.back();
                }
                String string2 = this.tTokenizer.getPart(0, n - n3);
                String string3 = this.tTokenizer.getPart(n4, n2);
                View view = (View)table;
                String string4 = view.getStatement();
                StringBuffer stringBuffer = new StringBuffer(128);
                stringBuffer.append(string2);
                stringBuffer.append('(');
                stringBuffer.append(string4);
                stringBuffer.append(") ");
                stringBuffer.append((String)object);
                stringBuffer.append(string3);
                this.tTokenizer.setString(stringBuffer.toString(), n - n3 + 1);
                this.tTokenizer.getThis("SELECT");
                Select select = this.parseSelect();
                Result result = select.getResult(0);
                table = new Table(this.dDatabase, new HsqlName("SYSTEM_SUBQUERY", false), 0, null);
                this.tTokenizer.getThis(")");
                table.addColumns(result);
                table.createPrimaryKey();
                table.insert(result, this.cSession);
            }
        }
        object = null;
        string = this.tTokenizer.getString();
        if (string.equals("AS")) {
            object = this.tTokenizer.getName();
        } else if (this.tTokenizer.wasName()) {
            object = string;
        } else {
            this.tTokenizer.back();
        }
        return new TableFilter(table, (String)object, bl);
    }

    private Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private Object getValue(int n) throws SQLException {
        Expression expression = this.parseExpression();
        expression.resolve(null);
        return expression.getValue(n);
    }

    private Expression parseOuterJoinCondition() throws SQLException {
        boolean bl = false;
        this.read();
        if (this.iToken == 101) {
            bl = true;
            this.read();
        }
        Trace.check(this.iToken == 2, 64);
        Expression expression = new Expression(this.sTable, this.sToken);
        this.read();
        Trace.check(this.iToken == 21, 64);
        this.read();
        Trace.check(this.iToken == 2, 64);
        Expression expression2 = new Expression(this.sTable, this.sToken);
        if (bl) {
            this.read();
            Trace.check(this.iToken == 102, 64);
        }
        return new Expression(21, expression, expression2);
    }

    private Expression parseExpression() throws SQLException {
        this.read();
        if (Expression.isAggregate(this.iToken)) {
            boolean bl = false;
            int n = this.iToken;
            this.read();
            if (this.tTokenizer.getString().equals("DISTINCT")) {
                bl = true;
            } else {
                this.tTokenizer.back();
            }
            Expression expression = new Expression(n, this.readOr(), null);
            expression.setDistinctAggregate(bl);
            this.tTokenizer.back();
            return expression;
        }
        Expression expression = this.readOr();
        this.tTokenizer.back();
        return expression;
    }

    private Expression readOr() throws SQLException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws SQLException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws SQLException {
        if (this.iToken == 20) {
            int n = this.iToken;
            this.read();
            return new Expression(n, this.readCondition(), null);
        }
        if (this.iToken == 31) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Trace.check(this.iToken == 103, 11);
            Expression expression = new Expression(this.parseSelect());
            this.read();
            this.readThis(102);
            return new Expression(n, expression, null);
        }
        Expression expression = this.readConcat();
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        if (this.iToken == 27) {
            this.read();
            Expression expression2 = this.readConcat();
            char c = '\u0000';
            if (this.sToken.equals("ESCAPE")) {
                this.read();
                Expression expression3 = this.readTerm();
                Trace.check(expression3.getType() == 1, 7);
                String string = (String)expression3.getValue(12);
                if (string == null || string.length() < 1) {
                    throw Trace.error(7, string);
                }
                c = string.charAt(0);
            }
            expression = new Expression(27, expression, expression2);
            expression.setLikeEscape(c);
        } else if (this.iToken == 106) {
            this.read();
            Expression expression4 = new Expression(22, expression, this.readConcat());
            this.readThis(28);
            Expression expression5 = new Expression(25, expression, this.readConcat());
            expression = new Expression(28, expression4, expression5);
        } else if (this.iToken == 30) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            Expression expression6 = null;
            if (this.iToken == 103) {
                expression6 = new Expression(this.parseSelect());
                this.read();
            } else {
                this.tTokenizer.back();
                Vector<Object> vector = new Vector<Object>();
                do {
                    vector.addElement(this.getValue(12));
                    this.read();
                } while (this.iToken == 104);
                expression6 = new Expression(vector);
            }
            this.readThis(102);
            expression = new Expression(n, expression, expression6);
        } else {
            Trace.check(!bl, 11);
            if (Expression.isCompare(this.iToken)) {
                int n = this.iToken;
                this.read();
                return new Expression(n, expression, this.readConcat());
            }
            return expression;
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private void readThis(int n) throws SQLException {
        Trace.check(this.iToken == n, 11);
        this.read();
    }

    private Expression readConcat() throws SQLException {
        Expression expression = this.readSum();
        while (this.iToken == 105) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws SQLException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 10;
            } else {
                if (this.iToken != 9) break;
                n = 11;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws SQLException {
        Expression expression = this.readTerm();
        while (this.iToken == 12 || this.iToken == 14) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws SQLException {
        Expression expression = null;
        if (this.iToken == 2) {
            String string = this.sToken;
            expression = new Expression(this.sTable, this.sToken);
            this.read();
            if (this.iToken == 101) {
                Function function = new Function(this.dDatabase.getAlias(string), this.cSession);
                int n = function.getArgCount();
                int n2 = 0;
                this.read();
                if (this.iToken != 102) {
                    while (true) {
                        function.setArgument(n2++, this.readOr());
                        if (this.iToken != 104) break;
                        this.read();
                    }
                }
                this.readThis(102);
                expression = new Expression(function);
            }
        } else if (this.iToken == 9) {
            int n = this.iToken;
            this.read();
            expression = new Expression(n, this.readTerm(), null);
        } else if (this.iToken == 100) {
            this.read();
            expression = this.readTerm();
        } else if (this.iToken == 101) {
            this.read();
            expression = this.readOr();
            if (this.iToken != 102) {
                throw Trace.error(11, this.sToken);
            }
            this.read();
        } else if (this.iToken == 1) {
            expression = new Expression(this.iType, this.oData);
            this.read();
        } else if (this.iToken == 103) {
            expression = new Expression(this.parseSelect());
            this.read();
        } else if (this.iToken == 12) {
            expression = new Expression(this.sTable, null);
            this.read();
        } else if (this.iToken == 60 || this.iToken == 15) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            expression = new Expression(n, expression, this.readOr());
            this.readThis(102);
        } else if (this.iToken == 62) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            Expression expression2 = this.readOr();
            this.readThis(104);
            expression2 = new Expression(n, expression2, this.readOr());
            expression = new Expression(n, expression, expression2);
            this.readThis(102);
        } else if (this.iToken == 61) {
            int n = this.iToken;
            this.read();
            this.readThis(101);
            expression = this.readOr();
            this.readThis(104);
            int n3 = Column.getTypeNr(this.sToken);
            expression = new Expression(n, expression, null);
            expression.setDataType(n3);
            this.read();
            this.readThis(102);
        } else if (this.iToken == 107) {
            this.read();
            this.readThis(101);
            expression = this.readOr();
            Trace.check(this.sToken.equals("AS"), 11, this.sToken);
            this.read();
            int n = Column.getTypeNr(this.sToken);
            expression = new Expression(61, expression, null);
            expression.setDataType(n);
            this.read();
            this.readThis(102);
        } else {
            throw Trace.error(11, this.sToken);
        }
        return expression;
    }

    private void read() throws SQLException {
        this.sToken = this.tTokenizer.getString();
        if (this.tTokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tTokenizer.getAsValue();
            this.iType = this.tTokenizer.getType();
        } else if (this.tTokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tTokenizer.wasLongName()) {
            this.sTable = this.tTokenizer.getLongNameFirst();
            this.sToken = this.tTokenizer.getLongNameLast();
            this.iToken = this.sToken.equals("*") ? 12 : 2;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else if (this.sToken.equals(",")) {
            this.iToken = 104;
        } else if (this.sToken.equals("=")) {
            this.iToken = 21;
        } else if (this.sToken.equals("<>") || this.sToken.equals("!=")) {
            this.iToken = 26;
        } else if (this.sToken.equals("<")) {
            this.iToken = 24;
        } else if (this.sToken.equals(">")) {
            this.iToken = 23;
        } else if (this.sToken.equals("<=")) {
            this.iToken = 25;
        } else if (this.sToken.equals(">=")) {
            this.iToken = 22;
        } else if (this.sToken.equals("AND")) {
            this.iToken = 28;
        } else if (this.sToken.equals("OR")) {
            this.iToken = 29;
        } else if (this.sToken.equals("NOT")) {
            this.iToken = 20;
        } else if (this.sToken.equals("IN")) {
            this.iToken = 30;
        } else if (this.sToken.equals("EXISTS")) {
            this.iToken = 31;
        } else if (this.sToken.equals("BETWEEN")) {
            this.iToken = 106;
        } else if (this.sToken.equals("+")) {
            this.iToken = 100;
        } else if (this.sToken.equals("-")) {
            this.iToken = 9;
        } else if (this.sToken.equals("*")) {
            this.iToken = 12;
            this.sTable = null;
        } else if (this.sToken.equals("/")) {
            this.iToken = 14;
        } else if (this.sToken.equals("||")) {
            this.iToken = 105;
        } else if (this.sToken.equals("(")) {
            this.iToken = 101;
        } else if (this.sToken.equals(")")) {
            this.iToken = 102;
        } else if (this.sToken.equals("SELECT")) {
            this.iToken = 103;
        } else if (this.sToken.equals("IS")) {
            this.sToken = this.tTokenizer.getString();
            if (this.sToken.equals("NOT")) {
                this.iToken = 26;
            } else {
                this.iToken = 21;
                this.tTokenizer.back();
            }
        } else {
            this.iToken = this.sToken.equals("LIKE") ? 27 : (this.sToken.equals("COUNT") ? 40 : (this.sToken.equals("SUM") ? 41 : (this.sToken.equals("MIN") ? 42 : (this.sToken.equals("MAX") ? 43 : (this.sToken.equals("AVG") ? 44 : (this.sToken.equals("IFNULL") ? 60 : (this.sToken.equals("CONVERT") ? 61 : (this.sToken.equals("CAST") ? 107 : (this.sToken.equals("CASEWHEN") ? 62 : (this.sToken.equals("CONCAT") ? 15 : 108))))))))));
        }
    }
}

