/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsqldb.Cache;
import org.hsqldb.Database;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.ReverseTextCache;
import org.hsqldb.Session;
import org.hsqldb.StringConverter;
import org.hsqldb.Table;
import org.hsqldb.TextCache;
import org.hsqldb.Trace;

class Log
implements Runnable {
    private static final int COPY_BLOCK_SIZE = 65536;
    private HsqlDatabaseProperties pProperties;
    private String sName;
    private Database dDatabase;
    private Session sysSession;
    private Writer wScript;
    private File scriptChecker;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private boolean bRestoring;
    private boolean bReadOnly;
    private int iLogSize;
    private int iLogCount;
    private Thread tRunner;
    private volatile boolean bNeedFlush;
    private volatile boolean bWriteDelay;
    private int mLastId;
    private Cache cCache;
    private static final String lineSep = System.getProperty("line.separator", "\n");
    private Hashtable textCacheList = new Hashtable();

    Log(Database database, Session session, String string) throws SQLException {
        this.dDatabase = database;
        this.sysSession = session;
        this.sName = string;
        this.pProperties = database.getProperties();
        this.tRunner = new Thread(this);
        this.tRunner.start();
    }

    public void run() {
        while (this.tRunner != null) {
            try {
                Thread.sleep(1000L);
                if (!this.bNeedFlush) continue;
                this.wScript.flush();
                this.bNeedFlush = false;
            }
            catch (Exception exception) {}
        }
    }

    void setWriteDelay(boolean bl) {
        this.bWriteDelay = bl;
    }

    boolean open() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!this.pProperties.checkFileExists()) {
            this.create();
            this.open();
            return true;
        }
        this.pProperties.load();
        this.sFileScript = this.sName + ".script";
        this.sFileCache = this.sName + ".data";
        this.sFileBackup = this.sName + ".backup";
        this.scriptChecker = new File(this.sFileScript);
        this.iLogSize = this.pProperties.getIntegerProperty("hsqldb.log_size", this.iLogSize);
        String string = this.pProperties.getProperty("hsqldb.compatible_version");
        int n = string.substring(0, 5).compareTo("1.7.1");
        Trace.check(n <= 0, 30);
        this.pProperties.setProperty("hsqldb.version", "1.7.1");
        if (this.pProperties.isPropertyTrue("readonly")) {
            this.bReadOnly = true;
            this.dDatabase.setReadOnly();
            if (this.cCache != null) {
                this.cCache.open(true);
            }
            this.reopenAllTextCaches();
            this.runScript();
            return false;
        }
        boolean bl = false;
        String string2 = this.pProperties.getProperty("modified");
        if (string2.equals("yes-new-files")) {
            this.renameNewToCurrent(this.sFileScript);
            this.renameNewToCurrent(this.sFileBackup);
        } else if (string2.equals("yes")) {
            if (this.isAlreadyOpen()) {
                throw Trace.error(1);
            }
            this.restoreBackup();
            bl = true;
        }
        this.pProperties.setProperty("modified", "yes");
        this.pProperties.save();
        if (this.cCache != null) {
            this.cCache.open(false);
        }
        this.reopenAllTextCaches();
        this.runScript();
        if (bl) {
            this.close(false);
            this.pProperties.setProperty("modified", "yes");
            this.pProperties.save();
            if (this.cCache != null) {
                this.cCache.open(false);
            }
            this.reopenAllTextCaches();
        }
        this.openScript();
        return false;
    }

    Cache getCache() throws SQLException {
        if (this.cCache == null) {
            this.cCache = new Cache(this.sFileCache, this.pProperties);
            this.cCache.open(this.bReadOnly);
        }
        return this.cCache;
    }

    void stop() {
        this.tRunner = null;
    }

    void close(boolean bl) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (this.bReadOnly) {
            return;
        }
        this.closeScript();
        this.writeScript(bl);
        if (this.cCache != null) {
            this.cCache.flush();
        }
        this.closeAllTextCaches(bl);
        this.backup();
        this.pProperties.setProperty("modified", "yes-new-files");
        this.pProperties.save();
        this.renameNewToCurrent(this.sFileScript);
        this.renameNewToCurrent(this.sFileBackup);
        this.pProperties.setProperty("modified", "no");
        this.pProperties.setProperty("version", "1.7.1");
        this.pProperties.setProperty("hsqldb.compatible_version", "1.7.0");
        this.pProperties.save();
        this.pProperties.close();
        if (bl) {
            this.stop();
            new File(this.sFileCache).delete();
            new File(this.sFileBackup).delete();
        }
    }

    void checkpoint() throws SQLException {
        this.close(false);
        this.pProperties.setProperty("modified", "yes");
        this.pProperties.save();
        if (this.cCache != null) {
            this.cCache.open(false);
        }
        this.reopenAllTextCaches();
        this.openScript();
    }

    void setLogSize(int n) {
        this.iLogSize = n;
        this.pProperties.setProperty("hsqldb.log_size", this.iLogSize);
    }

    void write(Session session, String string) throws SQLException {
        if (this.bRestoring || string == null || string.length() == 0) {
            return;
        }
        if (!this.bReadOnly) {
            int n = 0;
            if (session != null) {
                n = session.getId();
            }
            if (n != this.mLastId) {
                string = "/*C" + n + "*/" + string;
                this.mLastId = n;
            }
            try {
                Log.writeLine(this.wScript, string);
                if (this.bWriteDelay) {
                    this.bNeedFlush = true;
                } else {
                    this.wScript.flush();
                }
            }
            catch (IOException iOException) {
                throw Trace.error(29, this.sFileScript);
            }
            if (this.iLogSize > 0 && this.iLogCount++ > 100) {
                this.iLogCount = 0;
                if (this.scriptChecker.length() > (long)(this.iLogSize * 1024 * 1024)) {
                    this.checkpoint();
                }
            }
        }
    }

    void shutdown() throws SQLException {
        this.tRunner = null;
        if (this.cCache != null) {
            this.cCache.closeFile();
            this.cCache = null;
        }
        this.shutdownAllTextCaches();
        this.closeScript();
        this.pProperties.close();
    }

    static void scriptToFile(Database database, String string, boolean bl, Session session) throws SQLException {
        if (new File(string).exists()) {
            throw Trace.error(29, string);
        }
        try {
            long l = 0L;
            if (Trace.TRACE) {
                l = System.currentTimeMillis();
            }
            Result result = bl ? database.getScript(false, false, false, session) : database.getScript(false, false, true, session);
            Record record = result.rRoot;
            FileWriter fileWriter = new FileWriter(string);
            while (record != null) {
                Log.writeLine(fileWriter, (String)record.data[0]);
                record = record.next;
            }
            Vector vector = database.getTables();
            for (int i = 0; i < vector.size(); ++i) {
                Object object;
                Table table = (Table)vector.elementAt(i);
                if (!(!bl && table.isCached() || table.isTemp() || table.isView() || table.isText() && table.isDataReadOnly())) {
                    object = table.getPrimaryIndex();
                    Node node = ((Index)object).first();
                    while (node != null) {
                        Log.writeLine(fileWriter, table.getInsertStatement(node.getData()));
                        node = ((Index)object).next(node);
                    }
                }
                if (!table.isDataReadOnly() || table.isTemp() || table.isText()) continue;
                object = new StringBuffer("SET TABLE ");
                ((StringBuffer)object).append(table.getName().statementName);
                ((StringBuffer)object).append(" READONLY TRUE");
                Log.writeLine(fileWriter, ((StringBuffer)object).toString());
            }
            fileWriter.close();
            if (Trace.TRACE) {
                Trace.trace(l - System.currentTimeMillis());
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, string + " " + iOException);
        }
    }

    private void renameNewToCurrent(String string) {
        File file = new File(string + ".new");
        if (file.exists()) {
            File file2 = new File(string);
            file2.delete();
            file.renameTo(file2);
        }
    }

    private void create() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace(this.sName);
        }
        this.pProperties.setProperty("version", "1.7.1");
        this.pProperties.setProperty("sql.strict_fk", true);
        this.pProperties.save();
    }

    private boolean isAlreadyOpen() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        File file = new File(this.sName + ".lock");
        long l = file.lastModified();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l2 = file.lastModified();
        if (l != l2) {
            return true;
        }
        return this.pProperties.isFileOpen();
    }

    private void backup() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!new File(this.sFileCache).exists()) {
            return;
        }
        try {
            int n;
            long l = 0L;
            if (Trace.TRACE) {
                l = System.currentTimeMillis();
            }
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)new FileOutputStream(this.sFileBackup + ".new"), new Deflater(1), 65536);
            byte[] byArray = new byte[65536];
            FileInputStream fileInputStream = new FileInputStream(this.sFileCache);
            while ((n = fileInputStream.read(byArray, 0, 65536)) != -1) {
                deflaterOutputStream.write(byArray, 0, n);
            }
            deflaterOutputStream.close();
            fileInputStream.close();
            if (Trace.TRACE) {
                Trace.trace(l - System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileBackup);
        }
    }

    private void restoreBackup() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace("not closed last time!");
        }
        if (!new File(this.sFileBackup).exists()) {
            new File(this.sFileCache).delete();
            return;
        }
        try {
            int n;
            long l = 0L;
            if (Trace.TRACE) {
                l = System.currentTimeMillis();
            }
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new FileInputStream(this.sFileBackup), new Inflater());
            FileOutputStream fileOutputStream = new FileOutputStream(this.sFileCache);
            byte[] byArray = new byte[65536];
            while ((n = inflaterInputStream.read(byArray, 0, 65536)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            inflaterInputStream.close();
            if (Trace.TRACE) {
                Trace.trace(l - System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileBackup);
        }
    }

    private void openScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            this.wScript = new BufferedWriter(new FileWriter(this.sFileScript, true), 4096);
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileScript);
        }
    }

    private void closeScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        try {
            if (this.wScript != null) {
                this.wScript.close();
                this.wScript = null;
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileScript);
        }
    }

    private void runScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        if (!new File(this.sFileScript).exists()) {
            return;
        }
        this.bRestoring = true;
        this.dDatabase.setReferentialIntegrity(false);
        Vector<Session> vector = new Vector<Session>();
        vector.addElement(this.sysSession);
        Session session = this.sysSession;
        try {
            String string;
            long l = 0L;
            if (Trace.TRACE) {
                l = System.currentTimeMillis();
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.sFileScript));
            while ((string = Log.readLine(lineNumberReader)) != null) {
                Result result;
                int n;
                if (string.startsWith("/*C")) {
                    n = Integer.parseInt(string.substring(3, string.indexOf(42, 4)));
                    if (n >= vector.size()) {
                        vector.setSize(n + 1);
                    }
                    if ((session = (Session)vector.elementAt(n)) == null) {
                        session = new Session(this.sysSession, n);
                        vector.setElementAt(session, n);
                        this.dDatabase.registerSession(session);
                    }
                    string = string.substring(string.indexOf(47, 1) + 1);
                }
                if (string.length() != 0 && (result = this.dDatabase.execute(string, session)) != null && result.iMode == 1) {
                    throw Trace.getError(result.errorCode, result.sError);
                }
                if (!string.equals("DISCONNECT")) continue;
                n = session.getId();
                session = new Session(this.sysSession, n);
                vector.setElementAt(session, n);
            }
            lineNumberReader.close();
            for (int i = 0; i < vector.size(); ++i) {
                session = (Session)vector.elementAt(i);
                if (session == null) continue;
                session.rollback();
            }
            if (Trace.TRACE) {
                Trace.trace(l - System.currentTimeMillis());
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.sFileScript + " " + iOException);
        }
        this.dDatabase.setReferentialIntegrity(true);
        this.bRestoring = false;
    }

    private void writeScript(boolean bl) throws SQLException {
        if (Trace.TRACE) {
            Trace.trace();
        }
        new File(this.sFileScript + ".new").delete();
        Log.scriptToFile(this.dDatabase, this.sFileScript + ".new", bl, this.sysSession);
    }

    private static int writeLine(Writer writer, String string) throws IOException {
        String string2 = StringConverter.unicodeToAscii(string).append(lineSep).toString();
        writer.write(string2);
        return string2.length();
    }

    private static String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        return StringConverter.asciiToUnicode(string);
    }

    HsqlDatabaseProperties getProperties() {
        return this.pProperties;
    }

    Cache openTextCache(String string, String string2, boolean bl, boolean bl2) throws SQLException {
        String string3;
        this.closeTextCache(string);
        if (this.pProperties.getProperty("textdb.allow_full_path", "false").equals("false")) {
            if (string2.indexOf("..") != -1) {
                throw Trace.error(33, string2);
            }
            string3 = new File(new File(this.sName).getAbsolutePath()).getParent();
            if (string3 != null) {
                string2 = string3 + File.separator + string2;
            }
        }
        string3 = "textdb." + string.toLowerCase() + ".";
        TextCache textCache = bl2 ? new ReverseTextCache(string2, string3, this.pProperties) : new TextCache(string2, string3, this.pProperties);
        textCache.open(bl || this.bReadOnly);
        this.textCacheList.put(string, textCache);
        return textCache;
    }

    void closeTextCache(String string) throws SQLException {
        TextCache textCache = (TextCache)this.textCacheList.remove(string);
        if (textCache != null) {
            textCache.flush();
        }
    }

    void closeAllTextCaches(boolean bl) throws SQLException {
        Enumeration enumeration = this.textCacheList.elements();
        while (enumeration.hasMoreElements()) {
            if (bl) {
                ((TextCache)enumeration.nextElement()).purge();
                continue;
            }
            ((TextCache)enumeration.nextElement()).flush();
        }
    }

    void reopenAllTextCaches() throws SQLException {
        Enumeration enumeration = this.textCacheList.elements();
        while (enumeration.hasMoreElements()) {
            ((TextCache)enumeration.nextElement()).reopen();
        }
    }

    void shutdownAllTextCaches() throws SQLException {
        Enumeration enumeration = this.textCacheList.elements();
        while (enumeration.hasMoreElements()) {
            ((TextCache)enumeration.nextElement()).closeFile();
        }
        this.textCacheList = new Hashtable();
    }
}

