/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

class Like {
    private char[] cLike;
    private int[] iType;
    private int iLen;
    private boolean bIgnoreCase;

    Like(String string, char c, boolean bl) {
        if (bl) {
            string = string.toUpperCase();
        }
        this.normalize(string, true, c);
        this.bIgnoreCase = bl;
    }

    String getStartsWith() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.iLen && this.iType[n] == 0; ++n) {
            stringBuffer.append(this.cLike[n]);
        }
        if (n == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    boolean compare(Object object) {
        if (object == null) {
            return this.iLen == 0;
        }
        String string = object.toString();
        if (this.bIgnoreCase) {
            string = string.toUpperCase();
        }
        return this.compareAt(string, 0, 0, string.length());
    }

    private boolean compareAt(String string, int n, int n2, int n3) {
        while (n < this.iLen) {
            switch (this.iType[n]) {
                case 0: {
                    if (n2 < n3 && this.cLike[n] == string.charAt(n2++)) break;
                    return false;
                }
                case 1: {
                    if (n2++ < n3) break;
                    return false;
                }
                case 2: {
                    if (++n >= this.iLen) {
                        return true;
                    }
                    while (n2 < n3) {
                        if (this.cLike[n] == string.charAt(n2) && this.compareAt(string, n, n2, n3)) {
                            return true;
                        }
                        ++n2;
                    }
                    return false;
                }
            }
            ++n;
        }
        return n2 == n3;
    }

    private void normalize(String string, boolean bl, char c) {
        int n;
        this.iLen = 0;
        if (string == null) {
            return;
        }
        int n2 = string.length();
        this.cLike = new char[n2];
        this.iType = new int[n2];
        boolean bl2 = false;
        boolean bl3 = false;
        for (n = 0; n < n2; ++n) {
            char c2 = string.charAt(n);
            if (!bl2) {
                if (bl && c2 == c) {
                    bl2 = true;
                    continue;
                }
                if (c2 == '_') {
                    this.iType[this.iLen] = 1;
                } else if (c2 == '%') {
                    if (bl3) continue;
                    bl3 = true;
                    this.iType[this.iLen] = 2;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = false;
                bl2 = false;
            }
            this.cLike[this.iLen++] = c2;
        }
        for (n = 0; n < this.iLen - 1; ++n) {
            if (this.iType[n] != 2 || this.iType[n + 1] != 1) continue;
            this.iType[n] = 1;
            this.iType[n + 1] = 2;
        }
    }
}

