/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;

class DatabaseScript {
    DatabaseScript() {
    }

    static Result getScript(Database database, boolean bl, boolean bl2, boolean bl3, Session session) throws SQLException {
        int n;
        int n2;
        Object object;
        StringBuffer stringBuffer;
        Object object2;
        int n3;
        Vector vector = database.getTables();
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        session.checkAdmin();
        Result result = new Result(1);
        result.colType[0] = 12;
        result.sTable[0] = "SYSTEM_SCRIPT";
        result.sLabel[0] = "COMMAND";
        result.sName[0] = "COMMAND";
        int n4 = vector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (Table)vector.elementAt(n3);
            if (((Table)object2).isTemp() || ((Table)object2).isView()) continue;
            if (bl) {
                DatabaseScript.addRow(result, "DROP TABLE " + ((Table)object2).getName().statementName);
            }
            stringBuffer = new StringBuffer(128);
            DatabaseScript.getTableDDL(database, (Table)object2, n3, vector2, vector3, stringBuffer);
            DatabaseScript.addRow(result, stringBuffer.toString());
            for (int i = 1; i < ((Table)object2).getIndexCount(); ++i) {
                Index index = ((Table)object2).getIndex(i);
                if (HsqlName.isReservedName(index.getName().name)) continue;
                stringBuffer = new StringBuffer(64);
                stringBuffer.append("CREATE ");
                if (index.isUnique()) {
                    stringBuffer.append("UNIQUE ");
                }
                stringBuffer.append("INDEX ");
                stringBuffer.append(index.getName().statementName);
                stringBuffer.append(" ON ");
                stringBuffer.append(((Table)object2).getName().statementName);
                int[] nArray = index.getColumns();
                int n5 = index.getVisibleColumns();
                DatabaseScript.getColumnList((Table)object2, nArray, n5, stringBuffer);
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
            if (((Table)object2).isText() && ((Table)object2).isDataReadOnly()) {
                stringBuffer = new StringBuffer("SET TABLE ");
                stringBuffer.append(((Table)object2).getName().statementName);
                stringBuffer.append(" READONLY TRUE");
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
            if ((object = DatabaseScript.getDataSource((Table)object2)) != null) {
                DatabaseScript.addRow(result, (String)object);
            }
            int n6 = TriggerDef.numTrigs();
            for (int i = 0; i < n6; ++i) {
                Vector vector4 = ((Table)object2).vTrigs[i];
                int n7 = vector4.size();
                for (n2 = 0; n2 < n7; ++n2) {
                    stringBuffer = ((TriggerDef)vector4.elementAt(n2)).toBuf();
                    DatabaseScript.addRow(result, stringBuffer.toString());
                }
            }
        }
        n4 = vector2.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (Constraint)vector2.elementAt(n3);
            stringBuffer = new StringBuffer(128);
            stringBuffer.append("ALTER TABLE ");
            stringBuffer.append(((Constraint)object2).getRef().getName().statementName);
            stringBuffer.append(" ADD ");
            DatabaseScript.getFKStatement((Constraint)object2, stringBuffer);
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        n4 = vector.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = (Table)vector.elementAt(n3);
            if (!bl3 || !((Table)object2).isCached()) continue;
            DatabaseScript.addRow(result, DatabaseScript.getIndexRootsDDL((Table)vector.elementAt(n3)));
        }
        Vector vector5 = database.getUserManager().getUsers();
        int n8 = vector5.size();
        for (n4 = 0; n4 < n8; ++n4) {
            Hashtable hashtable;
            object = (User)vector5.elementAt(n4);
            if (object == null) continue;
            String string = ((User)object).getName();
            if (!string.equals("PUBLIC")) {
                stringBuffer = new StringBuffer(128);
                stringBuffer.append("CREATE USER ");
                stringBuffer.append(string);
                stringBuffer.append(" PASSWORD ");
                stringBuffer.append('\"');
                stringBuffer.append(((User)object).getPassword());
                stringBuffer.append('\"');
                if (((User)object).isAdmin()) {
                    stringBuffer.append(" ADMIN");
                }
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
            if ((hashtable = ((User)object).getRights()) == null) continue;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                n2 = (Integer)hashtable.get(string2);
                if (n2 == 0) continue;
                stringBuffer = new StringBuffer(64);
                stringBuffer.append("GRANT ");
                stringBuffer.append(UserManager.getRight(n2));
                stringBuffer.append(" ON ");
                stringBuffer.append(string2);
                stringBuffer.append(" TO ");
                stringBuffer.append(((User)object).getName());
                DatabaseScript.addRow(result, stringBuffer.toString());
            }
        }
        if (database.isIgnoreCase()) {
            DatabaseScript.addRow(result, "SET IGNORECASE TRUE");
        }
        Hashtable hashtable = database.getAlias();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)hashtable.get(object);
            StringBuffer stringBuffer2 = new StringBuffer(64);
            stringBuffer2.append("CREATE ALIAS ");
            stringBuffer2.append((String)object);
            stringBuffer2.append(" FOR \"");
            stringBuffer2.append(string);
            stringBuffer2.append('\"');
            DatabaseScript.addRow(result, stringBuffer2.toString());
        }
        int n9 = vector.size();
        for (n = 0; n < n9; ++n) {
            Table table = (Table)vector.elementAt(n);
            if (!table.isView()) continue;
            View view = (View)vector.elementAt(n);
            if (bl) {
                DatabaseScript.addRow(result, "DROP VIEW " + view.getName().name);
            }
            stringBuffer = new StringBuffer(128);
            stringBuffer.append("CREATE ");
            stringBuffer.append("VIEW ");
            stringBuffer.append(view.getName().statementName);
            stringBuffer.append(" AS ");
            stringBuffer.append(view.getStatement());
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        n9 = vector.size();
        for (n = 0; n < n9; ++n) {
            Table table = (Table)vector.elementAt(n);
            if (!bl2 || table.isTemp() || table.isView() || table.isCached && !bl3 || table.isText() && table.isDataReadOnly()) continue;
            Index index = table.getPrimaryIndex();
            Node node = index.first();
            n2 = 1;
            if (node != null) {
                n2 = 0;
            }
            while (node != null) {
                DatabaseScript.addRow(result, table.getInsertStatement(node.getData()));
                node = index.next(node);
            }
            if (!table.isDataReadOnly()) continue;
            stringBuffer = new StringBuffer("SET TABLE ");
            stringBuffer.append(table.getName().statementName);
            stringBuffer.append(" READONLY TRUE");
            DatabaseScript.addRow(result, stringBuffer.toString());
        }
        return result;
    }

    static String getIndexRootsDDL(Table table) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET TABLE ");
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(" INDEX '");
        stringBuffer.append(table.getIndexRoots());
        stringBuffer.append('\'');
        return stringBuffer.toString();
    }

    static void getTableDDL(Database database, Table table, int n, Vector vector, Vector vector2, StringBuffer stringBuffer) throws SQLException {
        Object object;
        stringBuffer.append("CREATE ");
        if (table.isText()) {
            stringBuffer.append("TEXT ");
        } else if (table.isCached()) {
            stringBuffer.append("CACHED ");
        }
        stringBuffer.append("TABLE ");
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append('(');
        int n2 = table.getColumnCount();
        Index index = table.getIndex(0);
        int[] nArray = index.getColumns();
        for (int i = 0; i < n2; ++i) {
            Column column = table.getColumn(i);
            String string = column.columnName.statementName;
            stringBuffer.append(string);
            stringBuffer.append(' ');
            object = Column.getTypeString(column.getType());
            stringBuffer.append((String)object);
            if (column.getSize() > 0) {
                stringBuffer.append('(');
                stringBuffer.append(column.getSize());
                if (column.getScale() > 0) {
                    stringBuffer.append(',');
                    stringBuffer.append(column.getScale());
                }
                stringBuffer.append(')');
            }
            if (column.getDefaultString() != null) {
                stringBuffer.append(" DEFAULT ");
                stringBuffer.append(Column.createSQLString(column.getDefaultString()));
            }
            if (!column.isNullable()) {
                stringBuffer.append(" NOT NULL");
            }
            if (i == table.getIdentityColumn()) {
                stringBuffer.append(" IDENTITY");
            }
            if (nArray.length == 1 && i == nArray[0]) {
                stringBuffer.append(" PRIMARY KEY");
            }
            if (i >= n2 - 1) continue;
            stringBuffer.append(',');
        }
        if (nArray.length > 1) {
            stringBuffer.append(",CONSTRAINT ");
            stringBuffer.append(index.getName().statementName);
            stringBuffer.append(" PRIMARY KEY");
            DatabaseScript.getColumnList(table, nArray, nArray.length, stringBuffer);
        }
        Vector vector3 = table.getConstraints();
        int n3 = vector3.size();
        for (int i = 0; i < n3; ++i) {
            Object object2;
            object = (Constraint)vector3.elementAt(i);
            if (((Constraint)object).getType() == 2) {
                stringBuffer.append(",CONSTRAINT ");
                stringBuffer.append(((Constraint)object).getName().statementName);
                stringBuffer.append(" UNIQUE");
                object2 = ((Constraint)object).getMainColumns();
                DatabaseScript.getColumnList(((Constraint)object).getMain(), (int[])object2, ((Object)object2).length, stringBuffer);
                continue;
            }
            if (((Constraint)object).getType() != 0) continue;
            object2 = ((Constraint)object).getMain();
            int n4 = database.getTableIndex((Table)object2);
            if (n4 > n) {
                if (n >= vector2.size()) {
                    vector2.setSize(n + 1);
                }
                vector2.setElementAt(object, n);
                vector.addElement(object);
                continue;
            }
            stringBuffer.append(',');
            DatabaseScript.getFKStatement((Constraint)object, stringBuffer);
        }
        stringBuffer.append(')');
    }

    static String getDataSource(Table table) throws SQLException {
        String string = table.getDataSource();
        if (string == null) {
            return null;
        }
        boolean bl = table.isDescDataSource();
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("SET TABLE ");
        stringBuffer.append(table.getName().statementName);
        stringBuffer.append(" SOURCE \"");
        stringBuffer.append(string);
        stringBuffer.append('\"');
        if (bl) {
            stringBuffer.append(" DESC");
        }
        return stringBuffer.toString();
    }

    private static void getColumnList(Table table, int[] nArray, int n, StringBuffer stringBuffer) {
        stringBuffer.append('(');
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(table.getColumn((int)nArray[i]).columnName.statementName);
            if (i >= n - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(')');
    }

    private static void getFKStatement(Constraint constraint, StringBuffer stringBuffer) {
        stringBuffer.append("CONSTRAINT ");
        stringBuffer.append(constraint.getName().statementName);
        stringBuffer.append(" FOREIGN KEY");
        int[] nArray = constraint.getRefColumns();
        DatabaseScript.getColumnList(constraint.getRef(), nArray, nArray.length, stringBuffer);
        stringBuffer.append(" REFERENCES ");
        stringBuffer.append(constraint.getMain().getName().statementName);
        nArray = constraint.getMainColumns();
        DatabaseScript.getColumnList(constraint.getMain(), nArray, nArray.length, stringBuffer);
        if (constraint.isCascade()) {
            stringBuffer.append(" ON DELETE CASCADE");
        }
    }

    private static void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }
}

