/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Table;
import org.hsqldb.Trace;

abstract class DatabaseRowOutput
extends DataOutputStream
implements DatabaseRowOutputInterface {
    protected boolean skipSystemId = false;

    public DatabaseRowOutput(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public abstract void writePos(int var1) throws IOException;

    public abstract void writeSize(int var1) throws IOException;

    public abstract void writeType(int var1) throws IOException;

    public abstract void writeIntData(int var1) throws IOException;

    public abstract void writeString(String var1) throws IOException;

    protected abstract void writeFieldType(int var1) throws IOException;

    protected abstract void writeNull(int var1) throws IOException;

    protected abstract void writeChar(String var1, int var2) throws IOException;

    protected abstract void writeSmallint(Number var1) throws IOException, SQLException;

    protected abstract void writeInteger(Number var1) throws IOException, SQLException;

    protected abstract void writeBigint(Number var1) throws IOException, SQLException;

    protected abstract void writeReal(Double var1, int var2) throws IOException, SQLException;

    protected abstract void writeDecimal(BigDecimal var1) throws IOException, SQLException;

    protected abstract void writeBit(Boolean var1) throws IOException, SQLException;

    protected abstract void writeDate(Date var1) throws IOException, SQLException;

    protected abstract void writeTime(Time var1) throws IOException, SQLException;

    protected abstract void writeTimestamp(Timestamp var1) throws IOException, SQLException;

    protected abstract void writeOther(Object var1) throws IOException, SQLException;

    protected abstract void writeBinary(byte[] var1, int var2) throws IOException, SQLException;

    public void writeData(Object[] objectArray, Table table) throws IOException, SQLException {
        int[] nArray = table.getColumnTypes();
        int n = nArray.length;
        if (this.skipSystemId) {
            --n;
        }
        this.writeData(n, nArray, objectArray);
    }

    public void writeData(int n, int[] nArray, Object[] objectArray) throws IOException, SQLException {
        block14: for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            int n2 = nArray[i];
            if (object == null) {
                this.writeNull(n2);
                continue;
            }
            this.writeFieldType(n2);
            switch (n2) {
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    this.writeChar((String)object, n2);
                    continue block14;
                }
                case -6: 
                case 5: {
                    this.writeSmallint((Number)object);
                    continue block14;
                }
                case 4: {
                    this.writeInteger((Number)object);
                    continue block14;
                }
                case -5: {
                    this.writeBigint((Number)object);
                    continue block14;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.writeReal((Double)object, n2);
                    continue block14;
                }
                case 2: 
                case 3: {
                    this.writeDecimal((BigDecimal)object);
                    continue block14;
                }
                case -7: {
                    this.writeBit((Boolean)object);
                    continue block14;
                }
                case 91: {
                    this.writeDate((Date)object);
                    continue block14;
                }
                case 92: {
                    this.writeTime((Time)object);
                    continue block14;
                }
                case 93: {
                    this.writeTimestamp((Timestamp)object);
                    continue block14;
                }
                case 1111: {
                    this.writeOther(object);
                    continue block14;
                }
                case -4: 
                case -3: 
                case -2: {
                    this.writeBinary((byte[])object, n2);
                    continue block14;
                }
                default: {
                    throw Trace.error(20, n2);
                }
            }
        }
    }
}

