/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.Trace;

abstract class DatabaseRowInput
extends DataInputStream {
    static final int NO_POS = -1;
    protected int pos = -1;
    protected int nextPos = -1;
    protected int size;
    protected boolean makeSystemId = false;

    public DatabaseRowInput(InputStream inputStream) {
        super(inputStream);
    }

    public DatabaseRowInput(byte[] byArray, int n) throws IOException {
        this(new ByteArrayInputStream(byArray));
        this.pos = n;
        this.size = byArray.length;
    }

    public int getPos() throws IOException {
        if (this.pos == -1) {
            throw new IOException("No position specified");
        }
        return this.pos;
    }

    public int getNextPos() throws IOException {
        if (this.nextPos == -1) {
            throw new IOException("No next position specified");
        }
        return this.nextPos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readIntData() throws IOException;

    public abstract int readType() throws IOException;

    public abstract String readString() throws IOException;

    protected abstract boolean checkNull() throws IOException;

    protected abstract String readChar(int var1) throws IOException, SQLException;

    protected abstract Integer readSmallint() throws IOException, SQLException;

    protected abstract Integer readInteger() throws IOException, SQLException;

    protected abstract Long readBigint() throws IOException, SQLException;

    protected abstract Double readReal(int var1) throws IOException, SQLException;

    protected abstract BigDecimal readDecimal() throws IOException, SQLException;

    protected abstract Boolean readBit() throws IOException, SQLException;

    protected abstract Time readTime() throws IOException, SQLException;

    protected abstract Date readDate() throws IOException, SQLException;

    protected abstract Timestamp readTimestamp() throws IOException, SQLException;

    protected abstract Object readOther() throws IOException, SQLException;

    protected abstract byte[] readBinary(int var1) throws IOException, SQLException;

    public Object[] readData(int[] nArray) throws IOException, SQLException {
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        if (this.makeSystemId) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            if (this.checkNull()) continue;
            Object object = null;
            int n2 = nArray[i];
            switch (n2) {
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    object = this.readChar(n2);
                    break;
                }
                case -6: 
                case 5: {
                    object = this.readSmallint();
                    break;
                }
                case 4: {
                    object = this.readInteger();
                    break;
                }
                case -5: {
                    object = this.readBigint();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    object = this.readReal(n2);
                    break;
                }
                case 2: 
                case 3: {
                    object = this.readDecimal();
                    break;
                }
                case 91: {
                    object = this.readDate();
                    break;
                }
                case 92: {
                    object = this.readTime();
                    break;
                }
                case 93: {
                    object = this.readTimestamp();
                    break;
                }
                case -7: {
                    object = this.readBit();
                    break;
                }
                case 1111: {
                    object = this.readOther();
                    break;
                }
                case -4: 
                case -3: 
                case -2: {
                    object = this.readBinary(n2);
                    break;
                }
                default: {
                    throw Trace.error(20, n2);
                }
            }
            objectArray[i] = object;
        }
        if (this.makeSystemId) {
            objectArray[n] = new Integer(this.getPos());
        }
        return objectArray;
    }
}

