/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.User;
import org.hsqldb.UserManager;

class DatabaseInformation {
    private Database dDatabase;
    private UserManager aAccess;
    private Vector tTable;
    private static final Integer INTEGER_0 = new Integer(0);
    static final String META_SCHEM = "SCHEM";
    static final String META_CAT = "CAT";
    static final String META_COLUMN_SIZE = "COLUMN_SIZE";
    static final String META_BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String META_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String META_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String META_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    static final String META_ORDINAL_POSITION = "ORDINAL_POSITION";
    static final String META_ASC_OR_DESC = "ASC_OR_DESC";
    private static Hashtable sysTableNames;
    private static final int SYSTEM_PROCEDURES = 1;
    private static final int SYSTEM_PROCEDURECOLUMNS = 2;
    private static final int SYSTEM_TABLES = 3;
    private static final int SYSTEM_SCHEMAS = 4;
    private static final int SYSTEM_CATALOGS = 5;
    private static final int SYSTEM_TABLETYPES = 6;
    private static final int SYSTEM_COLUMNS = 7;
    private static final int SYSTEM_COLUMNPRIVILEGES = 8;
    private static final int SYSTEM_TABLEPRIVILEGES = 9;
    private static final int SYSTEM_BESTROWIDENTIFIER = 10;
    private static final int SYSTEM_VERSIONCOLUMNS = 11;
    private static final int SYSTEM_PRIMARYKEYS = 12;
    private static final int SYSTEM_IMPORTEDKEYS = 13;
    private static final int SYSTEM_EXPORTEDKEYS = 14;
    private static final int SYSTEM_CROSSREFERENCE = 15;
    private static final int SYSTEM_TYPEINFO = 16;
    private static final int SYSTEM_INDEXINFO = 17;
    private static final int SYSTEM_UDTS = 18;
    private static final int SYSTEM_CONNECTIONINFO = 19;
    private static final int SYSTEM_USERS = 20;
    private static final String[] tableTypes;
    static final Short importedKeyNoActionShort;
    static final Short importedKeyCascadeShort;
    static final Short importedKeyNotDeferrableShort;

    DatabaseInformation(Database database, Vector vector, UserManager userManager) {
        this.dDatabase = database;
        this.tTable = vector;
        this.aAccess = userManager;
    }

    static boolean isSystemTable(String string) {
        return sysTableNames.get(string) != null;
    }

    Table getSystemTable(String string, Session session) throws SQLException {
        HsqlName hsqlName = new HsqlName(string, false);
        Integer n = (Integer)sysTableNames.get(string);
        if (n == null) {
            return null;
        }
        int n2 = n;
        Table table = this.createTable(hsqlName);
        switch (n2) {
            case 1: {
                table.addColumn("PROCEDURE_CAT", 12);
                table.addColumn("PROCEDURE_SCHEM", 12);
                table.addColumn("PROCEDURE_NAME", 12);
                table.addColumn("NUM_INPUT_PARAMS", 4);
                table.addColumn("NUM_OUTPUT_PARAMS", 4);
                table.addColumn("NUM_RESULT_SETS", 4);
                table.addColumn("REMARKS", 12);
                table.addColumn("PROCEDURE_TYPE", 5);
                table.createPrimaryKey();
                return table;
            }
            case 2: {
                table.addColumn("PROCEDURE_CAT", 12);
                table.addColumn("PROCEDURE_SCHEM", 12);
                table.addColumn("PROCEDURE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("COLUMN_TYPE", 5);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn("PRECISION", 4);
                table.addColumn("LENGTH", 4);
                table.addColumn("SCALE", 5);
                table.addColumn("RADIX", 5);
                table.addColumn("NULLABLE", 5);
                table.addColumn("REMARKS", 12);
                table.createPrimaryKey();
                return table;
            }
            case 3: {
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("TABLE_TYPE", 12);
                table.addColumn("REMARKS", 12);
                table.addColumn("TYPE_CAT", 12);
                table.addColumn("TYPE_SCHEM", 12);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn("SELF_REFERENCING_COL_NAME", 12);
                table.addColumn("REF_GENERATION", 12);
                table.createPrimaryKey();
                int n3 = this.tTable.size();
                block23: for (int i = 0; i < n3; ++i) {
                    String string2;
                    Table table2 = (Table)this.tTable.elementAt(i);
                    Object[] objectArray = table.getNewRow();
                    objectArray[1] = "";
                    objectArray[0] = "";
                    objectArray[2] = table2.getName().name;
                    switch (table2.tableType) {
                        case 6: {
                            objectArray[3] = "VIEW";
                            break;
                        }
                        case 1: 
                        case 4: {
                            if (this.dDatabase.findUserTable(table2.getName().name, session) == null) continue block23;
                            objectArray[3] = "GLOBAL TEMPORARY";
                            break;
                        }
                        default: {
                            objectArray[3] = "TABLE";
                        }
                    }
                    if (table2.isDataReadOnly()) {
                        objectArray[4] = "ReadOnlyData=true";
                    }
                    if ((string2 = table2.getDataSource()) != null) {
                        objectArray[4] = objectArray[4] == null ? "" : objectArray[4] + "; ";
                        objectArray[4] = objectArray[4] + "DataSource=\"" + string2 + "\"";
                        if (table2.isDescDataSource()) {
                            objectArray[4] = objectArray[4] + " DESC";
                        }
                    }
                    table.insert(objectArray, null);
                }
                return table;
            }
            case 4: {
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_CATALOG", 12);
                table.createPrimaryKey();
                return table;
            }
            case 5: {
                table.addColumn("TABLE_CAT", 12);
                table.createPrimaryKey();
                return table;
            }
            case 6: {
                table.addColumn("TABLE_TYPE", 12);
                table.createPrimaryKey();
                for (int i = 0; i < tableTypes.length; ++i) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[0] = tableTypes[i];
                    table.insert(objectArray, null);
                }
                return table;
            }
            case 7: {
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn(META_COLUMN_SIZE, 4);
                table.addColumn(META_BUFFER_LENGTH, 4);
                table.addColumn(META_DECIMAL_DIGITS, 4);
                table.addColumn(META_NUM_PREC_RADIX, 4);
                table.addColumn("NULLABLE", 4);
                table.addColumn("REMARKS", 12);
                table.addColumn("COLUMN_DEF", 12);
                table.addColumn("SQL_DATA_TYPE", 4);
                table.addColumn("SQL_DATETIME_SUB", 4);
                table.addColumn("CHAR_OCTET_LENGTH", 4);
                table.addColumn(META_ORDINAL_POSITION, 4);
                table.addColumn("IS_NULLABLE", 12);
                table.addColumn("SCOPE_CATLOG", 12);
                table.addColumn("SCOPE_SCHEMA", 12);
                table.addColumn("SCOPE_TABLE", 12);
                table.addColumn("SOURCE_DATA_TYPE", 12);
                table.addColumn("SCOPE_CATLOG ", 5);
                table.createPrimaryKey();
                int n4 = this.tTable.size();
                for (int i = 0; i < n4; ++i) {
                    Table table3 = (Table)this.tTable.elementAt(i);
                    int n5 = table3.getColumnCount();
                    if ((table3.tableType == 1 || table3.tableType == 4) && this.dDatabase.findUserTable(table3.getName().name, session) == null) continue;
                    for (int j = 0; j < n5; ++j) {
                        int n6;
                        Column column = table3.getColumn(j);
                        Object[] objectArray = table.getNewRow();
                        objectArray[1] = "";
                        objectArray[0] = "";
                        objectArray[2] = table3.getName().name;
                        objectArray[3] = column.columnName.name;
                        objectArray[4] = new Integer(column.getType());
                        objectArray[5] = Column.getTypeString(column.getType());
                        objectArray[6] = new Integer(column.getSize());
                        objectArray[8] = new Integer(column.getScale());
                        objectArray[9] = new Integer(10);
                        if (column.isNullable()) {
                            n6 = 1;
                            objectArray[17] = new String("YES");
                        } else {
                            n6 = 0;
                            objectArray[17] = new String("NO");
                        }
                        objectArray[10] = new Integer(n6);
                        if (table3.getIdentityColumn() == j) {
                            objectArray[11] = "IDENTITY";
                        }
                        objectArray[12] = column.getDefaultString();
                        objectArray[16] = new Integer(j + 1);
                        table.insert(objectArray, null);
                    }
                }
                return table;
            }
            case 8: {
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("GRANTOR", 12);
                table.addColumn("GRANTEE", 12);
                table.addColumn("PRIVILEGE", 12);
                table.addColumn("IS_GRANTABLE", 12);
                table.createPrimaryKey();
                return table;
            }
            case 9: {
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("GRANTOR", 12);
                table.addColumn("GRANTEE", 12);
                table.addColumn("PRIVILEGE", 12);
                table.addColumn("IS_GRANTABLE", 12);
                table.createPrimaryKey();
                int n7 = this.tTable.size();
                for (int i = 0; i < n7; ++i) {
                    Table table4 = (Table)this.tTable.elementAt(i);
                    if ((table4.tableType == 1 || table4.tableType == 4) && this.dDatabase.findUserTable(table4.getName().name, session) == null) continue;
                    Object[] objectArray = table.getNewRow();
                    objectArray[1] = "";
                    objectArray[0] = "";
                    objectArray[2] = table4.getName().name;
                    objectArray[3] = "sa";
                    objectArray[5] = "FULL";
                    table.insert(objectArray, null);
                }
                return table;
            }
            case 10: 
            case 11: {
                table.addColumn("SCOPE", 5);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn(META_COLUMN_SIZE, 4);
                table.addColumn(META_BUFFER_LENGTH, 4);
                table.addColumn(META_DECIMAL_DIGITS, 5);
                table.addColumn("PSEUDO_COLUMN", 5);
                table.addColumn("TABLE_NAME", 12);
                table.createPrimaryKey();
                if (n2 == 11) {
                    return table;
                }
                int n8 = this.tTable.size();
                for (int i = 0; i < n8; ++i) {
                    int n9;
                    Table table5 = (Table)this.tTable.elementAt(i);
                    if (table5.tableType == 6 || (table5.tableType == 1 || table5.tableType == 4) && this.dDatabase.findUserTable(table5.getName().name, session) == null) continue;
                    Index index = null;
                    int[] nArray = null;
                    for (n9 = 0; n9 < table5.getIndexCount(); ++n9) {
                        index = table5.getIndex(n9);
                        if (!index.isUnique()) continue;
                        nArray = index.getColumns();
                        if (nArray[0] != table5.getColumnCount()) break;
                        nArray = null;
                    }
                    if (nArray == null) continue;
                    n9 = nArray.length;
                    for (int j = 0; j < n9; ++j) {
                        Column column = table5.getColumn(nArray[j]);
                        Object[] objectArray = table.getNewRow();
                        objectArray[0] = new Short(0);
                        objectArray[1] = column.columnName.name;
                        objectArray[2] = new Short((short)column.getType());
                        objectArray[3] = Column.getTypeString(column.getType());
                        objectArray[4] = new Integer(column.getSize());
                        objectArray[6] = new Integer(column.getScale());
                        objectArray[7] = new Short(1);
                        objectArray[8] = table5.getName().name;
                        table.insert(objectArray, null);
                    }
                }
                return table;
            }
            case 12: {
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn("KEY_SEQ", 5);
                table.addColumn("PK_NAME", 12);
                table.createPrimaryKey();
                int n10 = this.tTable.size();
                for (int i = 0; i < n10; ++i) {
                    Index index;
                    int[] nArray;
                    Table table6 = (Table)this.tTable.elementAt(i);
                    if (table6.tableType == 6 || (table6.tableType == 1 || table6.tableType == 4) && this.dDatabase.findUserTable(table6.getName().name, session) == null || (nArray = (index = table6.getIndex(0)).getColumns())[0] == table6.getColumnCount()) continue;
                    int n11 = nArray.length;
                    for (int j = 0; j < n11; ++j) {
                        Object[] objectArray = table.getNewRow();
                        objectArray[1] = "";
                        objectArray[0] = "";
                        objectArray[2] = table6.getName().name;
                        objectArray[3] = table6.getColumn((int)nArray[j]).columnName.name;
                        objectArray[4] = new Integer(j + 1);
                        objectArray[5] = index.getName().name;
                        table.insert(objectArray, null);
                    }
                }
                return table;
            }
            case 13: 
            case 14: 
            case 15: {
                return this.getCrossReference(hsqlName, session);
            }
            case 16: {
                table.addColumn("TYPE_NAME", 12);
                table.addColumn("DATA_TYPE", 5);
                table.addColumn("PRECISION", 4);
                table.addColumn("LITERAL_PREFIX", 12);
                table.addColumn("LITERAL_SUFFIX", 12);
                table.addColumn("CREATE_PARAMS", 12);
                table.addColumn("NULLABLE", 5);
                table.addColumn("CASE_SENSITIVE", -7);
                table.addColumn("SEARCHABLE", 5);
                table.addColumn("UNSIGNED_ATTRIBUTE", -7);
                table.addColumn(META_FIXED_PREC_SCALE, -7);
                table.addColumn("AUTO_INCREMENT", -7);
                table.addColumn("LOCAL_TYPE_NAME", 12);
                table.addColumn("MINIMUM_SCALE", 5);
                table.addColumn("MAXIMUM_SCALE", 5);
                table.addColumn("SQL_DATE_TYPE", 4);
                table.addColumn("SQL_DATETIME_SUB", 4);
                table.addColumn(META_NUM_PREC_RADIX, 4);
                table.createPrimaryKey();
                for (int i = 0; i < Column.typesArray.length; ++i) {
                    for (int j = 0; j < Column.typesArray[i].length; ++j) {
                        Object[] objectArray = table.getNewRow();
                        int n12 = Column.typesArray[i][j];
                        objectArray[0] = Column.getTypeString(n12);
                        objectArray[1] = new Integer(n12);
                        objectArray[2] = INTEGER_0;
                        objectArray[6] = new Integer(1);
                        objectArray[7] = new Boolean(true);
                        objectArray[8] = new Integer(3);
                        objectArray[9] = new Boolean(false);
                        objectArray[10] = new Boolean(n12 == 2 || n12 == 3);
                        objectArray[11] = new Boolean(n12 == 4);
                        objectArray[12] = objectArray[0];
                        objectArray[13] = INTEGER_0;
                        objectArray[14] = INTEGER_0;
                        objectArray[17] = new Integer(10);
                        table.insert(objectArray, null);
                    }
                }
                return table;
            }
            case 17: {
                table.addColumn("TABLE_CAT", 12);
                table.addColumn("TABLE_SCHEM", 12);
                table.addColumn("TABLE_NAME", 12);
                table.addColumn("NON_UNIQUE", -7);
                table.addColumn("INDEX_QUALIFIER", 12);
                table.addColumn("INDEX_NAME", 12);
                table.addColumn("TYPE", 5);
                table.addColumn(META_ORDINAL_POSITION, 5);
                table.addColumn("COLUMN_NAME", 12);
                table.addColumn(META_ASC_OR_DESC, 12);
                table.addColumn("CARDINALITY", 4);
                table.addColumn("PAGES", 4);
                table.addColumn("FILTER_CONDITION", 12);
                table.createPrimaryKey();
                int n13 = this.tTable.size();
                for (int i = 0; i < n13; ++i) {
                    Table table7 = (Table)this.tTable.elementAt(i);
                    for (int j = 0; j < table7.getIndexCount(); ++j) {
                        Index index = table7.getIndex(j);
                        int[] nArray = index.getColumns();
                        int n14 = index.getVisibleColumns();
                        if (n14 == 0) continue;
                        for (int k = 0; k < n14; ++k) {
                            Object[] objectArray = table.getNewRow();
                            objectArray[1] = "";
                            objectArray[0] = "";
                            objectArray[2] = table7.getName().name;
                            objectArray[3] = new Boolean(!index.isUnique());
                            objectArray[5] = index.getName().name;
                            objectArray[6] = new Integer(3);
                            objectArray[7] = new Integer(k + 1);
                            objectArray[8] = table7.getColumn((int)nArray[k]).columnName.name;
                            objectArray[9] = "A";
                            table.insert(objectArray, null);
                        }
                    }
                }
                return table;
            }
            case 18: {
                table.addColumn("TYPE_CAT", 12);
                table.addColumn("TYPE_SCHEM", 12);
                table.addColumn("TYPE_NAME", 12);
                table.addColumn("CLASS_NAME", -7);
                table.addColumn("DATA_TYPE", 12);
                table.addColumn("REMARKS", 12);
                table.addColumn("BASE_TYPE ", 5);
                table.createPrimaryKey();
                return table;
            }
            case 19: {
                table.addColumn("KEY", 12);
                table.addColumn("VALUE", 12);
                table.createPrimaryKey();
                Object[] objectArray = table.getNewRow();
                objectArray[0] = "USER";
                objectArray[1] = session.getUsername();
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "READONLY";
                objectArray[1] = session.isReadOnly() ? "TRUE" : "FALSE";
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "MAXROWS";
                objectArray[1] = String.valueOf(session.getMaxRows());
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "DATABASE";
                objectArray[1] = session.getDatabase().getName();
                table.insert(objectArray, null);
                objectArray = table.getNewRow();
                objectArray[0] = "IDENTITY";
                objectArray[1] = String.valueOf(session.getLastIdentity());
                table.insert(objectArray, null);
                return table;
            }
            case 20: {
                table.addColumn("USER", 12);
                table.addColumn("ADMIN", -7);
                table.createPrimaryKey();
                Vector vector = this.aAccess.getUsers();
                int n15 = vector.size();
                for (int i = 0; i < n15; ++i) {
                    String string3;
                    User user = (User)vector.elementAt(i);
                    if (user == null || (string3 = user.getName()).equals("PUBLIC")) continue;
                    Object[] objectArray = table.getNewRow();
                    objectArray[0] = string3;
                    objectArray[1] = new Boolean(user.isAdmin());
                    table.insert(objectArray, null);
                }
                return table;
            }
        }
        return null;
    }

    Table getCrossReference(HsqlName hsqlName, Session session) throws SQLException {
        Table table = this.createTable(hsqlName);
        table.addColumn("PKTABLE_CAT", 12);
        table.addColumn("PKTABLE_SCHEM", 12);
        table.addColumn("PKTABLE_NAME", 12);
        table.addColumn("PKCOLUMN_NAME", 12);
        table.addColumn("FKTABLE_CAT", 12);
        table.addColumn("FKTABLE_SCHEM", 12);
        table.addColumn("FKTABLE_NAME", 12);
        table.addColumn("FKCOLUMN_NAME", 12);
        table.addColumn("KEY_SEQ", 5);
        table.addColumn("UPDATE_RULE", 5);
        table.addColumn("DELETE_RULE", 5);
        table.addColumn("FK_NAME", 12);
        table.addColumn("PK_NAME", 12);
        table.addColumn("DEFERRABILITY", 5);
        table.createPrimaryKey();
        int n = this.tTable.size();
        for (int i = 0; i < n; ++i) {
            Table table2 = (Table)this.tTable.elementAt(i);
            Vector vector = table2.getConstraints();
            for (int j = 0; j < vector.size(); ++j) {
                Constraint constraint = (Constraint)vector.elementAt(j);
                if (constraint.getType() != 0) continue;
                String string = constraint.getMain().tableName.name;
                String string2 = constraint.getRef().tableName.name;
                if (this.dDatabase.findUserTable(string) == null || this.dDatabase.findUserTable(string2) == null) continue;
                int[] nArray = constraint.getMainColumns();
                int[] nArray2 = constraint.getRefColumns();
                int n2 = nArray.length;
                for (int k = 0; k < n2; ++k) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[1] = "";
                    objectArray[0] = "";
                    objectArray[2] = string;
                    objectArray[3] = constraint.getMain().getColumn((int)nArray[k]).columnName.name;
                    objectArray[5] = "";
                    objectArray[4] = "";
                    objectArray[6] = string2;
                    objectArray[7] = constraint.getRef().getColumn((int)nArray2[k]).columnName.name;
                    objectArray[8] = new Short((short)(k + 1));
                    objectArray[9] = importedKeyNoActionShort;
                    objectArray[10] = constraint.isCascade() ? importedKeyCascadeShort : importedKeyNoActionShort;
                    objectArray[11] = constraint.getFkName();
                    objectArray[12] = constraint.getPkName();
                    objectArray[13] = importedKeyNotDeferrableShort;
                    table.insert(objectArray, null);
                }
            }
        }
        return table;
    }

    private Table createTable(HsqlName hsqlName) throws SQLException {
        return new Table(this.dDatabase, hsqlName, 0, null);
    }

    static {
        tableTypes = new String[]{"TABLE", "VIEW", "GLOBAL TEMPORARY"};
        sysTableNames = new Hashtable(37);
        String[] stringArray = new String[]{"SYSTEM_PROCEDURES", "SYSTEM_PROCEDURECOLUMNS", "SYSTEM_TABLES", "SYSTEM_SCHEMAS", "SYSTEM_CATALOGS", "SYSTEM_TABLETYPES", "SYSTEM_COLUMNS", "SYSTEM_COLUMNPRIVILEGES", "SYSTEM_TABLEPRIVILEGES", "SYSTEM_BESTROWIDENTIFIER", "SYSTEM_VERSIONCOLUMNS", "SYSTEM_PRIMARYKEYS", "SYSTEM_IMPORTEDKEYS", "SYSTEM_EXPORTEDKEYS", "SYSTEM_CROSSREFERENCE", "SYSTEM_TYPEINFO", "SYSTEM_INDEXINFO", "SYSTEM_UDTS", "SYSTEM_CONNECTIONINFO", "SYSTEM_USERS"};
        for (int i = 0; i < stringArray.length; ++i) {
            sysTableNames.put(stringArray[i], new Integer(i + 1));
        }
        importedKeyNoActionShort = new Short(3);
        importedKeyCascadeShort = new Short(0);
        importedKeyNotDeferrableShort = new Short(7);
    }
}

