/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Node;
import org.hsqldb.PointerNode;
import org.hsqldb.Record;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class CachedRow
extends Row {
    static final int NO_POS = -1;
    static int iCurrentAccess = 0;
    protected Table tTable;
    int iLastAccess;
    CachedRow rLast;
    CachedRow rNext;
    int iPos = -1;
    int storageSize;
    private boolean bChanged;

    CachedRow(Table table, Object[] objectArray) throws SQLException {
        this.tTable = table;
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, 0, table);
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, i, table);
        }
        this.oData = objectArray;
        this.bChanged = true;
        this.iLastAccess = iCurrentAccess++;
        table.putRow(this);
    }

    void setPos(int n) {
        this.iPos = n;
        Node node = this.nPrimaryNode;
        while (node != null) {
            node.setKey(n);
            node = node.nNext;
        }
    }

    void changed() {
        this.bChanged = true;
        this.iLastAccess = iCurrentAccess++;
    }

    boolean hasChanged() {
        return this.bChanged;
    }

    Node getNode(int n) {
        this.iLastAccess = iCurrentAccess++;
        return super.getNode(n);
    }

    Node getNextNode(Node node) {
        this.iLastAccess = iCurrentAccess++;
        return super.getNextNode(node);
    }

    Object[] getData() {
        this.iLastAccess = iCurrentAccess++;
        return this.oData;
    }

    Table getTable() {
        return this.tTable;
    }

    void insert(CachedRow cachedRow) {
        ++Record.memoryRecords;
        if (cachedRow == null) {
            this.rNext = this;
            this.rLast = this;
        } else {
            this.rNext = cachedRow;
            this.rLast = cachedRow.rLast;
            cachedRow.rLast = this;
            this.rLast.rNext = this;
        }
    }

    boolean isRoot() throws SQLException {
        Node node = this.nPrimaryNode;
        while (node != null) {
            if (node.isRoot()) {
                return true;
            }
            node = node.nNext;
        }
        return false;
    }

    void write(DatabaseRowOutputInterface databaseRowOutputInterface) throws IOException, SQLException {
        databaseRowOutputInterface.writeSize(this.storageSize);
        if (this.tTable.isIndexCached()) {
            Node node = this.nPrimaryNode;
            while (node != null) {
                node.write(databaseRowOutputInterface);
                node = node.nNext;
            }
        }
        databaseRowOutputInterface.writeData(this.oData, this.tTable);
        databaseRowOutputInterface.writePos(this.iPos);
        this.bChanged = false;
    }

    void delete() throws SQLException {
        ++Record.memoryRecords;
        this.bChanged = false;
        this.tTable.removeRow(this);
        this.rNext = null;
        this.rLast = null;
        this.tTable = null;
        this.oData = null;
        this.nPrimaryNode = null;
    }

    void free() throws SQLException {
        this.rLast.rNext = this.rNext;
        this.rNext.rLast = this.rLast;
        if (this.rNext == this) {
            this.rLast = null;
            this.rNext = null;
        }
    }

    CachedRow(Table table, DatabaseRowInputInterface databaseRowInputInterface) throws IOException, SQLException {
        this.tTable = table;
        this.iPos = databaseRowInputInterface.getPos();
        this.storageSize = databaseRowInputInterface.getSize();
        int n = table.getIndexCount();
        Node node = this.nPrimaryNode = Node.newNode(this, databaseRowInputInterface, 0, table);
        if (table.getIndexType() == 2) {
            ((PointerNode)this.nPrimaryNode).setNextKey(databaseRowInputInterface.getNextPos());
        }
        for (int i = 1; i < n; ++i) {
            node = node.nNext = Node.newNode(this, databaseRowInputInterface, i, table);
        }
        this.oData = databaseRowInputInterface.readData(this.tTable.getColumnTypes());
        if (this.tTable.isIndexCached()) {
            Trace.check(databaseRowInputInterface.readIntData() == this.iPos, 34);
        }
        this.iLastAccess = iCurrentAccess++;
    }
}

