/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.BinaryDatabaseRowInput;
import org.hsqldb.BinaryDatabaseRowOutput;
import org.hsqldb.BinaryServerRowInput;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.CacheFree;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseFile;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.Table;
import org.hsqldb.Trace;

class Cache {
    private HsqlDatabaseProperties props;
    private boolean newCacheType;
    private final int cacheLength;
    private final int writerLength;
    private final int maxCacheSize;
    private final int multiplierMask;
    private CachedRow[] rData;
    private CachedRow[] rWriter;
    private CachedRow rFirst;
    private CachedRow rLastChecked;
    protected String sName;
    protected int iFreePos;
    protected DatabaseFile rFile;
    private static final int FREE_POS_POS = 16;
    private static final int INITIAL_FREE_POS = 32;
    private static final int MAX_FREE_COUNT = 1024;
    private CacheFree fRoot;
    private int iFreeCount;
    private int iCacheSize;

    Cache(String string, HsqlDatabaseProperties hsqlDatabaseProperties) {
        this.props = hsqlDatabaseProperties;
        int n = 0;
        try {
            n = hsqlDatabaseProperties.getIntegerProperty("hsqldb.cache_scale", 0);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.printSystemOut("bad value for hsqldb.cache_scale in properties file");
        }
        if (n == 0) {
            n = 15;
        } else if (n < 8) {
            n = 8;
        } else if (n > 16) {
            n = 16;
        }
        this.cacheLength = 1 << n;
        this.writerLength = this.cacheLength - 3;
        this.maxCacheSize = this.cacheLength * 3;
        this.multiplierMask = this.cacheLength - 1;
        this.sName = string;
        this.rData = new CachedRow[this.cacheLength];
        this.rWriter = new CachedRow[this.writerLength];
    }

    void open(boolean bl) throws SQLException {
        try {
            boolean bl2 = false;
            File file = new File(this.sName);
            if (file.exists() && file.length() > 16L) {
                bl2 = true;
            }
            this.rFile = new DatabaseFile(this.sName, bl ? "r" : "rw", 2048);
            if (bl2) {
                this.rFile.readSeek(16L);
                this.iFreePos = this.rFile.readInteger();
            } else {
                this.iFreePos = 32;
                this.props.setProperty("hsqldb.cache_version", "1.7.0");
            }
            String string = this.props.getProperty("hsqldb.cache_version", "1.6.0");
            if (string.equals("1.7.0")) {
                this.newCacheType = true;
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " opening " + this.sName);
        }
    }

    void flush() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.seek(16L);
            this.rFile.writeInteger(this.iFreePos);
            this.saveAll();
            boolean bl = this.rFile.length() < 32L;
            this.rFile.close();
            this.rFile = null;
            if (bl) {
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " closing " + this.sName);
        }
    }

    void closeFile() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.close();
            this.rFile = null;
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " in shutdown " + this.sName);
        }
    }

    void free(CachedRow cachedRow) throws SQLException {
        ++this.iFreeCount;
        CacheFree cacheFree = new CacheFree();
        cacheFree.iPos = cachedRow.iPos;
        cacheFree.iLength = cachedRow.storageSize;
        if (this.iFreeCount > 1024) {
            this.iFreeCount = 0;
        } else {
            cacheFree.fNext = this.fRoot;
        }
        this.fRoot = cacheFree;
        this.remove(cachedRow);
    }

    protected void setStorageSize(CachedRow cachedRow) throws SQLException {
        Table table = cachedRow.getTable();
        int n = 8 + 32 * table.getIndexCount();
        n = this.newCacheType ? (n += BinaryServerRowOutput.getSize(cachedRow)) : (n += BinaryDatabaseRowOutput.getSize(cachedRow));
        cachedRow.storageSize = n = (n + 7) / 8 * 8;
    }

    void add(CachedRow cachedRow) throws SQLException {
        int n;
        CachedRow cachedRow2;
        int n2;
        this.setStorageSize(cachedRow);
        int n3 = n2 = cachedRow.storageSize;
        CacheFree cacheFree = this.fRoot;
        CacheFree cacheFree2 = null;
        int n4 = this.iFreePos;
        while (cacheFree != null) {
            if (Trace.TRACE) {
                Trace.stop();
            }
            if (cacheFree.iLength >= n3) {
                n4 = cacheFree.iPos;
                if ((n3 = cacheFree.iLength - n3) < 8) {
                    if (cacheFree2 == null) {
                        this.fRoot = cacheFree.fNext;
                    } else {
                        cacheFree2.fNext = cacheFree.fNext;
                    }
                    --this.iFreeCount;
                    break;
                }
                cacheFree.iLength = n3;
                cacheFree.iPos += n2;
                break;
            }
            cacheFree2 = cacheFree;
            cacheFree = cacheFree.fNext;
        }
        cachedRow.setPos(n4);
        if (n4 == this.iFreePos) {
            this.iFreePos += n3;
        }
        if ((cachedRow2 = this.rData[n = n4 >> 3 & this.multiplierMask]) == null) {
            cachedRow2 = this.rFirst;
        }
        cachedRow.insert(cachedRow2);
        ++this.iCacheSize;
        this.rData[n] = cachedRow;
        this.rFirst = cachedRow;
    }

    protected CachedRow makeRow(int n, Table table) throws SQLException {
        CachedRow cachedRow = null;
        try {
            this.rFile.readSeek(n);
            int n2 = this.rFile.readInteger();
            byte[] byArray = new byte[n2];
            this.rFile.read(byArray);
            DatabaseRowInput databaseRowInput = this.newCacheType ? new BinaryServerRowInput(byArray, n) : new BinaryDatabaseRowInput(byArray, n);
            cachedRow = new CachedRow(table, (DatabaseRowInputInterface)((Object)databaseRowInput));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw Trace.error(29, "reading: " + iOException);
        }
        return cachedRow;
    }

    CachedRow getRow(int n, Table table) throws SQLException {
        CachedRow cachedRow;
        CachedRow cachedRow2;
        int n2 = n >> 3 & this.multiplierMask;
        CachedRow cachedRow3 = cachedRow2 = this.rData[n2];
        int n3 = 0;
        while (cachedRow2 != null) {
            n3 = cachedRow2.iPos;
            if (n3 == n) {
                return cachedRow2;
            }
            if ((n3 >> 3 & this.multiplierMask) == n2 && (cachedRow2 = cachedRow2.rNext) != cachedRow3) continue;
        }
        if ((cachedRow = this.rData[n2]) == null) {
            cachedRow = this.rFirst;
        }
        if ((cachedRow2 = this.makeRow(n, table)) != null) {
            cachedRow2.insert(cachedRow);
            ++this.iCacheSize;
            this.rData[cachedRow2.iPos >> 3 & this.multiplierMask] = cachedRow2;
            this.rFirst = cachedRow2;
            table.indexRow(cachedRow2, false);
        }
        return cachedRow2;
    }

    void cleanUp() throws SQLException {
        if (this.iCacheSize < this.maxCacheSize) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2++ < this.cacheLength && this.iCacheSize > this.maxCacheSize / 2 && n < this.writerLength) {
            CachedRow cachedRow = this.getWorst();
            if (cachedRow == null) {
                return;
            }
            if (cachedRow.hasChanged()) {
                cachedRow.iLastAccess = CachedRow.iCurrentAccess;
                this.rWriter[n++] = cachedRow;
                continue;
            }
            if (cachedRow.isRoot()) continue;
            this.remove(cachedRow);
        }
        if (n != 0) {
            this.saveSorted(n);
        }
        for (int i = 0; i < n; ++i) {
            CachedRow cachedRow = this.rWriter[i];
            if (!cachedRow.isRoot()) {
                this.remove(cachedRow);
            }
            this.rWriter[i] = null;
        }
    }

    protected void remove(CachedRow cachedRow) throws SQLException {
        int n;
        if (cachedRow == this.rLastChecked) {
            this.rLastChecked = this.rLastChecked.rNext;
            if (this.rLastChecked == cachedRow) {
                this.rLastChecked = null;
            }
        }
        if (this.rData[n = cachedRow.iPos >> 3 & this.multiplierMask] == cachedRow) {
            CachedRow cachedRow2;
            this.rFirst = cachedRow2 = cachedRow.rNext;
            if (cachedRow2 == cachedRow || (cachedRow2.iPos >> 3 & this.multiplierMask) != n) {
                cachedRow2 = null;
            }
            this.rData[n] = cachedRow2;
        }
        if (cachedRow == this.rFirst) {
            this.rFirst = this.rFirst.rNext;
            if (cachedRow == this.rFirst) {
                this.rFirst = null;
            }
        }
        cachedRow.free();
        --this.iCacheSize;
    }

    private CachedRow getWorst() throws SQLException {
        CachedRow cachedRow;
        if (this.rLastChecked == null) {
            this.rLastChecked = this.rFirst;
        }
        if ((cachedRow = this.rLastChecked) == null) {
            return null;
        }
        CachedRow cachedRow2 = cachedRow;
        int n = CachedRow.iCurrentAccess;
        for (int i = 0; i < 6; ++i) {
            int n2 = cachedRow.iLastAccess;
            if (n2 < n) {
                cachedRow2 = cachedRow;
                n = n2;
            }
            cachedRow = cachedRow.rNext;
        }
        this.rLastChecked = cachedRow.rNext;
        return cachedRow2;
    }

    protected void saveAll() throws SQLException {
        if (this.rFirst == null) {
            return;
        }
        CachedRow cachedRow = this.rFirst;
        block0: while (true) {
            int n = 0;
            CachedRow cachedRow2 = cachedRow;
            do {
                if (!cachedRow.hasChanged()) continue;
                this.rWriter[n++] = cachedRow;
            } while ((cachedRow = cachedRow.rNext) != cachedRow2 && n < this.writerLength);
            if (n == 0) {
                return;
            }
            this.saveSorted(n);
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                this.rWriter[n2] = null;
                ++n2;
            }
            break;
        }
    }

    protected void saveRow(CachedRow cachedRow) throws IOException, SQLException {
        this.rFile.seek(cachedRow.iPos);
        DatabaseRowOutput databaseRowOutput = this.newCacheType ? new BinaryServerRowOutput(cachedRow.storageSize) : new BinaryDatabaseRowOutput(cachedRow.storageSize);
        cachedRow.write(databaseRowOutput);
        this.rFile.write(databaseRowOutput.toByteArray());
    }

    private void saveSorted(int n) throws SQLException {
        Cache.sort(this.rWriter, 0, n - 1);
        try {
            for (int i = 0; i < n; ++i) {
                this.saveRow(this.rWriter[i]);
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "saveSorted " + exception);
        }
    }

    private static final void sort(CachedRow[] cachedRowArray, int n, int n2) throws SQLException {
        int n3;
        int n4;
        while (n2 - n > 10) {
            n4 = n2 + n >> 1;
            if (cachedRowArray[n].iPos > cachedRowArray[n2].iPos) {
                Cache.swap(cachedRowArray, n, n2);
            }
            if (cachedRowArray[n4].iPos < cachedRowArray[n].iPos) {
                Cache.swap(cachedRowArray, n, n4);
            } else if (cachedRowArray[n4].iPos > cachedRowArray[n2].iPos) {
                Cache.swap(cachedRowArray, n4, n2);
            }
            n3 = n2 - 1;
            Cache.swap(cachedRowArray, n4, n3);
            int n5 = cachedRowArray[n3].iPos;
            n4 = n;
            while (true) {
                if (cachedRowArray[++n4].iPos < n5) {
                    continue;
                }
                while (cachedRowArray[--n3].iPos > n5) {
                }
                if (n4 >= n3) break;
                Cache.swap(cachedRowArray, n4, n3);
            }
            Cache.swap(cachedRowArray, n4, n2 - 1);
            Cache.sort(cachedRowArray, n, n4 - 1);
            n = n4 + 1;
        }
        for (n4 = n + 1; n4 <= n2; ++n4) {
            CachedRow cachedRow = cachedRowArray[n4];
            for (n3 = n4 - 1; n3 >= n && cachedRowArray[n3].iPos > cachedRow.iPos; --n3) {
                cachedRowArray[n3 + 1] = cachedRowArray[n3];
            }
            cachedRowArray[n3 + 1] = cachedRow;
        }
    }

    private static void swap(CachedRow[] cachedRowArray, int n, int n2) {
        CachedRow cachedRow = cachedRowArray[n];
        cachedRowArray[n] = cachedRowArray[n2];
        cachedRowArray[n2] = cachedRow;
    }

    int getFreePos() {
        return this.iFreePos;
    }
}

