/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.Trace;

class BinaryServerRowOutput
extends DatabaseRowOutput {
    int storageSize;
    private ByteArrayOutputStream byteOut;

    public BinaryServerRowOutput() throws IOException {
        super(new ByteArrayOutputStream());
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public BinaryServerRowOutput(int n) throws IOException {
        super(new ByteArrayOutputStream(n));
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public void writeIntData(int n) throws IOException {
        this.writeInt(n);
    }

    public void writePos(int n) throws IOException {
        this.writeInt(n);
        while (this.byteOut.size() < this.storageSize) {
            this.write(0);
        }
    }

    public void writeSize(int n) throws IOException {
        this.storageSize = n;
        this.writeInt(n);
    }

    public void writeType(int n) throws IOException {
        this.writeShort(n);
    }

    public void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes("utf-8");
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public byte[] toByteArray() throws IOException {
        byte[] byArray = this.byteOut.toByteArray();
        this.byteOut.reset();
        return byArray;
    }

    protected void writeFieldType(int n) throws IOException {
        this.writeByte(1);
    }

    protected void writeNull(int n) throws IOException {
        this.writeByte(0);
    }

    protected void writeChar(String string, int n) throws IOException {
        this.writeString(string);
    }

    protected void writeSmallint(Number number) throws IOException, SQLException {
        this.writeShort(number.intValue());
    }

    protected void writeInteger(Number number) throws IOException, SQLException {
        this.writeInt(number.intValue());
    }

    protected void writeBigint(Number number) throws IOException, SQLException {
        this.writeLong(number.longValue());
    }

    protected void writeReal(Double d, int n) throws IOException, SQLException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    protected void writeDecimal(BigDecimal bigDecimal) throws IOException, SQLException {
        int n = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n);
    }

    protected void writeBit(Boolean bl) throws IOException, SQLException {
        this.writeBoolean(bl);
    }

    protected void writeDate(Date date) throws IOException, SQLException {
        this.writeLong(date.getTime());
    }

    protected void writeTime(Time time) throws IOException, SQLException {
        this.writeLong(time.getTime());
    }

    protected void writeTimestamp(Timestamp timestamp) throws IOException, SQLException {
        this.writeLong(timestamp.getTime());
        this.writeInt(timestamp.getNanos());
    }

    protected void writeOther(Object object) throws IOException, SQLException {
        byte[] byArray = ByteArray.serialize(object);
        this.writeByteArray(byArray);
    }

    protected void writeBinary(byte[] byArray, int n) throws IOException, SQLException {
        this.writeByteArray(byArray);
    }

    protected void writeByteArray(byte[] byArray) throws IOException {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public static int getSize(CachedRow cachedRow) throws SQLException {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        return BinaryServerRowOutput.getSize(objectArray, objectArray.length, nArray);
    }

    private static int getSize(Object[] objectArray, int n, int[] nArray) throws SQLException {
        int n2 = 0;
        block12: for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            ++n2;
            if (object == null) continue;
            switch (nArray[i]) {
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    n2 += BinaryServerRowOutput.getUTFSize((String)object);
                    continue block12;
                }
                case -6: 
                case 5: {
                    n2 += 2;
                    continue block12;
                }
                case 4: {
                    n2 += 4;
                    continue block12;
                }
                case -5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 += 8;
                    continue block12;
                }
                case 2: 
                case 3: {
                    n2 += 8;
                    n2 += ((BigDecimal)object).unscaledValue().toByteArray().length;
                    continue block12;
                }
                case -7: {
                    ++n2;
                    continue block12;
                }
                case 91: 
                case 92: {
                    n2 += 8;
                    continue block12;
                }
                case 93: {
                    n2 += 12;
                    continue block12;
                }
                case -4: 
                case -3: 
                case -2: {
                    n2 += 4;
                    n2 += ((byte[])object).length;
                    continue block12;
                }
                case 1111: {
                    n2 += 4;
                    n2 += ByteArray.serialize(object).length;
                    continue block12;
                }
                default: {
                    throw Trace.error(20, nArray[i]);
                }
            }
        }
        return n2;
    }

    private static int getUTFSize(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = 4;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }
}

