/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseRowOutput;

class BinaryDatabaseRowOutput
extends DatabaseRowOutput {
    int storageSize;
    private ByteArrayOutputStream byteOut;

    public BinaryDatabaseRowOutput() throws IOException {
        super(new ByteArrayOutputStream());
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public BinaryDatabaseRowOutput(int n) throws IOException {
        super(new ByteArrayOutputStream(n));
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public void writeIntData(int n) throws IOException {
        this.writeInt(n);
    }

    public void writePos(int n) throws IOException {
        this.writeInt(n);
        while (this.byteOut.size() < this.storageSize) {
            this.write(0);
        }
    }

    public void writeSize(int n) throws IOException {
        this.storageSize = n;
        this.writeInt(n);
    }

    public void writeType(int n) throws IOException {
        this.writeInt(n);
    }

    public void writeString(String string) throws IOException {
        this.writeUTF(string);
    }

    public byte[] toByteArray() throws IOException {
        byte[] byArray = this.byteOut.toByteArray();
        this.byteOut.reset();
        return byArray;
    }

    protected void writeFieldType(int n) throws IOException {
        this.writeInt(n);
    }

    protected void writeNull(int n) throws IOException {
        this.writeType(0);
    }

    protected void writeChar(String string, int n) throws IOException {
        this.writeUTF(string);
    }

    protected void writeSmallint(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    protected void writeInteger(Number number) throws IOException, SQLException {
        this.writeInt(number.intValue());
    }

    protected void writeBigint(Number number) throws IOException, SQLException {
        this.writeString(number.toString());
    }

    protected void writeReal(Double d, int n) throws IOException, SQLException {
        if (n == 7) {
            this.writeString(d.toString());
        } else {
            this.writeLong(Double.doubleToLongBits(d));
        }
    }

    protected void writeDecimal(BigDecimal bigDecimal) throws IOException, SQLException {
        this.writeString(bigDecimal.toString());
    }

    protected void writeBit(Boolean bl) throws IOException, SQLException {
        this.writeString(bl.toString());
    }

    protected void writeDate(Date date) throws IOException, SQLException {
        this.writeString(date.toString());
    }

    protected void writeTime(Time time) throws IOException, SQLException {
        this.writeString(time.toString());
    }

    protected void writeTimestamp(Timestamp timestamp) throws IOException, SQLException {
        this.writeString(timestamp.toString());
    }

    protected void writeOther(Object object) throws IOException, SQLException {
        byte[] byArray = ByteArray.serialize(object);
        this.writeByteArray(byArray);
    }

    protected void writeBinary(byte[] byArray, int n) throws IOException, SQLException {
        this.writeByteArray(byArray);
    }

    protected void writeByteArray(byte[] byArray) throws IOException {
        this.writeString("**");
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public static int getSize(CachedRow cachedRow) throws SQLException {
        Object[] objectArray = cachedRow.getData();
        int[] nArray = cachedRow.getTable().getColumnTypes();
        return BinaryDatabaseRowOutput.getSize(objectArray, objectArray.length, nArray);
    }

    private static int getSize(Object[] objectArray, int n, int[] nArray) throws SQLException {
        int n2 = 0;
        block6: for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            n2 += 4;
            if (object == null) continue;
            switch (nArray[i]) {
                case 4: {
                    n2 += 4;
                    continue block6;
                }
                case 6: 
                case 8: {
                    n2 += 8;
                    continue block6;
                }
                case -4: 
                case -3: 
                case -2: {
                    n2 += BinaryDatabaseRowOutput.getUTFsize("**");
                    n2 += 4;
                    n2 += ((byte[])object).length;
                    continue block6;
                }
                case 1111: {
                    n2 += BinaryDatabaseRowOutput.getUTFsize("**");
                    n2 += 4;
                    n2 += ByteArray.serialize(object).length;
                }
                default: {
                    n2 += BinaryDatabaseRowOutput.getUTFsize(object.toString());
                }
            }
        }
        return n2;
    }

    private static int getUTFsize(String string) {
        int n = string == null ? 0 : string.length();
        int n2 = 2;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n2;
                continue;
            }
            if (c > '\u07ff') {
                n2 += 3;
                continue;
            }
            n2 += 2;
        }
        return n2;
    }
}

