/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.tasklist.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.extra.tasklist.model.Task;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.SubRenderer;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.SequencedHashMap;

public class TaskList {
    private final String name;
    private final ContentEntityObject content;
    private final ContentPropertyManager contentPropertyManager;
    Map tasks;
    private SubRenderer subRenderer;
    private PageContext context;

    public TaskList(String string, ContentEntityObject contentEntityObject, String string2, ContentPropertyManager contentPropertyManager, SubRenderer subRenderer, PageContext pageContext) {
        this.name = string;
        this.content = contentEntityObject;
        this.contentPropertyManager = contentPropertyManager;
        this.subRenderer = subRenderer;
        this.context = pageContext;
        this.createTasks(string2);
    }

    private void createTasks(String string) {
        this.tasks = new SequencedHashMap();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2;
            String string3;
            String string4 = TextUtils.noNull((String)stringTokenizer.nextToken()).trim();
            String string5 = this.subRenderer.render(string4, (RenderContext)this.context, RenderMode.INLINE);
            Task task = new Task(string4, string5);
            if (this.content != null && TextUtils.stringSet((String)(string3 = this.contentPropertyManager.getStringProperty(this.content, string2 = this.computeTaskItemId(task.getName()))))) {
                task.setCompleter(string3);
            }
            this.tasks.put(task.getName(), task);
        }
    }

    public String computeTaskItemId(String string) {
        return "tasklist." + TextUtils.noNull((String)this.name).hashCode() + "." + TextUtils.noNull((String)string).hashCode();
    }

    public String getName() {
        return this.name;
    }

    public List getTasks() {
        return new ArrayList(this.tasks.values());
    }

    public void completeTask(String string, String string2) {
        Task task = (Task)this.tasks.get(string);
        if (task != null) {
            if (!TextUtils.stringSet((String)string2)) {
                string2 = "Unknown";
            }
            String string3 = this.computeTaskItemId(string);
            this.contentPropertyManager.setStringProperty(this.content, string3, string2);
            task.setCompleter(string2);
        }
    }

    public void uncompleteTask(String string) {
        Task task = (Task)this.tasks.get(string);
        if (task != null) {
            this.clearTask(task);
        }
    }

    public void uncompleteAllTasks() {
        List list = this.getTasks();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (task == null) continue;
            this.clearTask(task);
        }
    }

    public int getPercentComplete() {
        int n = 0;
        Iterator iterator = this.getTasks().iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (!task.isCompleted()) continue;
            ++n;
        }
        return (int)(100.0f * ((float)n / (float)this.tasks.size()));
    }

    private void clearTask(Task task) {
        String string = this.computeTaskItemId(task.getName());
        this.contentPropertyManager.setStringProperty(this.content, string, null);
        task.setCompleter(null);
    }
}

