/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.valuetypes;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.ParseException;

public class RequestStatus {
    private String statusCode;
    private String description;
    private String exceptionData;
    public static final int PRELIMINARY_SUCCESS = 1;
    public static final int SUCCESSFUL = 2;
    public static final int CLIENT_ERROR = 3;
    public static final int SCHEDULING_ERROR = 4;
    private int statusClass = -1;

    public RequestStatus(ICalProperty property) throws ParseException {
        this(property.getStringValue());
    }

    public RequestStatus(String line) throws ParseException {
        int sepIdx = line.indexOf(59);
        if (sepIdx > 0) {
            this.statusCode = line.substring(0, sepIdx);
            if (this.statusCode.charAt(0) == '1') {
                this.statusClass = 1;
            } else if (this.statusCode.charAt(0) == '2') {
                this.statusClass = 2;
            } else if (this.statusCode.charAt(0) == '3') {
                this.statusClass = 3;
            } else if (this.statusCode.charAt(0) == '4') {
                this.statusClass = 4;
            }
            String restOfString = line.substring(sepIdx + 1);
            int secondSepIdx = restOfString.indexOf(59);
            if (secondSepIdx > 0) {
                this.description = restOfString.substring(0, secondSepIdx);
                this.exceptionData = restOfString.substring(secondSepIdx + 1);
            } else {
                this.description = restOfString;
            }
        } else {
            throw new ParseException("Invalid request status: " + line);
        }
    }

    public String getStatusCode() {
        return this.statusCode;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExceptionData() {
        return this.exceptionData;
    }

    public int getStatusClass() {
        return this.statusClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestStatus)) {
            return false;
        }
        RequestStatus requestStatus = (RequestStatus)o;
        if (this.statusClass != requestStatus.statusClass) {
            return false;
        }
        if (this.description != null ? !this.description.equals(requestStatus.description) : requestStatus.description != null) {
            return false;
        }
        if (this.exceptionData != null ? !this.exceptionData.equals(requestStatus.exceptionData) : requestStatus.exceptionData != null) {
            return false;
        }
        return !(this.statusCode != null ? !this.statusCode.equals(requestStatus.statusCode) : requestStatus.statusCode != null);
    }

    public int hashCode() {
        int result = this.statusCode != null ? this.statusCode.hashCode() : 0;
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 29 * result + (this.exceptionData != null ? this.exceptionData.hashCode() : 0);
        result = 29 * result + this.statusClass;
        return result;
    }

    public String toString() {
        return "Request Status (code: " + this.statusCode + " description: " + this.description + " exception data: " + this.exceptionData + ")";
    }
}

