/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.valuetypes;

import com.atlassian.gregory.ParseException;

public class GeographicPosition {
    float latitude;
    float longitude;

    public GeographicPosition(float latitude, float longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public GeographicPosition(String value) throws ParseException {
        int sepIdx = value.indexOf(59);
        if (sepIdx <= 0) {
            throw new ParseException("Invalid position string : " + value);
        }
        this.latitude = Float.parseFloat(value.substring(0, sepIdx));
        this.longitude = Float.parseFloat(value.substring(sepIdx + 1));
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeographicPosition)) {
            return false;
        }
        GeographicPosition geographicPosition = (GeographicPosition)o;
        if (this.latitude != geographicPosition.latitude) {
            return false;
        }
        return this.longitude == geographicPosition.longitude;
    }

    public int hashCode() {
        int result = this.latitude != 0.0f ? Float.floatToIntBits(this.latitude) : 0;
        result = (float)(29 * result) + this.longitude != 0.0f ? Float.floatToIntBits(this.longitude) : 0;
        return result;
    }
}

