/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.valuetypes;

import com.atlassian.gregory.ICalProperty;

public class Duration {
    private String rawValue;
    private boolean positive = true;
    int weeks = 0;
    int days = 0;
    int hours = 0;
    int minutes = 0;
    int seconds = 0;

    public Duration(String rawValue) {
        this.rawValue = rawValue;
        this.parseDuration();
    }

    public Duration(ICalProperty property) {
        this(property.getStringValue());
    }

    private void parseDuration() {
        if (this.rawValue.length() > 0 && this.rawValue.charAt(0) == '-') {
            this.positive = false;
        }
        int curNum = 0;
        for (int i = 0; i < this.rawValue.toCharArray().length; ++i) {
            char c = this.rawValue.toCharArray()[i];
            if (c == 'P' || c == '+' || c == '-') continue;
            if (Character.isDigit(c)) {
                curNum = 10 * curNum + Integer.parseInt(c + "");
                continue;
            }
            if (c == 'D' || c == 'd') {
                this.days = curNum;
                curNum = 0;
                continue;
            }
            if (c == 'W' || c == 'w') {
                this.weeks = curNum;
                curNum = 0;
                continue;
            }
            if (c == 'H' || c == 'h') {
                this.hours = curNum;
                curNum = 0;
                continue;
            }
            if (c == 'M' || c == 'm') {
                this.minutes = curNum;
                curNum = 0;
                continue;
            }
            if (c != 'S' && c != 's') continue;
            this.seconds = curNum;
            curNum = 0;
        }
    }

    public long getTime() {
        return (((((long)this.weeks * 7L + (long)this.days) * 24L + (long)this.hours) * 60L + (long)this.minutes) * 60L + (long)this.seconds) * 1000L * (this.isPositive() ? 1L : -1L);
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public boolean isPositive() {
        return this.positive;
    }

    public int getWeeks() {
        return this.weeks;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.rawValue.equals(duration.rawValue);
    }

    public int hashCode() {
        return this.rawValue.hashCode();
    }

    public String toString() {
        return "Duration: " + this.rawValue;
    }
}

