/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.valuetypes;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.ParseException;
import java.net.URI;
import java.net.URISyntaxException;

public class CalUserAddress {
    private URI uri;

    public static CalUserAddress makeCalUserAddress(ICalProperty property) {
        if (property == null) {
            return null;
        }
        try {
            return new CalUserAddress(property.getStringValue());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public CalUserAddress(ICalProperty property) throws ParseException {
        this(property.getStringValue());
    }

    public CalUserAddress(String rawUri) throws ParseException {
        try {
            this.uri = new URI(rawUri);
        }
        catch (URISyntaxException e) {
            throw new ParseException("Cannot parse raw URI: " + rawUri);
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public String getEmail() {
        if (this.isEmail()) {
            return this.uri.getSchemeSpecificPart();
        }
        return null;
    }

    public boolean isEmail() {
        return "MAILTO".equals(this.uri.getScheme());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CalUserAddress)) {
            return false;
        }
        CalUserAddress calUserAddress = (CalUserAddress)o;
        return !(this.uri != null ? !this.uri.equals(calUserAddress.uri) : calUserAddress.uri != null);
    }

    public int hashCode() {
        return this.uri != null ? this.uri.hashCode() : 0;
    }

    public String toString() {
        return "CalUserAddress: uri=" + this.uri.toString();
    }
}

