/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.util;

import com.atlassian.gregory.ICalProperty;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateTimeParser {
    private static final DateFormat TZ_DATETIME_FORMAT = new SimpleDateFormat("yyyyMMdd'T'hhmmss");
    private static final DateFormat UTC_DATETIME_FORMAT = new SimpleDateFormat("yyyyMMdd'T'hhmmss'Z'");
    private static final DateFormat BASIC_DATETIME_FORMAT = new SimpleDateFormat("yyyyMMdd'T'hhmmss");
    private static final DateFormat BASIC_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    public static Date parseDate(ICalProperty property) {
        if (property == null) {
            return null;
        }
        if (property.getPropertyParameters().containsKey("TZID")) {
            return DateTimeParser.parseTimeZoneDate(property);
        }
        if ("DATE".equals(property.getPropertyParameters().get("VALUE"))) {
            return DateTimeParser.parseDateTime(property, BASIC_DATE_FORMAT);
        }
        if (property.getStringValue().endsWith("Z")) {
            return DateTimeParser.parseDateByTimeZoneFormat(property, UTC_TIMEZONE, UTC_DATETIME_FORMAT);
        }
        return DateTimeParser.parseDateTime(property, BASIC_DATETIME_FORMAT);
    }

    private static Date parseDateTime(ICalProperty line, DateFormat dateTimeFormat) {
        try {
            return dateTimeFormat.parse(line.getStringValue());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Date parseTimeZoneDate(ICalProperty line) {
        TimeZone timeZone = TimeZone.getTimeZone((String)line.getPropertyParameters().get("TZID"));
        return DateTimeParser.parseDateByTimeZoneFormat(line, timeZone, TZ_DATETIME_FORMAT);
    }

    private static Date parseDateByTimeZoneFormat(ICalProperty line, TimeZone timeZone, DateFormat dateFormat) {
        DateFormat fmt = (DateFormat)dateFormat.clone();
        try {
            fmt.setTimeZone(timeZone);
            Date date = fmt.parse(line.getStringValue());
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }
}

