/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.components;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.components.AbstractICalComponent;
import com.atlassian.gregory.util.DateTimeParser;
import com.atlassian.gregory.valuetypes.CalUserAddress;
import com.atlassian.gregory.valuetypes.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ICalAlarm
extends AbstractICalComponent {
    public String getSummary() {
        ICalProperty property = this.getProperty("SUMMARY");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public String getDescription() {
        ICalProperty property = this.getProperty("DESCRIPTION");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public Duration getDuration() {
        ICalProperty property = this.getProperty("DURATION");
        if (property == null) {
            return null;
        }
        return new Duration(property.getStringValue());
    }

    public List getAttendees() {
        List properties = this.getProperties("ATTENDEE");
        if (properties == null) {
            return null;
        }
        ArrayList<CalUserAddress> result = new ArrayList<CalUserAddress>(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            CalUserAddress calUserAddress = CalUserAddress.makeCalUserAddress((ICalProperty)iterator.next());
            if (calUserAddress == null) continue;
            result.add(calUserAddress);
        }
        return result;
    }

    public Object getTrigger() {
        ICalProperty property = this.getProperty("TRIGGER");
        if (property == null) {
            return null;
        }
        if ("DATE-TIME".equals(property.getPropertyParameters().get("VALUE"))) {
            return DateTimeParser.parseDate(property);
        }
        return new Duration(property);
    }

    public int getRepeat() {
        ICalProperty property = this.getProperty("REPEAT");
        if (property == null) {
            return -1;
        }
        return property.getIntValue();
    }

    public String getAction() {
        ICalProperty property = this.getProperty("ACTION");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }
}

