/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.components;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.components.ICalComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class AbstractICalComponent
implements ICalComponent {
    private Map propertyLists;
    private List children;

    public void addProperty(ICalProperty property) {
        ArrayList<ICalProperty> existingProperties;
        if (this.propertyLists == null) {
            this.propertyLists = new HashMap();
        }
        if ((existingProperties = (ArrayList<ICalProperty>)this.propertyLists.get(property.getName())) == null) {
            existingProperties = new ArrayList<ICalProperty>(1);
        }
        existingProperties.add(property);
        this.propertyLists.put(property.getName().toUpperCase(), existingProperties);
    }

    public void addComponent(ICalComponent component) {
        if (this.allowsChildComponent(component)) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
        } else {
            throw new IllegalArgumentException(this.getClass().getName() + " does not accept child components of type: " + component.getClass().getName());
        }
        this.children.add(component);
    }

    protected List getComponents() {
        return this.children;
    }

    public boolean allowsChildComponent(ICalComponent component) {
        return false;
    }

    public List getProperties(String name) {
        if (name == null) {
            return null;
        }
        return (List)this.propertyLists.get(name.toUpperCase());
    }

    public ICalProperty getProperty(String name) {
        List properties = this.getProperties(name);
        if (properties == null || properties.size() == 0) {
            return null;
        }
        if (properties.size() == 1) {
            return (ICalProperty)properties.get(0);
        }
        throw new IllegalArgumentException("Multiple properties with that name exist.");
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.propertyLists.size() * 20);
        Iterator iterator = this.propertyLists.values().iterator();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator1 = list.iterator();
            while (iterator1.hasNext()) {
                ICalProperty line = (ICalProperty)iterator1.next();
                buf.append(line.toString() + "\n");
            }
        }
        return buf.toString();
    }
}

