/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.components;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.ParseException;
import com.atlassian.gregory.components.AbstractICalComponent;
import com.atlassian.gregory.util.DateTimeParser;
import com.atlassian.gregory.valuetypes.CalUserAddress;
import com.atlassian.gregory.valuetypes.RequestStatus;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEventToDoJournalFreeBusy
extends AbstractICalComponent {
    public String getUid() {
        ICalProperty property = this.getProperty("UID");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public Date getDateStart() {
        return DateTimeParser.parseDate(this.getProperty("DTSTART"));
    }

    public Date getDateTimeStamp() {
        return DateTimeParser.parseDate(this.getProperty("DTSTAMP"));
    }

    public CalUserAddress getOrganizer() {
        ICalProperty property = this.getProperty("ORGANIZER");
        return CalUserAddress.makeCalUserAddress(property);
    }

    public URI getUrl() {
        try {
            ICalProperty property = this.getProperty("URL");
            if (property == null) {
                return null;
            }
            return new URI(property.getStringValue());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List getAttendees() {
        List properties = this.getProperties("ATTENDEE");
        if (properties == null) {
            return null;
        }
        ArrayList<CalUserAddress> result = new ArrayList<CalUserAddress>(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            CalUserAddress calUserAddress = CalUserAddress.makeCalUserAddress((ICalProperty)iterator.next());
            if (calUserAddress == null) continue;
            result.add(calUserAddress);
        }
        return result;
    }

    public List getComments() {
        List properties = this.getProperties("COMMENT");
        if (properties == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            result.add(((ICalProperty)iterator.next()).getStringValue());
        }
        return result;
    }

    public List getRequestStatuses() {
        List properties = this.getProperties("REQUEST-STATUS");
        if (properties == null) {
            return null;
        }
        ArrayList<RequestStatus> result = new ArrayList<RequestStatus>(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            try {
                RequestStatus requestStatus = new RequestStatus((ICalProperty)iterator.next());
                result.add(requestStatus);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

