/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.components;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.components.AbstractEventToDoJournalFreeBusy;
import com.atlassian.gregory.util.DateTimeParser;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEventToDoJournal
extends AbstractEventToDoJournalFreeBusy {
    public String getSummary() {
        ICalProperty property = this.getProperty("SUMMARY");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public int getSequence() {
        ICalProperty property = this.getProperty("SEQUENCE");
        if (property == null) {
            return -1;
        }
        return property.getIntValue();
    }

    public String getStatus() {
        ICalProperty property = this.getProperty("STATUS");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public String getDescription() {
        ICalProperty property = this.getProperty("DESCRIPTION");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public String getClassification() {
        ICalProperty property = this.getProperty("CLASS");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public Date getDateCreated() {
        return DateTimeParser.parseDate(this.getProperty("CREATED"));
    }

    public Date getLastModified() {
        return DateTimeParser.parseDate(this.getProperty("LAST-MODIFIED"));
    }

    public Date getRecurrenceId() {
        return DateTimeParser.parseDate(this.getProperty("RECURRENCE-ID"));
    }

    public List getCategories() {
        List properties = this.getProperties("CATEGORIES");
        if (properties == null) {
            return null;
        }
        ArrayList result = new ArrayList(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            ICalProperty property = (ICalProperty)iterator.next();
            result.addAll(property.getValues());
        }
        return result;
    }

    public List getContacts() {
        List properties = this.getProperties("CONTACT");
        if (properties == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            result.add(((ICalProperty)iterator.next()).getStringValue());
        }
        return result;
    }

    public List getRelatedUids() {
        List properties = this.getProperties("RELATED-TO");
        if (properties == null) {
            return null;
        }
        ArrayList result = new ArrayList(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            ICalProperty property = (ICalProperty)iterator.next();
            result.addAll(property.getValues());
        }
        return result;
    }
}

