/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory.components;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.ParseException;
import com.atlassian.gregory.components.AbstractEventToDoJournal;
import com.atlassian.gregory.components.ICalAlarm;
import com.atlassian.gregory.components.ICalComponent;
import com.atlassian.gregory.valuetypes.Duration;
import com.atlassian.gregory.valuetypes.GeographicPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEventToDo
extends AbstractEventToDoJournal {
    public int getPriority() {
        ICalProperty property = this.getProperty("PRIORITY");
        if (property == null) {
            return -1;
        }
        return property.getIntValue();
    }

    public GeographicPosition getGeographicPosition() {
        try {
            ICalProperty property = this.getProperty("GEO");
            if (property == null) {
                return null;
            }
            return new GeographicPosition(property.getStringValue());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getLocation() {
        ICalProperty property = this.getProperty("LOCATION");
        if (property == null) {
            return null;
        }
        return property.getStringValue();
    }

    public List getResources() {
        List properties = this.getProperties("RESOURCES");
        if (properties == null) {
            return null;
        }
        ArrayList result = new ArrayList(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            ICalProperty property = (ICalProperty)iterator.next();
            result.addAll(property.getValues());
        }
        return result;
    }

    public Duration getDuration() {
        ICalProperty property = this.getProperty("DURATION");
        if (property == null) {
            return null;
        }
        return new Duration(property.getStringValue());
    }

    public List getAlarms() {
        if (this.getComponents() == null || this.getComponents().size() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ICalComponent> result = new ArrayList<ICalComponent>(this.getComponents().size());
        Iterator iterator = this.getComponents().iterator();
        while (iterator.hasNext()) {
            ICalComponent component = (ICalComponent)iterator.next();
            if (!(component instanceof ICalAlarm)) continue;
            result.add(component);
        }
        return result;
    }

    public boolean allowsChildComponent(ICalComponent component) {
        if (component instanceof ICalAlarm) {
            return true;
        }
        return super.allowsChildComponent(component);
    }
}

