/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory;

import com.atlassian.gregory.ICalProperty;
import com.atlassian.gregory.ICalendar;
import com.atlassian.gregory.components.AbstractICalComponent;
import com.atlassian.gregory.components.ICalAlarm;
import com.atlassian.gregory.components.ICalComponent;
import com.atlassian.gregory.components.ICalEvent;
import com.atlassian.gregory.components.ICalToDo;
import com.atlassian.gregory.util.LineUnfolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ICalendarParser {
    public static ICalendar parse(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Cannot parse null InputStream");
        }
        ICalendar cal = new ICalendar();
        List unfoldedRawLines = LineUnfolder.unfoldRawLines(inputStream);
        String unfoldedLine = null;
        boolean inEvent = false;
        boolean inTodo = false;
        boolean inAlarm = false;
        boolean inCalendar = false;
        Stack<AbstractICalComponent> componentStack = new Stack<AbstractICalComponent>();
        Iterator iterator = unfoldedRawLines.iterator();
        while (iterator.hasNext()) {
            unfoldedLine = (String)iterator.next();
            if (inCalendar) {
                ICalProperty currentProperty = new ICalProperty(unfoldedLine);
                if (inEvent && !inAlarm) {
                    if (currentProperty.getRawLine().equals("END:VEVENT")) {
                        cal.addEvent((ICalEvent)componentStack.pop());
                        inEvent = false;
                    } else if (unfoldedLine.equals("BEGIN:VALARM")) {
                        inAlarm = true;
                        componentStack.push(new ICalAlarm());
                    } else {
                        ((ICalComponent)componentStack.peek()).addProperty(currentProperty);
                    }
                } else if (inAlarm) {
                    if (currentProperty.getRawLine().equals("END:VALARM")) {
                        ICalAlarm alarm = (ICalAlarm)componentStack.pop();
                        ((ICalComponent)componentStack.peek()).addComponent(alarm);
                        inAlarm = false;
                    } else {
                        ((ICalComponent)componentStack.peek()).addProperty(currentProperty);
                    }
                } else if (inTodo) {
                    if (currentProperty.getRawLine().equals("END:VTODO")) {
                        cal.addToDo((ICalToDo)componentStack.pop());
                        inTodo = false;
                    } else if (unfoldedLine.equals("BEGIN:VALARM")) {
                        inAlarm = true;
                        componentStack.push(new ICalAlarm());
                    } else {
                        ((ICalComponent)componentStack.peek()).addProperty(currentProperty);
                    }
                } else if (unfoldedLine.startsWith("X-")) {
                    cal.addNonStandardProperty(new ICalProperty(unfoldedLine));
                } else if (unfoldedLine.startsWith("PRODID:")) {
                    cal.setProducerId(new ICalProperty(unfoldedLine).getStringValue());
                } else if (unfoldedLine.startsWith("VERSION:")) {
                    cal.setVersion(new ICalProperty(unfoldedLine).getStringValue());
                } else if (unfoldedLine.startsWith("CALSCALE:")) {
                    cal.setCalendarScale(new ICalProperty(unfoldedLine).getStringValue());
                } else if (unfoldedLine.equals("BEGIN:VEVENT")) {
                    inEvent = true;
                    componentStack.push(new ICalEvent());
                } else if (unfoldedLine.equals("BEGIN:VTODO")) {
                    inTodo = true;
                    componentStack.push(new ICalToDo());
                } else if (unfoldedLine.equals("END:VCALENDAR")) {
                    inCalendar = false;
                    break;
                }
            } else if (unfoldedLine.equals("BEGIN:VCALENDAR")) {
                inCalendar = true;
            }
            unfoldedLine = null;
        }
        return cal;
    }
}

