/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gregory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ICalProperty {
    public static final char FIELD_SEPARATOR = ':';
    public static final char NAME_SEPARATOR = ';';
    public static final char PROPERTY_PARAMETER_SEPARATOR = '=';
    private String rawValue;
    private List values;
    private String name;
    private Map propertyParameters;
    private String rawLine;

    public ICalProperty(String line) {
        this.rawLine = line;
        char[] charArray = line.toCharArray();
        boolean inName = true;
        boolean inPropertyParameters = false;
        boolean inValue = false;
        boolean inPropName = false;
        boolean inPropValue = false;
        boolean inQuotedPropValue = false;
        this.name = "";
        this.propertyParameters = new HashMap();
        String curPropName = "";
        String curPropValue = "";
        for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            if (inName) {
                if (c == ';') {
                    inName = false;
                    inPropertyParameters = true;
                    inPropName = true;
                    continue;
                }
                if (c == ':') {
                    inName = false;
                    inValue = true;
                    continue;
                }
                this.name = this.name + c;
                continue;
            }
            if (inPropertyParameters) {
                if (inPropName && c == '=') {
                    inPropName = false;
                    inPropValue = true;
                    continue;
                }
                if (inPropName) {
                    if (curPropName == null) {
                        curPropName = "";
                    }
                    curPropName = curPropName + c;
                    continue;
                }
                if (!inPropValue) continue;
                if (curPropValue == null) {
                    curPropValue = "";
                }
                if (c == '\"') {
                    inQuotedPropValue = !inQuotedPropValue;
                    continue;
                }
                if (!(inQuotedPropValue || c != ';' && c != ':')) {
                    this.propertyParameters.put(curPropName, curPropValue);
                    curPropName = "";
                    curPropValue = "";
                    if (c == ';') {
                        inPropValue = false;
                        inPropName = true;
                        continue;
                    }
                    inPropValue = false;
                    inPropertyParameters = false;
                    inValue = true;
                    continue;
                }
                curPropValue = curPropValue + c;
                continue;
            }
            if (!inValue) continue;
            this.parseValues(new String(charArray, i, charArray.length - i));
            break;
        }
    }

    private void parseValues(String escapedValues) {
        char[] chars = escapedValues.toCharArray();
        this.rawValue = escapedValues;
        this.values = new ArrayList();
        String temp = "";
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\\' && i < chars.length && chars[i + 1] == ',') {
                temp = temp + ",";
                ++i;
                continue;
            }
            if (c == ',') {
                this.values.add(temp);
                temp = "";
                continue;
            }
            temp = temp + c;
        }
        this.values.add(temp);
    }

    public String getStringValue() {
        if (this.values.size() > 0) {
            return this.values.get(0).toString();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List getValues() {
        return this.values;
    }

    public Map getPropertyParameters() {
        return this.propertyParameters;
    }

    public String getRawLine() {
        return this.rawLine;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public String toString() {
        return this.rawLine;
    }

    public int getIntValue() {
        try {
            if (this.values.size() > 0) {
                return Integer.parseInt(this.values.get(0).toString());
            }
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ICalProperty)) {
            return false;
        }
        ICalProperty iCalLine = (ICalProperty)o;
        return this.rawLine.equals(iCalLine.rawLine);
    }

    public int hashCode() {
        return this.rawLine.hashCode();
    }
}

