/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.filter;

import com.opensymphony.module.sitemesh.Config;
import com.opensymphony.module.sitemesh.Decorator;
import com.opensymphony.module.sitemesh.Factory;
import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.RequestConstants;
import com.opensymphony.module.sitemesh.filter.PageResponseWrapper;
import com.opensymphony.module.sitemesh.util.Container;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PageFilter
implements Filter,
RequestConstants {
    private FilterConfig filterConfig = null;
    private Factory factory = null;

    public void doFilter(ServletRequest rq, ServletResponse rs, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)rq;
        if (rq.getAttribute("__sitemesh__filterapplied") != null || this.factory.isPathExcluded(this.extractRequestPath(request))) {
            chain.doFilter(rq, rs);
        } else {
            HttpServletResponse response;
            Page page;
            request.setAttribute("__sitemesh__filterapplied", (Object)Boolean.TRUE);
            if (Container.get() == 1) {
                request.getSession(true);
            }
            if ((page = this.parsePage(request, response = (HttpServletResponse)rs, chain)) != null) {
                page.setRequest(request);
                Decorator decorator = this.factory.getDecoratorMapper().getDecorator(request, page);
                if (decorator != null && decorator.getPage() != null) {
                    this.applyDecorator(page, decorator, request, response);
                    page = null;
                    return;
                }
                this.writeOriginal(request, response, page);
                page = null;
            }
        }
    }

    private String extractRequestPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        String pathInfo = request.getPathInfo();
        String query = request.getQueryString();
        return (servletPath == null ? "" : servletPath) + (pathInfo == null ? "" : pathInfo) + (query == null ? "" : "?" + query);
    }

    public void init(FilterConfig filterConfig) {
        if (filterConfig != null) {
            this.filterConfig = filterConfig;
            this.factory = Factory.getInstance(new Config(filterConfig));
        } else {
            this.destroy();
        }
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public void destroy() {
        this.factory = null;
    }

    protected Page parsePage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            PageResponseWrapper pageResponse = new PageResponseWrapper(response, this.factory);
            chain.doFilter((ServletRequest)request, (ServletResponse)pageResponse);
            Page result = (Page)request.getAttribute("__sitemesh__page");
            if (result == null) {
                result = pageResponse.getPage();
            }
            request.setAttribute("__sitemesh__using_stream", (Object)new Boolean(pageResponse.isUsingStream()));
            return result;
        }
        catch (IllegalStateException e) {
            if (Container.get() != 4) {
                throw e;
            }
            return null;
        }
    }

    protected void applyDecorator(Page page, Decorator decorator, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            request.setAttribute("__sitemesh__page", (Object)page);
            ServletContext context = this.filterConfig.getServletContext();
            if (decorator.getURIPath() != null && context.getContext(decorator.getURIPath()) != null) {
                context = context.getContext(decorator.getURIPath());
            }
            RequestDispatcher dispatcher = context.getRequestDispatcher(decorator.getPage());
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
            while (decorator.getInitParameterNames().hasNext()) {
                String initParam = (String)decorator.getInitParameterNames().next();
                if (!initParam.startsWith("header.")) continue;
                response.setHeader(initParam.substring(initParam.indexOf(46)), decorator.getInitParameter(initParam));
            }
            request.removeAttribute("__sitemesh__page");
        }
        catch (RuntimeException e) {
            if (Container.get() == 1) {
                e.printStackTrace();
            }
            throw e;
        }
    }

    private void writeOriginal(HttpServletRequest request, HttpServletResponse response, Page page) throws IOException {
        this.writeContentLength(response, page);
        if (request.getAttribute("__sitemesh__using_stream").equals(Boolean.TRUE)) {
            PrintWriter writer = new PrintWriter((OutputStream)response.getOutputStream());
            page.writePage(writer);
            writer.flush();
            response.getOutputStream().flush();
        } else {
            page.writePage(response.getWriter());
            response.getWriter().flush();
        }
    }

    private void writeContentLength(HttpServletResponse response, Page page) throws IOException {
        ByteCountingNullOutputStream countingStream = new ByteCountingNullOutputStream();
        BufferedWriter countingWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)countingStream, response.getCharacterEncoding()));
        page.writePage(countingWriter);
        ((Writer)countingWriter).flush();
        response.setContentLength((int)countingStream.getByteCount());
    }

    private static class ByteCountingNullOutputStream
    extends OutputStream {
        private long byteCount = 0L;

        public void write(int i) throws IOException {
            ++this.byteCount;
        }

        public void write(byte[] bytes) throws IOException {
            this.byteCount += (long)bytes.length;
        }

        public void write(byte[] bytes, int i, int len) throws IOException {
            this.byteCount += (long)len;
        }

        public long getByteCount() {
            return this.byteCount;
        }
    }
}

