/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.trackback;

import com.atlassian.trackback.Trackback;
import com.atlassian.trackback.TrackbackException;
import com.atlassian.trackback.TrackbackStore;
import com.opensymphony.util.ClassLoaderUtil;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TrackbackListenerServlet
implements Servlet {
    private ServletConfig servletConfig;
    private TrackbackStore store;
    private static Log log = LogFactory.getLog((Class)(class$com$atlassian$trackback$TrackbackListenerServlet == null ? (class$com$atlassian$trackback$TrackbackListenerServlet = TrackbackListenerServlet.class$("com.atlassian.trackback.TrackbackListenerServlet")) : class$com$atlassian$trackback$TrackbackListenerServlet));
    static /* synthetic */ Class class$com$atlassian$trackback$TrackbackListenerServlet;

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        String title = servletRequest.getParameter("title");
        String excerpt = servletRequest.getParameter("excerpt");
        String url = servletRequest.getParameter("url");
        String blogName = servletRequest.getParameter("blog_name");
        if (url == null) {
            this.sendErrorMessage("No url given.", servletResponse);
            return;
        }
        if (title == null) {
            title = url;
        }
        Trackback tb = new Trackback();
        tb.setTitle(title);
        tb.setUrl(url);
        tb.setExcerpt(excerpt);
        tb.setBlogName(blogName);
        try {
            if (this.store == null) {
                throw new TrackbackException("Store not configured. Please check the trackbackStore param is set in web.xml, and the specified class exists.");
            }
            this.store.storeTrackback(tb, (HttpServletRequest)servletRequest);
            this.sendSuccess(servletResponse);
        }
        catch (TrackbackException e) {
            log.error((Object)e);
            this.sendErrorMessage("Internal error - could not store ping - " + e.getMessage(), servletResponse);
        }
    }

    private void sendErrorMessage(String errorMessage, ServletResponse servletResponse) throws IOException {
        servletResponse.setContentType("text/xml");
        servletResponse.getWriter().write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<response>\n<error>1</error>\n<message>" + errorMessage + "</message>\n" + "</response>");
    }

    private void sendSuccess(ServletResponse servletResponse) throws IOException {
        servletResponse.setContentType("text/xml");
        servletResponse.getWriter().write("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n<response>\n<error>0</error>\n</response>");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        String storageClass = servletConfig.getInitParameter("trackbackStore");
        try {
            this.store = (TrackbackStore)ClassLoaderUtil.loadClass((String)storageClass, this.getClass()).newInstance();
        }
        catch (Exception e) {
            log.error((Object)("Could not find or create class: " + storageClass + " from init-param named trackbackStore"), (Throwable)e);
        }
    }

    public void destroy() {
    }

    public String getServletInfo() {
        return "A servlet which listens for trackback pings and stores them via a TrackbackStore.";
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

