/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.trackback;

import com.atlassian.trackback.TrackbackFinder;
import com.atlassian.trackback.TrackbackUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultTrackbackFinder
implements TrackbackFinder {
    private Log log = LogFactory.getLog((Class)(class$com$atlassian$trackback$DefaultTrackbackFinder == null ? (class$com$atlassian$trackback$DefaultTrackbackFinder = DefaultTrackbackFinder.class$("com.atlassian.trackback.DefaultTrackbackFinder")) : class$com$atlassian$trackback$DefaultTrackbackFinder));
    static /* synthetic */ Class class$com$atlassian$trackback$DefaultTrackbackFinder;

    public List findPingUrls(String content) {
        return this.findPingUrls(TrackbackUtils.getHttpLinks(content));
    }

    public List findPingUrls(Collection urlLinks) {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = urlLinks.iterator();
        while (iterator.hasNext()) {
            try {
                String hyperlink = (String)iterator.next();
                String remoteContent = TrackbackUtils.getUrlContent(hyperlink);
                if (remoteContent == null) {
                    this.log.debug((Object)("No remote content found for url: " + hyperlink));
                    continue;
                }
                String pingUrl = TrackbackUtils.getTrackbackUrl(remoteContent, hyperlink);
                if (pingUrl == null) {
                    this.log.debug((Object)"No trackback URL found in content.");
                    continue;
                }
                result.add(pingUrl);
            }
            catch (IOException e) {
                this.log.warn((Object)"Error parsing text for trackback pings", (Throwable)e);
            }
            catch (RuntimeException re) {
                this.log.error((Object)"Error parsing text for trackback pings", (Throwable)re);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

