/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.sql;

import com.mchange.lang.ThrowableUtils;
import com.mchange.v2.lang.VersionUtils;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SqlUtils {
    static final DateFormat tsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
    public static final String DRIVER_MANAGER_USER_PROPERTY = "user";
    public static final String DRIVER_MANAGER_PASSWORD_PROPERTY = "password";

    public static String escapeBadSqlPatternChars(String s) {
        StringBuffer sb = new StringBuffer(s);
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            if (sb.charAt(i) != '\'') continue;
            sb.insert(i, '\'');
            ++len;
            i += 2;
        }
        return sb.toString();
    }

    public static String escapeAsTimestamp(Date date) {
        return "{ts '" + tsdf.format(date) + "'}";
    }

    public static SQLException toSQLException(Throwable t) {
        return SqlUtils.toSQLException("An SQLException was provoked by the following failure: " + t.toString(), t);
    }

    public static SQLException toSQLException(String msg, Throwable t) {
        if (t instanceof SQLException) {
            return (SQLException)t;
        }
        if (VersionUtils.isAtLeastJavaVersion14()) {
            SQLException out = new SQLException(msg);
            out.initCause(t);
            return out;
        }
        return new SQLException(msg + System.getProperty("line.separator") + "[Cause: " + ThrowableUtils.extractStackTrace(t) + ']');
    }

    private SqlUtils() {
    }
}

