/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.userlister.model;

import com.atlassian.confluence.extra.userlister.model.ListedUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class UserList {
    private String groupName;
    private List users;
    private UserAccessor userAccessor;

    public UserList(String string, UserAccessor userAccessor) {
        this.groupName = string;
        this.userAccessor = userAccessor;
    }

    public String getGroup() {
        return this.groupName;
    }

    public List getUsers() {
        return this.users;
    }

    public boolean build(boolean bl, Collection collection, boolean bl2) {
        List list = this.getGroupUsers();
        if (list == null) {
            return false;
        }
        this.users = new ArrayList(list.size());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            User user = null;
            user = e instanceof User ? (User)e : this.userAccessor.getUser((String)e);
            if (user == null || this.groupName != null && this.userAccessor.isDeactivated(user)) continue;
            boolean bl3 = collection.contains(user.getName());
            if (bl && bl3 != bl2) continue;
            this.users.add(new ListedUser(user, bl3));
        }
        this.sortUsers();
        return true;
    }

    private List getGroupUsers() {
        Pager pager = null;
        if (this.groupName == null) {
            pager = this.userAccessor.getUsersWithConfluenceAccess();
        } else {
            Group group = this.userAccessor.getGroup(this.groupName);
            if (group != null) {
                pager = this.userAccessor.getMemberNames(group);
            }
        }
        return PagerUtils.toList((Pager)pager);
    }

    private void sortUsers() {
        Collections.sort(this.users, new Comparator(){

            public int compare(Object object, Object object2) {
                ListedUser listedUser = (ListedUser)object;
                ListedUser listedUser2 = (ListedUser)object2;
                if (listedUser == null && listedUser2 == null) {
                    return 0;
                }
                if (listedUser2 == null) {
                    return -1;
                }
                if (listedUser == null) {
                    return 1;
                }
                String string = listedUser.getFullName();
                String string2 = listedUser2.getFullName();
                if (string == null) {
                    string = listedUser.getName();
                }
                if (string2 == null) {
                    string2 = listedUser2.getName();
                }
                if (string == null || string2 == null) {
                    throw new RuntimeException("Null user name");
                }
                return string.toLowerCase().compareTo(string2.toLowerCase());
            }
        });
    }
}

