/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class DelayCloseIndexSearcher
extends IndexSearcher {
    private final Directory directory;
    private final long version;
    private int usageCount;
    private boolean shouldCloseWhenDone;
    private static final Logger logger = Logger.getLogger((class$org$apache$lucene$search$DelayCloseIndexSearcher == null ? (class$org$apache$lucene$search$DelayCloseIndexSearcher = DelayCloseIndexSearcher.class$("org.apache.lucene.search.DelayCloseIndexSearcher")) : class$org$apache$lucene$search$DelayCloseIndexSearcher).getName());
    static /* synthetic */ Class class$org$apache$lucene$search$DelayCloseIndexSearcher;

    public DelayCloseIndexSearcher(String string) throws IOException {
        super(string);
        this.directory = FSDirectory.getDirectory((String)string, (boolean)false);
        this.version = IndexReader.getCurrentVersion((Directory)this.directory);
    }

    public DelayCloseIndexSearcher(Directory directory) throws IOException {
        super(directory);
        this.version = IndexReader.getCurrentVersion((Directory)directory);
        this.directory = directory;
        this.usageCount = 0;
        this.shouldCloseWhenDone = false;
        logger.finer("<init>");
    }

    public DelayCloseIndexSearcher(IndexReader indexReader, Directory directory) throws IOException {
        super(indexReader);
        this.version = IndexReader.getCurrentVersion((Directory)directory);
        this.directory = directory;
        this.usageCount = 0;
        this.shouldCloseWhenDone = false;
        logger.finer("<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            if (this.shouldCloseWhenDone) {
                throw new IllegalStateException("closeWhenDone() already called");
            }
            ++this.usageCount;
        }
        logger.finest("open()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWhenDone() throws IOException {
        boolean doClose;
        logger.finer("closeWhenDone()");
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            if (this.shouldCloseWhenDone) {
                throw new IllegalStateException("closeWhenDone() already called");
            }
            this.shouldCloseWhenDone = true;
            doClose = this.usageCount == 0;
        }
        if (doClose) {
            logger.finer("super.close()");
            super.close();
        }
    }

    public boolean isCurrent() throws IOException {
        return this.version == IndexReader.getCurrentVersion((Directory)this.directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            return this.shouldCloseWhenDone && this.usageCount == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        boolean doClose;
        logger.finest("close()");
        DelayCloseIndexSearcher delayCloseIndexSearcher = this;
        synchronized (delayCloseIndexSearcher) {
            if (this.usageCount <= 0) {
                throw new IllegalStateException("usageCount<=0");
            }
            doClose = --this.usageCount == 0 && this.shouldCloseWhenDone;
        }
        if (doClose) {
            logger.finer("super.close()");
            super.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

