/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.index;

import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.index.BaseDocumentWritingScheme;
import com.atlassian.bonnie.index.BaseMultiThreadedIndexer;
import com.atlassian.bonnie.index.BatchOpIndexer;
import com.atlassian.bonnie.index.TempIndexWriter;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;

public class TempDirectoryDocumentWritingScheme
extends BaseDocumentWritingScheme {
    protected final TempIndexWriter tempIndexWriter;

    public TempDirectoryDocumentWritingScheme(BatchOpIndexer indexer) {
        this(indexer, null);
    }

    public TempDirectoryDocumentWritingScheme(BatchOpIndexer indexer, String tmpDir) {
        this.tempIndexWriter = new TempIndexWriter(indexer.getAnalyzer(), tmpDir);
    }

    public void write(Document doc) {
        if (doc == null) {
            this.progress.incrementCounter();
            return;
        }
        String key = this.getWriterKey(doc);
        try {
            this.tempIndexWriter.addDocument(key, doc);
            this.progress.incrementCounter("Indexed: " + this.getDocumentTitle(doc) + " - " + this.progress.progressAsString());
        }
        catch (IOException e) {
            this.progress.incrementCounter("Error indexing: " + this.getDocumentTitle(doc) + " (" + e.toString() + ") - " + this.progress.progressAsString());
            BaseMultiThreadedIndexer.log.error((Object)"Error encountered", (Throwable)e);
        }
    }

    protected String getWriterKey(Document doc) {
        return Thread.currentThread().getName();
    }

    protected String getDocumentTitle(Document doc) {
        return doc.get("title");
    }

    public void runComplete() {
    }

    public void close(LuceneConnection luceneConnection) throws IOException {
        luceneConnection.withWriter(new LuceneConnection.WriterAction(){

            public void perform(IndexWriter writer) throws IOException {
                TempDirectoryDocumentWritingScheme.this.tempIndexWriter.merge(writer);
            }
        }, 4);
        this.tempIndexWriter.closeAll();
        luceneConnection.close();
    }
}

