/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie.index;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.bonnie.LuceneException;
import com.atlassian.bonnie.index.BaseMultiThreadedIndexer;
import com.atlassian.bonnie.index.BatchOpIndexer;
import com.atlassian.bonnie.index.ObjectToDocumentConverter;
import com.atlassian.bonnie.index.QueueProcessingRunnableImpl;
import com.atlassian.bonnie.index.SingleDocumentWritingScheme;
import com.atlassian.bonnie.index.SingleObjectIndexer;
import com.atlassian.bonnie.index.SingletonObjectQueue;
import com.atlassian.bonnie.index.TempDirectoryDocumentWritingScheme;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;

public class OnlineMultiThreadedIndexer
extends BaseMultiThreadedIndexer
implements SingleObjectIndexer {
    protected LinkedQueue reindexAddedQueue = new LinkedQueue();
    protected LinkedQueue reindexDeletedQueue = new LinkedQueue();
    private ObjectToDocumentConverter objectToDocumentConverter;

    protected void allThreadsComplete(final BatchOpIndexer.DocumentWritingScheme scheme, final boolean truncate) {
        this.luceneConnection.withBatchUpdate(new LuceneConnection.BatchUpdateAction(){

            public void perform() throws Exception {
                OnlineMultiThreadedIndexer.this.setReindexingStatus(true);
                if (truncate) {
                    OnlineMultiThreadedIndexer.this.truncateIndex();
                }
                scheme.close(OnlineMultiThreadedIndexer.this.luceneConnection);
                if (OnlineMultiThreadedIndexer.this.flushReindexingQueues()) {
                    OnlineMultiThreadedIndexer.this.optimize(OnlineMultiThreadedIndexer.this.luceneConnection);
                }
                OnlineMultiThreadedIndexer.this.setReindexingStatus(false);
            }
        });
    }

    public void index(final Object o) {
        this.luceneConnection.withBatchUpdate(new LuceneConnection.BatchUpdateAction(){

            public void perform() throws IOException {
                if (OnlineMultiThreadedIndexer.this.isReindexing()) {
                    try {
                        if (BaseMultiThreadedIndexer.log.isDebugEnabled()) {
                            BaseMultiThreadedIndexer.log.debug((Object)("Adding object:" + o + " to reindexaddedqueue"));
                        }
                        OnlineMultiThreadedIndexer.this.reindexAddedQueue.put(o);
                    }
                    catch (InterruptedException e) {
                        BaseMultiThreadedIndexer.log.error((Object)"Error encountered adding object to reindexaddedqueue", (Throwable)e);
                    }
                }
                OnlineMultiThreadedIndexer.this.unindex(o);
                BatchOpIndexer.DocumentWritingScheme scheme = OnlineMultiThreadedIndexer.this.getDocumentWritingScheme(false);
                QueueProcessingRunnableImpl r = new QueueProcessingRunnableImpl(new SingletonObjectQueue(o, OnlineMultiThreadedIndexer.this.objectToDocumentConverter), scheme);
                r.run();
            }
        });
    }

    protected void doAdd(Object o, IndexWriter writer) throws IOException {
        writer.addDocument(this.objectToDocumentConverter.convert(o, null));
    }

    public void unindex(final Object o) {
        this.luceneConnection.withBatchUpdate(new LuceneConnection.BatchUpdateAction(){

            public void perform() throws IOException {
                if (OnlineMultiThreadedIndexer.this.isReindexing()) {
                    try {
                        if (BaseMultiThreadedIndexer.log.isDebugEnabled()) {
                            BaseMultiThreadedIndexer.log.debug((Object)("Adding object:" + o + " to reindexdeletedqueue"));
                        }
                        OnlineMultiThreadedIndexer.this.reindexDeletedQueue.put(o);
                    }
                    catch (InterruptedException e) {
                        BaseMultiThreadedIndexer.log.error((Object)"Error encountered adding object to reindexdeletedqueue", (Throwable)e);
                    }
                }
                OnlineMultiThreadedIndexer.this.luceneConnection.withReaderAndDeletes(new LuceneConnection.ReaderAction(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object perform(IndexReader reader) throws IOException {
                        3.access$300(this.this$1).doDelete(3.access$200(this.this$1), reader);
                        return null;
                    }
                });
            }

            static /* synthetic */ Object access$200(3 x0) {
                return x0.o;
            }

            static /* synthetic */ OnlineMultiThreadedIndexer access$300(3 x0) {
                return x0.OnlineMultiThreadedIndexer.this;
            }
        });
    }

    protected void doDelete(Object o, IndexReader reader) throws IOException {
        String[] identity = this.objectToDocumentConverter.getObjectIdentity(o);
        reader.delete(new Term(identity[0], identity[1]));
    }

    protected final void optimize(LuceneConnection conn) {
        conn.withWriter(new LuceneConnection.WriterAction(){

            public void perform(IndexWriter writer) throws IOException {
                writer.optimize();
            }
        });
    }

    private boolean flushReindexingQueues() {
        boolean somethingflushed = false;
        if (!this.reindexDeletedQueue.isEmpty()) {
            this.luceneConnection.withReaderAndDeletes(new LuceneConnection.ReaderAction(){

                public Object perform(IndexReader reader) throws IOException {
                    try {
                        Object o = OnlineMultiThreadedIndexer.this.reindexDeletedQueue.take();
                        while (!OnlineMultiThreadedIndexer.this.reindexDeletedQueue.isEmpty()) {
                            OnlineMultiThreadedIndexer.this.doDelete(o, reader);
                            o = OnlineMultiThreadedIndexer.this.reindexDeletedQueue.take();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new LuceneException(e);
                    }
                    return null;
                }
            });
            somethingflushed = true;
        }
        if (!this.reindexAddedQueue.isEmpty()) {
            this.luceneConnection.withWriter(new LuceneConnection.WriterAction(){

                public void perform(IndexWriter writer) throws IOException {
                    try {
                        Object o = OnlineMultiThreadedIndexer.this.reindexAddedQueue.take();
                        while (!OnlineMultiThreadedIndexer.this.reindexAddedQueue.isEmpty()) {
                            OnlineMultiThreadedIndexer.this.doAdd(o, writer);
                            o = OnlineMultiThreadedIndexer.this.reindexAddedQueue.take();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new LuceneException(e);
                    }
                }
            });
            somethingflushed = true;
        }
        return somethingflushed;
    }

    protected BatchOpIndexer.DocumentWritingScheme getDocumentWritingScheme(boolean reindex) {
        if (reindex) {
            return new TempDirectoryDocumentWritingScheme(this);
        }
        return new SingleDocumentWritingScheme(this.luceneConnection);
    }

    public void setLuceneConnection(LuceneConnection luceneConnection) {
        this.luceneConnection = luceneConnection;
    }

    protected ObjectToDocumentConverter getObjectToDocumentConverter() {
        return this.objectToDocumentConverter;
    }

    public void setObjectToDocumentConverter(ObjectToDocumentConverter objectToDocumentConverter) {
        this.objectToDocumentConverter = objectToDocumentConverter;
    }

    public Analyzer getAnalyzer() {
        return new StandardAnalyzer();
    }

    protected void setReindexingStatus(boolean status) throws IOException {
        this.luceneConnection.setReIndexing(status);
        this.setReindexing(status);
    }
}

