/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import com.atlassian.bonnie.LuceneException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexUtils;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneConnection {
    public static final Category LOG = Category.getInstance((Class)(class$com$atlassian$bonnie$LuceneConnection == null ? (class$com$atlassian$bonnie$LuceneConnection = LuceneConnection.class$("com.atlassian.bonnie.LuceneConnection")) : class$com$atlassian$bonnie$LuceneConnection));
    private static final int MAX_FIELD_LENGTH = 1000000;
    public static final int WRITER_DEFAULT = 1;
    public static final int WRITER_INTERACTIVE = 2;
    public static final int WRITER_BATCH = 4;
    public static final int COMPOUND_FILE = 8;
    public static final String REINDEXING_FILENAME = ".reindexing";
    protected Analyzer analyzerForIndexing;
    protected boolean searcherOpensNewReader = true;
    private File indexDir = null;
    private Directory directory = null;
    private final ReentrantWriterPreferenceReadWriteLock sync = new ReentrantWriterPreferenceReadWriteLock();
    private final Object createLock = new Object();
    private IndexReader reader = null;
    private IndexWriter writer = null;
    private long readerVersion = -1L;
    private boolean alwaysUnlock = true;
    static /* synthetic */ Class class$com$atlassian$bonnie$LuceneConnection;

    public LuceneConnection() {
    }

    public LuceneConnection(File location, Analyzer analyzerForIndexing) {
        this.indexDir = location;
        this.analyzerForIndexing = analyzerForIndexing;
    }

    public LuceneConnection(Directory directory, Analyzer analyzerForIndexing) {
        this.directory = directory;
        this.analyzerForIndexing = analyzerForIndexing;
    }

    public void withSearch(SearcherAction action) throws LuceneException {
        IndexSearcher searcher = null;
        this.grabReadLock();
        try {
            searcher = this.getSearcher();
            if (action.perform(searcher)) {
                searcher.close();
            }
        }
        catch (Throwable e) {
            if (searcher != null) {
                try {
                    searcher.close();
                }
                catch (Throwable t) {
                    LOG.debug((Object)t);
                }
            }
            throw new LuceneException(e);
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected IndexSearcher getSearcher() throws IOException {
        if (this.searcherOpensNewReader) {
            return new IndexSearcher(this.getDirectory(false));
        }
        return new IndexSearcher(this.getReader());
    }

    public Object withReader(ReaderAction action) throws LuceneException {
        Object result = null;
        this.grabReadLock();
        try {
            IndexReader reader = this.getReader();
            result = action.perform(reader);
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseReadLock();
        }
        return result;
    }

    public void withReaderAndDeletes(ReaderAction action) throws LuceneException {
        this.grabWriteLock();
        try {
            this.unlockIfNeeded();
            this.closeWriter();
            IndexReader reader = this.getReader();
            action.perform(reader);
            this.closeReader();
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void withWriter(WriterAction action) throws LuceneException {
        this.withWriter(action, 2);
    }

    public void withWriter(WriterAction action, int flags) throws LuceneException {
        this.grabWriteLock();
        try {
            this.unlockIfNeeded();
            IndexWriter writer = this.getWriter(flags);
            action.perform(writer);
            if (!this.isReIndexing()) {
                this.closeWriter();
            }
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void withBatchUpdate(BatchUpdateAction action) {
        this.grabWriteLock();
        try {
            action.perform();
        }
        catch (Exception e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void optimize() throws LuceneException {
        this.grabWriteLock();
        try {
            IndexWriter writer = this.getWriter();
            writer.optimize();
            this.closeWriter();
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void setSearcherOpensNewReader(boolean searcherOpensNewReader) {
        this.searcherOpensNewReader = searcherOpensNewReader;
    }

    private IndexWriter createAndConfigureWriter(int flags) throws LuceneException {
        try {
            LOG.debug((Object)(Thread.currentThread().getName() + "## opening writer"));
            IndexWriter writer = new IndexWriter(this.getDirectory(false), this.analyzerForIndexing, false);
            this.configureWriter(writer, flags);
            return writer;
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
    }

    protected void configureWriter(IndexWriter writer, int flags) {
        writer.maxFieldLength = 1000000;
        if (LuceneConnection.isSet(flags, 8)) {
            writer.setUseCompoundFile(true);
        } else {
            writer.setUseCompoundFile(false);
        }
        if (LuceneConnection.isSet(flags, 4)) {
            writer.mergeFactor = 50;
            writer.minMergeDocs = 300;
            writer.maxMergeDocs = Integer.MAX_VALUE;
        } else if (LuceneConnection.isSet(flags, 2)) {
            writer.mergeFactor = 4;
            writer.minMergeDocs = 300;
            writer.maxMergeDocs = 5000;
        }
    }

    private static boolean isSet(int flags, int f) {
        return (flags & f) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushWriter() throws LuceneException {
        this.grabWriteLock();
        try {
            this.closeReader();
            this.closeWriter();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected final IndexReader getReader() throws LuceneException {
        Object object = this.createLock;
        synchronized (object) {
            try {
                if (this.reader == null) {
                    this.createIndexDirectory(false);
                    LOG.debug((Object)(Thread.currentThread().getName() + "##opening reader"));
                    this.readerVersion = IndexReader.getCurrentVersion((Directory)this.getDirectory(false));
                    this.reader = IndexReader.open((Directory)this.getDirectory(false));
                } else {
                    long v = IndexReader.getCurrentVersion((Directory)this.getDirectory(false));
                    if (v != this.readerVersion) {
                        this.createIndexDirectory(false);
                        LOG.debug((Object)(Thread.currentThread().getName() + "Refreshing reader"));
                        this.reader.close();
                        this.reader = IndexReader.open((Directory)this.getDirectory(false));
                        this.readerVersion = v;
                    }
                }
                return this.reader;
            }
            catch (IOException e) {
                throw new LuceneException(e);
            }
        }
    }

    protected IndexWriter getWriter() throws LuceneException {
        return this.getWriter(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexWriter getWriter(int flags) throws LuceneException {
        Object object = this.createLock;
        synchronized (object) {
            this.createIndexDirectory(false);
            this.closeReader();
            if (this.writer == null) {
                this.writer = this.createAndConfigureWriter(flags);
            }
            return this.writer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWriter() {
        Object object = this.createLock;
        synchronized (object) {
            if (this.writer != null) {
                try {
                    IndexWriter writer = this.writer;
                    this.writer = null;
                    LOG.debug((Object)(Thread.currentThread().getName() + "##closing writer"));
                    writer.close();
                }
                catch (IOException e) {
                    System.err.println(Level.WARN + "problem closing index writer" + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeReader() {
        Object object = this.createLock;
        synchronized (object) {
            if (this.reader != null) {
                try {
                    IndexReader reader = this.reader;
                    this.reader = null;
                    LOG.debug((Object)(Thread.currentThread().getName() + "##closing reader"));
                    reader.close();
                }
                catch (IOException e) {
                    LOG.error((Object)("problem closing index reader" + e));
                }
            }
        }
    }

    private void grabReadLock() throws LuceneException {
        try {
            this.sync.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new LuceneException(e);
        }
    }

    private void releaseReadLock() {
        this.sync.readLock().release();
    }

    private void grabWriteLock() throws LuceneException {
        try {
            this.sync.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new LuceneException(e);
        }
    }

    private void releaseWriteLock() {
        this.sync.writeLock().release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.grabWriteLock();
            try {
                this.closeReader();
                this.closeWriter();
            }
            finally {
                this.releaseWriteLock();
            }
        }
        catch (LuceneException e) {
            LOG.error((Object)("problem closing lucene connection" + e));
        }
    }

    public boolean isReIndexing() throws IOException {
        return this.getDirectory(false).fileExists(REINDEXING_FILENAME);
    }

    public void setReIndexing(boolean b) throws IOException {
        if (!b) {
            if (this.isReIndexing()) {
                this.getDirectory(false).deleteFile(REINDEXING_FILENAME);
                this.closeWriter();
            }
        } else if (b && !this.isReIndexing()) {
            Directory directory = this.getDirectory(false);
            if (!directory.fileExists(REINDEXING_FILENAME)) {
                directory.createOutput(REINDEXING_FILENAME).close();
            } else {
                directory.touchFile(REINDEXING_FILENAME);
            }
        }
    }

    public void recreateIndexDirectory() throws IOException {
        this.createIndexDirectory(true);
    }

    protected boolean shouldCreateIndexDirectory() throws IOException {
        return !this.isIndexCreated();
    }

    private void createIndexDirectory(boolean forceCreate) {
        try {
            if (forceCreate || this.shouldCreateIndexDirectory()) {
                new IndexWriter(this.getDirectory(true), null, true).close();
            }
        }
        catch (IOException e) {
            throw new LuceneException("Cannot create index directory", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateIndex() throws IOException {
        this.grabWriteLock();
        try {
            IndexUtils.truncateIndex(this.getDirectory(false));
        }
        catch (FileNotFoundException e) {
            this.recreateIndexDirectory();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    protected Directory getDirectory(boolean create) throws IOException {
        if (this.directory == null) {
            File indexDir = this.getIndexDir();
            if (!indexDir.exists() && !indexDir.mkdir()) {
                throw new IOException("Unable to create index directory '" + indexDir.getAbsolutePath() + "'");
            }
            this.directory = FSDirectory.getDirectory((File)indexDir, (boolean)create);
        }
        return this.directory;
    }

    public File getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String location) {
        this.indexDir = new File(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumDocs() {
        int count = -1;
        try {
            this.grabReadLock();
            count = this.getReader().numDocs();
        }
        finally {
            this.releaseReadLock();
        }
        return count;
    }

    public boolean isIndexCreated() {
        try {
            return IndexReader.indexExists((Directory)this.getDirectory(false));
        }
        catch (IOException e) {
            return false;
        }
    }

    public void unlockIfNeeded() throws IOException {
        if (this.alwaysUnlock) {
            IndexReader.unlock((Directory)this.getDirectory(false));
        }
    }

    public void setAlwaysUnlock(boolean alwaysUnlock) {
        this.alwaysUnlock = alwaysUnlock;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TempIndexWriterData {
        public final IndexWriter writer;
        public final Directory dir;
        public final File tmpIndexDir;

        public TempIndexWriterData(IndexWriter writer, Directory dir, File tmpIndexDir) {
            this.writer = writer;
            this.dir = dir;
            this.tmpIndexDir = tmpIndexDir;
        }
    }

    public static interface BatchUpdateAction {
        public void perform() throws Exception;
    }

    public static interface WriterAction {
        public void perform(IndexWriter var1) throws IOException;
    }

    public static interface ReaderAction {
        public Object perform(IndexReader var1) throws IOException;
    }

    public static interface SearcherAction {
        public boolean perform(IndexSearcher var1) throws IOException;
    }
}

