/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bonnie;

import com.atlassian.bonnie.LuceneUtils;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class DateFilterQuery
extends Query {
    private final String from;
    private final String to;
    private final String field;
    private final boolean inclusive;

    public DateFilterQuery(String from, String to, String field, boolean inclusive) {
        this.from = from;
        this.to = to;
        this.field = field;
        this.inclusive = inclusive;
    }

    protected Weight createWeight(Searcher searcher) throws IOException {
        return new DateFilterWeight(searcher);
    }

    public String toString(String string) {
        return this.field + ":[" + this.from + "-" + this.to + "]";
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getField() {
        return this.field;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public static boolean shouldSkip(int doc, DateFilterQuery dfq, String[] fieldcache) {
        boolean skip = false;
        if (dfq != null) {
            String datestring = fieldcache[doc];
            long time = LuceneUtils.stringToDate(datestring).getTime();
            if (dfq.isInclusive()) {
                if (dfq.getFrom() != null && time < LuceneUtils.stringToDate(dfq.getFrom()).getTime() || dfq.getTo() != null && time > LuceneUtils.stringToDate(dfq.getTo()).getTime()) {
                    skip = true;
                }
            } else if (dfq.getFrom() != null && time <= LuceneUtils.stringToDate(dfq.getFrom()).getTime() || dfq.getTo() != null && time >= LuceneUtils.stringToDate(dfq.getTo()).getTime()) {
                skip = true;
            }
        }
        return skip;
    }

    public static Query extractDateFilterQuery(Query query, Query[] placeholder) {
        if (query instanceof BooleanQuery) {
            BooleanQuery original = (BooleanQuery)query;
            BooleanQuery rewritten = new BooleanQuery();
            BooleanClause[] clauses = original.getClauses();
            for (int i = 0; i < clauses.length; ++i) {
                Query clauseq = DateFilterQuery.extractDateFilterQuery(clauses[i].query, placeholder);
                if (clauseq == null || clauseq instanceof BooleanQuery && ((BooleanQuery)clauseq).getClauses().length == 0) continue;
                rewritten.add(clauseq, clauses[i].required, clauses[i].prohibited);
            }
            return rewritten;
        }
        if (query instanceof DateFilterQuery) {
            if (placeholder != null) {
                placeholder[0] = query;
            }
            return null;
        }
        return query;
    }

    protected class ConstantScorer
    extends Scorer {
        final float theScore;
        int doc = -1;

        public ConstantScorer(Similarity similarity, IndexReader reader, Weight w) throws IOException {
            super(similarity);
            this.theScore = w.getValue();
        }

        public boolean next() throws IOException {
            return false;
        }

        public int doc() {
            return this.doc;
        }

        public float score() throws IOException {
            return this.theScore;
        }

        public boolean skipTo(int target) throws IOException {
            return false;
        }

        public Explanation explain(int doc) throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    protected class DateFilterWeight
    implements Weight {
        private Searcher searcher;
        private float queryNorm;
        private float queryWeight;

        public DateFilterWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Query getQuery() {
            return DateFilterQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = DateFilterQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return new ConstantScorer(DateFilterQuery.this.getSimilarity(this.searcher), reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation result = new Explanation();
            return result;
        }
    }
}

