/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.File;
import java.io.IOException;
import org.apache.catalina.Container;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.storeconfig.StoreAppender;
import org.apache.catalina.storeconfig.StoreDescription;

public class StoreContextAppender
extends StoreAppender {
    public boolean isPrintValue(Object bean, Object bean2, String attrName, StoreDescription desc) {
        boolean isPrint = super.isPrintValue(bean, bean2, attrName, desc);
        if (isPrint) {
            Container host;
            StandardContext context = (StandardContext)bean;
            if ("workDir".equals(attrName)) {
                String defaultWorkDir = this.getDefaultWorkDir(context);
                isPrint = !defaultWorkDir.equals(context.getWorkDir());
            } else if ("path".equals(attrName)) {
                isPrint = desc.isStoreSeparate() && desc.isExternalAllowed() && context.getConfigFile() == null;
            } else if ("docBase".equals(attrName) && (host = context.getParent()) instanceof StandardHost) {
                File docBase;
                File appBase = this.getAppBase((StandardHost)host);
                isPrint = !appBase.equals((docBase = this.getDocBase(context, appBase)).getParentFile());
            }
        }
        return isPrint;
    }

    protected File getAppBase(StandardHost host) {
        File appBase;
        File file = new File(host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), host.getAppBase());
        }
        try {
            appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            appBase = file;
        }
        return appBase;
    }

    protected File getDocBase(StandardContext context, File appBase) {
        File docBase;
        File file = new File(context.getDocBase());
        if (!file.isAbsolute()) {
            file = new File(appBase, context.getDocBase());
        }
        try {
            docBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            docBase = file;
        }
        return docBase;
    }

    protected String getDefaultWorkDir(StandardContext context) {
        String defaultWorkDir = null;
        String contextPath = context.getPath().length() == 0 ? "_" : context.getPath().substring(1);
        Container host = context.getParent();
        if (host instanceof StandardHost) {
            String hostWorkDir = ((StandardHost)host).getWorkDir();
            if (hostWorkDir != null) {
                defaultWorkDir = hostWorkDir + File.separator + contextPath;
            } else {
                String engineName = context.getParent().getParent().getName();
                String hostName = context.getParent().getName();
                defaultWorkDir = "work" + File.separator + engineName + File.separator + hostName + File.separator + contextPath;
            }
        }
        return defaultWorkDir;
    }

    public Object defaultInstance(Object bean) throws InstantiationException, IllegalAccessException {
        if (bean instanceof StandardContext) {
            StandardContext defaultContext = new StandardContext();
            return defaultContext;
        }
        return super.defaultInstance(bean);
    }
}

