/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.jira;

import bucket.cache.CacheManager;
import bucket.container.ContainerManager;
import bucket.util.FileUtils;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.renderer.radeox.macros.include.AbstractHttpRetrievalMacro;
import com.atlassian.confluence.security.GateKeeper;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.JiraIconMappingManager;
import com.atlassian.confluence.util.io.IOUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.user.User;
import com.atlassian.user.impl.cache.Cache;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Category;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.xpath.XPath;
import org.radeox.api.engine.context.InitialRenderContext;
import org.radeox.macro.parameter.MacroParameter;

public class JiraIssuesMacro
extends AbstractHttpRetrievalMacro {
    private Category log = Category.getInstance(((Object)((Object)this)).getClass());
    private static final String MACRO_REFRESH = "macro.refresh";
    private String[] myParamDescription = new String[]{"1: url", "?2: columns"};
    private List defaultColumns = new LinkedList();
    private CacheManager cacheManager;
    private BootstrapManager bootstrapManager;
    private GateKeeper gateKeeper;
    static /* synthetic */ Class class$com$atlassian$confluence$extra$jira$JiraIssuesMacro;

    public void setInitialContext(InitialRenderContext initialRenderContext) {
        super.setInitialContext(initialRenderContext);
        this.defaultColumns.clear();
        this.defaultColumns.add("type");
        this.defaultColumns.add("key");
        this.defaultColumns.add("summary");
        this.defaultColumns.add("assignee");
        this.defaultColumns.add("reporter");
        this.defaultColumns.add("priority");
        this.defaultColumns.add("status");
        this.defaultColumns.add("resolution");
        this.defaultColumns.add("created");
        this.defaultColumns.add("updated");
        this.defaultColumns.add("due");
    }

    public String getName() {
        return "jiraissues";
    }

    public String[] getParamDescription() {
        return this.myParamDescription;
    }

    public String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        boolean bl;
        String string = TextUtils.noNull((String)macroParameter.get("url", 0)).trim();
        string = this.cleanUrlParentheses(string);
        String string2 = TextUtils.noNull((String)macroParameter.get("columns", 1)).trim();
        String string3 = TextUtils.noNull((String)macroParameter.get("count")).trim();
        String string4 = TextUtils.noNull((String)macroParameter.get("cache", 2)).trim();
        if (string4.equals("")) {
            string4 = "true";
        }
        boolean bl2 = bl = Boolean.valueOf(string4) == false;
        if (!bl) {
            bl = this.flushCacheParameterSet();
        }
        String string5 = this.getRefreshUrl();
        Map map = MacroUtils.defaultVelocityContext();
        Element element = this.fetchChannel(string, bl);
        if (element == null) {
            return "error";
        }
        String string6 = this.makeClickableUrl(string);
        if (TextUtils.stringSet((String)macroParameter.get("baseurl"))) {
            string6 = this.rebaseUrl(string6, macroParameter.get("baseurl").trim());
        }
        if ("true".equals(string3)) {
            return this.countHtml(string6, element);
        }
        map.put("url", string);
        map.put("clickableUrl", string6);
        map.put("channel", element);
        map.put("entries", element.getChildren("item"));
        map.put("columns", this.prepareDisplayColumns(string2));
        map.put("icons", this.prepareIconMap(element));
        map.put("refreshUrl", string5);
        return VelocityUtils.getRenderedTemplate((String)"templates/extra/jira/jiraissues.vm", (Map)map);
    }

    public String rebaseUrl(String string, String string2) {
        return string.replaceFirst("^.*?://[^/]+", string2);
    }

    private String countHtml(String string, Element element) {
        return "<a href=\"" + string + "\">" + element.getChildren("item").size() + " issues</a>";
    }

    private String makeClickableUrl(String string) {
        int n;
        int n2;
        String string2 = string;
        if (string2.indexOf("view=rss") > 0) {
            string2 = string2.replaceAll("view=rss", "");
        }
        if (string2.indexOf("decorator=none") > 0) {
            string2 = string2.replaceAll("decorator=none", "");
        }
        if ((n2 = string2.indexOf("&os_username=")) > 0) {
            n = string2.indexOf(38, n2 + 1);
            string2 = n > 0 ? string2.substring(0, n2) + string2.substring(n) : string2.substring(0, n2);
        }
        if ((n = string2.indexOf("&os_password=")) > 0) {
            int n3 = string2.indexOf(38, n + 1);
            string2 = n3 > 0 ? string2.substring(0, n) + string2.substring(n3) : string2.substring(0, n);
        }
        return string2;
    }

    private List prepareDisplayColumns(String string) {
        if (string == null || string.equals("")) {
            return this.defaultColumns;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase().trim();
            if (!this.defaultColumns.contains(string2) || linkedList.contains(string2)) continue;
            linkedList.add(string2);
        }
        if (linkedList.isEmpty()) {
            return this.defaultColumns;
        }
        return linkedList;
    }

    private Map prepareIconMap(Element element) {
        String string = element.getChild("link").getValue().toString() + "/images/icons/";
        HashMap hashMap = new HashMap();
        JiraIconMappingManager jiraIconMappingManager = (JiraIconMappingManager)ContainerManager.getComponent((String)"jiraIconMappingManager");
        Iterator iterator = jiraIconMappingManager.getIconMappings().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string2 = (String)entry.getValue();
            if (string2.startsWith("http://") || string2.startsWith("https://")) {
                hashMap.put(entry.getKey(), string2);
                continue;
            }
            hashMap.put(GeneralUtil.escapeXml((String)((String)entry.getKey())), string + string2);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Element fetchChannel(String string, boolean bl) throws IOException {
        Element element;
        Object object;
        Cache cache = this.cacheManager.getCache((class$com$atlassian$confluence$extra$jira$JiraIssuesMacro == null ? (class$com$atlassian$confluence$extra$jira$JiraIssuesMacro = JiraIssuesMacro.class$("com.atlassian.confluence.extra.jira.JiraIssuesMacro")) : class$com$atlassian$confluence$extra$jira$JiraIssuesMacro).getName());
        if (bl) {
            try {
                cache.remove((Object)string);
            }
            catch (Exception exception) {
                this.log.error((Object)("There was an error removing the JIRA Issues url (" + string + ") from the cache:"), (Throwable)exception);
            }
        }
        if ((object = cache.get((Object)string)) != null) {
            byte[] byArray = (byte[])object;
            element = this.getChannelElement(byArray, string);
            this.log.debug((Object)("XML Document feed " + string + " fetched from local cache!"));
            return element;
        }
        this.log.debug((Object)("Fetching XML feed " + string + " ..."));
        HttpMethod httpMethod = null;
        InputStream inputStream = null;
        try {
            int n;
            httpMethod = this.retrieveRemoteUrl(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            inputStream = httpMethod.getResponseBodyAsStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            element = this.getChannelElement(byArray2, string);
            cache.put((Object)string, (Object)byArray2);
            Object var13_14 = null;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            IOUtils.close(inputStream);
            if (httpMethod == null) throw throwable;
            try {
                httpMethod.releaseConnection();
                throw throwable;
            }
            catch (Throwable throwable2) {
                this.log.error((Object)"Error calling HttpMethod.releaseConnection", throwable2);
            }
            throw throwable;
        }
        IOUtils.close((InputStream)inputStream);
        if (httpMethod == null) return element;
        try {}
        catch (Throwable throwable) {
            this.log.error((Object)"Error calling HttpMethod.releaseConnection", throwable);
            return element;
        }
        httpMethod.releaseConnection();
        return element;
    }

    private Element getChannelElement(byte[] byArray, String string) throws IOException {
        Element element;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            SAXBuilder sAXBuilder = new SAXBuilder("org.apache.xerces.parsers.SAXParser");
            Document document = sAXBuilder.build((InputStream)byteArrayInputStream);
            element = (Element)XPath.selectSingleNode((Object)document, (String)"/rss//channel");
        }
        catch (JDOMException jDOMException) {
            try {
                String string2 = "rssoutput" + string.hashCode() + ".txt";
                File file = new File(this.bootstrapManager.getFilePathProperty("webwork.multipart.saveDir"), string2);
                FileUtils.copyFile((InputStream)new ByteArrayInputStream(byArray), (File)file);
                String string3 = "/download/temp/" + string2;
                User user = this.getRemoteUser();
                if (user != null) {
                    this.gateKeeper.addKey(string3, user);
                } else {
                    this.log.error((Object)"Could not reference remoteUser when trying to store results of RSS failure in temp dir.");
                }
                this.log.error((Object)"Error while trying to assemble the RSS result!", (Throwable)jDOMException);
                throw new IOException(jDOMException.getMessage() + " <a href='" + this.bootstrapManager.getWebAppContextPath() + "/download/temp/" + string2 + "'>" + string2 + "</a>");
            }
            catch (Throwable throwable) {
                IOUtils.close(byteArrayInputStream);
                throw throwable;
            }
        }
        IOUtils.close((InputStream)byteArrayInputStream);
        return element;
    }

    protected String getRefreshUrl() {
        HttpServletRequest httpServletRequest = ServletActionContext.getRequest();
        if (httpServletRequest != null) {
            StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getRequestURI());
            String string = httpServletRequest.getQueryString();
            if (TextUtils.stringSet((String)string)) {
                stringBuffer.append("?").append(string);
                if (httpServletRequest.getParameter(MACRO_REFRESH) == null) {
                    stringBuffer.append("&").append(MACRO_REFRESH).append("=true");
                }
            } else {
                stringBuffer.append("?").append(MACRO_REFRESH).append("=true");
            }
            return stringBuffer.toString();
        }
        return null;
    }

    protected boolean flushCacheParameterSet() {
        String string;
        HttpServletRequest httpServletRequest = ServletActionContext.getRequest();
        return httpServletRequest != null && (string = httpServletRequest.getParameter(MACRO_REFRESH)) != null;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setGateKeeper(GateKeeper gateKeeper) {
        this.gateKeeper = gateKeeper;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

