/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.util.migration;

import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class TransferUtils {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$util$migration$TransferUtils == null ? (class$com$atlassian$user$util$migration$TransferUtils = TransferUtils.class$("com.atlassian.user.util.migration.TransferUtils")) : class$com$atlassian$user$util$migration$TransferUtils));
    static /* synthetic */ Class class$com$atlassian$user$util$migration$TransferUtils;

    public static void copyUser(User fromUser, User toUser) {
        toUser.setEmail(fromUser.getEmail());
        toUser.setFullName(fromUser.getFullName());
    }

    public static void copyPropertySet(PropertySet fromPropertySet, PropertySet toPropertySet) {
        Collection fromKeys = fromPropertySet.getKeys();
        Iterator fromKeyIterator = fromKeys.iterator();
        while (fromKeyIterator.hasNext()) {
            String key = (String)fromKeyIterator.next();
            Object val = fromPropertySet.getAsActualType(key);
            try {
                if (!(val instanceof Timestamp) && val != null) {
                    log.info((Object)("copying key [" + key + "] with value [" + val.toString() + "]"));
                    toPropertySet.setAsActualType(key, val);
                    continue;
                }
                if (val == null) {
                    log.info((Object)("ignoring null data for key - " + key));
                    continue;
                }
                long milliseconds = 0L;
                Date date = null;
                if (val instanceof Timestamp) {
                    milliseconds = ((Timestamp)val).getTime();
                    date = new Date(milliseconds);
                }
                if (date == null) continue;
                toPropertySet.setDate(key, date);
            }
            catch (PropertyException e) {
                System.out.println("It's borking on ... " + key);
                e.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

