/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.PasswordEncryptor;
import java.util.HashMap;

public class MemoryUserManager
implements UserManager {
    protected MemoryProvider provider;
    protected Repository repository;
    protected PasswordEncryptor passwordEncryptor;

    public MemoryUserManager() {
    }

    public MemoryUserManager(Repository repository, MemoryProvider provider, PasswordEncryptor passwordEncryptor) {
        this.provider = provider;
        this.repository = repository;
        this.passwordEncryptor = passwordEncryptor;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.provider = (MemoryProvider)args.get("provider");
        this.repository = (Repository)args.get("repository");
        this.passwordEncryptor = (PasswordEncryptor)args.get("passwordEncryptor");
        InitializationCheck.validateArgs(args, new String[]{"repository", "passwordEncryptor", "provider"}, this);
    }

    public Pager getUsers() {
        return this.provider.getUsers();
    }

    public Pager getUserNames() throws EntityException {
        return this.provider.getUserNames();
    }

    public User getUser(String username) {
        return this.provider.getUser(username);
    }

    public User createUser(String username) throws EntityException {
        if (this.provider.getUser(username) != null) {
            throw new DuplicateEntityException("User already exists: [" + username + "] in" + this.getRepository(this.getUser(username)));
        }
        DefaultUser user = new DefaultUser(username);
        this.provider.addUser(user);
        return user;
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        user.setPassword(this.passwordEncryptor.encrypt(plainTextPass));
    }

    public void removeUser(User user) throws EntityException {
        this.provider.removeUser(user);
    }

    public boolean isReadOnly(User user) {
        return this.getUser(user.getName()) == null;
    }

    public PasswordEncryptor getPasswordEncryptor(User user) throws EntityException {
        return this.passwordEncryptor;
    }

    public boolean supportsExternalEntities() {
        return true;
    }

    public void saveUser(User user) throws EntityException {
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }
}

