/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.security.authentication;

import com.atlassian.user.EntityException;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import org.apache.log4j.Logger;

public class DefaultLDAPAuthenticator
implements Authenticator {
    public static final SearchControls DEFAULT_SEARCH_CONTROLS = new SearchControls();
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator == null ? (class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator = DefaultLDAPAuthenticator.class$("com.atlassian.user.impl.ldap.security.authentication.DefaultLDAPAuthenticator")) : class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator));
    private LDAPRepository repository;
    private LDAPUserAdaptor userAdaptor;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$security$authentication$DefaultLDAPAuthenticator;

    public DefaultLDAPAuthenticator() {
    }

    public DefaultLDAPAuthenticator(LDAPRepository repository) {
        this.repository = repository;
        this.userAdaptor = new DefaultLDAPUserAdaptor(repository);
        DEFAULT_SEARCH_CONTROLS.setReturningAttributes(new String[0]);
        DEFAULT_SEARCH_CONTROLS.setSearchScope(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean authenticate(String username, String password) throws EntityException {
        block18: {
            if (password == null || password.equals("")) {
                return false;
            }
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.push((String)(this.getClass().getName() + "_authenticate__" + username));
            }
            userDN = null;
            ctx = null;
            defaultEnv = null;
            userDN = this.userAdaptor.getUserDN(username);
            defaultEnv = this.repository.getJNDIEnv();
            defaultEnv.put("java.naming.security.principal", userDN);
            defaultEnv.put("java.naming.security.credentials", password);
            ctx = new InitialDirContext(defaultEnv);
            attrIDs = new String[]{this.repository.getUsernameAttribute()};
            ctls = new SearchControls();
            ctls.setReturningAttributes(attrIDs);
            ctls.setSearchScope(2);
            if (DefaultLDAPAuthenticator.log.isDebugEnabled()) {
                DefaultLDAPAuthenticator.log.debug((Object)("Doing initial search to complete authentication: username='" + username + "', base='" + this.repository.getBaseUserNamespace() + "'"));
            }
            ctx.search(this.repository.getBaseUserNamespace(), new EqualsFilter(this.repository.getUsernameAttribute(), username).encode(), ctls);
            var9_12 = null;
            ** if (ctx == null) goto lbl-1000
lbl-1000:
            // 1 sources

            {
                try {
                    ctx.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block18;
                catch (NamingException e) {
                    DefaultLDAPAuthenticator.log.error((Object)("Could not authenticate with LDAP. Please check your host ('" + defaultEnv.get("java.naming.provider.url") + "'), " + "bind DN ('" + defaultEnv.get("java.naming.security.principal") + "') or bind password are correct."));
                    var7_10 = false;
                    var9_13 = null;
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return var7_10;
                }
                catch (Throwable t) {
                    block20: {
                        try {
                            DefaultLDAPAuthenticator.log.error((Object)("Error occurred in LDAP authentication for username: " + username), t);
                            var7_11 = false;
                            var9_14 = null;
                            if (ctx == null) break block20;
                        }
                        catch (Throwable var8_20) {
                            var9_15 = null;
                            if (ctx != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            throw var8_20;
                        }
                        try {
                            ctx.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    return var7_11;
                }
            }
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_authenticate__" + username));
        }
        return true;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        this.userAdaptor = new DefaultLDAPUserAdaptor(this.repository);
        DEFAULT_SEARCH_CONTROLS.setReturningAttributes(new String[0]);
        DEFAULT_SEARCH_CONTROLS.setSearchScope(0);
        InitializationCheck.validateArgs(args, new String[]{"repository"}, this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

