/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search.query;

import com.atlassian.user.EntityException;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.LiteralFilter;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.impl.ldap.search.page.LDAPEntityPager;
import com.atlassian.user.search.DefaultSearchResult;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.query.BooleanQuery;
import com.atlassian.user.search.query.EmailTermQuery;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.search.query.FullNameTermQuery;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.GroupsOfUserTwoTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.QueryContext;
import com.atlassian.user.search.query.TermQuery;
import com.atlassian.user.search.query.UserNameTermQuery;
import com.atlassian.user.search.query.UsersInGroupTwoTermQuery;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import java.util.Iterator;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import net.sf.ldaptemplate.support.LdapEncoder;

public class LDAPEntityQueryParser
implements EntityQueryParser {
    public static final String OPEN_PARAN = "(";
    public static final String CLOSE_PARAN = ")";
    public static final String EQ = "=";
    public static final String AND = "&";
    public static final String OR = "|";
    public static final String WILDCARD = "*";
    private LDAPRepository repository;
    private LDAPUserAdaptor userAdaptor;
    private LDAPGroupAdaptor groupAdaptor;
    private LDAPGroupFactory groupFactory;
    private LDAPUserFactory userFactory;

    public LDAPEntityQueryParser() {
    }

    public LDAPEntityQueryParser(LDAPRepository repository, LDAPGroupAdaptor groupAdaptor, LDAPUserFactory userFactory) {
        this.repository = repository;
        this.groupAdaptor = groupAdaptor;
        this.userFactory = userFactory;
        this.userAdaptor = new DefaultLDAPUserAdaptor(this.repository);
        this.groupFactory = new DefaultLDAPGroupFactory(this.repository);
    }

    public void init(HashMap args) {
        this.repository = (LDAPRepository)args.get("repository");
        this.groupAdaptor = (LDAPGroupAdaptor)args.get("groupAdaptor");
        this.userFactory = (LDAPUserFactory)args.get("userFactory");
        this.userAdaptor = new DefaultLDAPUserAdaptor(this.repository);
        this.groupFactory = new DefaultLDAPGroupFactory(this.repository);
    }

    public SearchResult findUsers(Query query) throws EntityException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_findUsers"));
        }
        String parsedQuery = null;
        LDAPEntityPager iter = null;
        parsedQuery = this.directQuery(query, parsedQuery);
        LDAPPagerInfo info = this.userAdaptor.search(new LiteralFilter(parsedQuery));
        iter = new LDAPEntityPager(this.repository, this.userFactory, info);
        DefaultSearchResult searchResult = new DefaultSearchResult(iter, this.repository.getKey());
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_findUsers"));
        }
        return searchResult;
    }

    public SearchResult findGroups(Query query) throws EntityException {
        String parsedQuery = null;
        LDAPEntityPager pager = null;
        parsedQuery = this.directQuery(query, parsedQuery);
        LDAPPagerInfo info = this.groupAdaptor.search(new LiteralFilter(parsedQuery));
        pager = new LDAPEntityPager(this.repository, this.groupFactory, info);
        DefaultSearchResult searchResult = new DefaultSearchResult(pager, this.repository.getKey());
        return searchResult;
    }

    public SearchResult findUsers(Query query, QueryContext context) throws EntityException {
        SearchResult result = null;
        if (context.getRepositoryKeys().contains(this.repository.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            result = this.findUsers(query);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    public SearchResult findGroups(Query query, QueryContext context) throws EntityException {
        SearchResult result = null;
        if (context.getRepositoryKeys().contains(this.repository.getKey()) || context.getRepositoryKeys().contains("_all_repositories_")) {
            result = this.findGroups(query);
        }
        if (result == null) {
            return null;
        }
        return result;
    }

    private String directQuery(Query query, String parsedQuery) throws EntityException {
        if (query instanceof TermQuery) {
            StringBuffer parsedQueryStringBuffer = this.parseQuery((TermQuery)query);
            parsedQuery = parsedQueryStringBuffer.toString();
        } else if (query instanceof BooleanQuery) {
            parsedQuery = this.parseQuery((BooleanQuery)query).toString();
        }
        return parsedQuery;
    }

    public StringBuffer parseQuery(BooleanQuery query) throws EntityException {
        StringBuffer parsedClause = new StringBuffer();
        parsedClause.append(OPEN_PARAN);
        if (query.isAND()) {
            parsedClause.append(AND);
        } else {
            parsedClause.append(OR);
        }
        Iterator queryIter = query.getQueries().iterator();
        while (queryIter.hasNext()) {
            Query foundQuery = (Query)queryIter.next();
            if (foundQuery instanceof BooleanQuery) {
                parsedClause.append(this.parseQuery((BooleanQuery)foundQuery));
                continue;
            }
            parsedClause.append(this.parseQuery((TermQuery)foundQuery));
        }
        parsedClause.append(CLOSE_PARAN);
        return parsedClause;
    }

    public StringBuffer parseQuery(TermQuery q) throws EntityException {
        StringBuffer parsedQuery = null;
        if (q instanceof UserNameTermQuery) {
            parsedQuery = this.parseTermQuery(q, this.repository.getUsernameAttribute());
        } else if (q instanceof GroupNameTermQuery) {
            parsedQuery = this.parseTermQuery(q, this.repository.getGroupnameAttribute());
        } else if (q instanceof EmailTermQuery) {
            parsedQuery = this.parseTermQuery(q, this.repository.getEmailAttribute());
        } else if (q instanceof FullNameTermQuery) {
            parsedQuery = this.parseFullNameTermQuery(q);
        } else if (q instanceof UsersInGroupTwoTermQuery) {
            parsedQuery = this.parseMemberNamesInGroupTermQuery((UsersInGroupTwoTermQuery)((Object)q));
        } else if (q instanceof GroupsOfUserTwoTermQuery) {
            parsedQuery = this.parseGroupsOfUserTwoTermQuery((GroupsOfUserTwoTermQuery)((Object)q));
        }
        return parsedQuery;
    }

    private StringBuffer parseFullNameTermQuery(TermQuery q) {
        StringBuffer query = new StringBuffer();
        query.insert(0, OR);
        query.insert(0, OPEN_PARAN);
        query.append(this.parseTermQuery(q, this.repository.getFirstnameAttribute()));
        query.append(this.parseTermQuery(q, this.repository.getSurnameAttribute()));
        query.append(CLOSE_PARAN);
        return query;
    }

    private StringBuffer parseMemberNamesInGroupTermQuery(UsersInGroupTwoTermQuery q) throws EntityException {
        StringBuffer parsedQuery = null;
        parsedQuery = this.repository.hasStaticGroupStructure() ? this.buildMemberQueryForStaticGroup(q) : this.buildMemberQueryForDynamicGroup(q);
        return parsedQuery;
    }

    private StringBuffer parseGroupsOfUserTwoTermQuery(GroupsOfUserTwoTermQuery q) throws EntityException {
        String userPattern = null;
        UserNameTermQuery uQuery = q.getUserNameTermQuery();
        GroupNameTermQuery gQuery = q.getGroupNameTermQuery();
        if (uQuery.isMatchingSubstring()) {
            if (uQuery.getMatchingRule().equals("starts_with")) {
                userPattern = uQuery.getTerm() + WILDCARD;
            } else if (uQuery.getMatchingRule().equals("ends_with")) {
                userPattern = WILDCARD + uQuery.getTerm();
            } else if (uQuery.getMatchingRule().equals("contains")) {
                userPattern = WILDCARD + uQuery.getTerm() + WILDCARD;
            }
        } else {
            userPattern = uQuery.getTerm();
        }
        LDAPPagerInfo pagerInfo = this.groupAdaptor.getGroupEntriesViaMembership(userPattern);
        StringBuffer groupQuery = null;
        groupQuery = this.repository.hasStaticGroupStructure() ? this.buildQueryForUsersInStaticGroups(pagerInfo.getNamingEnumeration()) : this.buildQueryForUsersInDynamicGroups(pagerInfo.getNamingEnumeration());
        return groupQuery;
    }

    private StringBuffer buildQueryForUsersInDynamicGroups(NamingEnumeration enume) throws EntityException {
        StringBuffer parsedQuery = null;
        while (enume.hasMoreElements()) {
            javax.naming.directory.SearchResult result = (javax.naming.directory.SearchResult)enume.nextElement();
            Attributes attrs = result.getAttributes();
            Attribute attr = null;
            attr = attrs.get(this.repository.getMembershipAttribute());
            if (attr == null) {
                return null;
            }
            try {
                NamingEnumeration<?> membershipEnume = attr.getAll();
                while (membershipEnume.hasMoreElements()) {
                    boolean wrapping = false;
                    if (parsedQuery == null) {
                        parsedQuery = new StringBuffer();
                    } else {
                        parsedQuery.insert(0, OR);
                        parsedQuery.insert(0, OPEN_PARAN);
                        wrapping = true;
                    }
                    parsedQuery.append(OPEN_PARAN);
                    parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                    parsedQuery.append(CLOSE_PARAN);
                    if (!wrapping) continue;
                    parsedQuery.append(CLOSE_PARAN);
                }
            }
            catch (Exception e) {
                throw new RepositoryException(e);
            }
        }
        return parsedQuery;
    }

    private StringBuffer buildQueryForUsersInStaticGroups(NamingEnumeration enume) throws EntityException {
        StringBuffer parsedQuery = null;
        while (enume.hasMoreElements()) {
            javax.naming.directory.SearchResult result = (javax.naming.directory.SearchResult)enume.nextElement();
            Attributes attrs = result.getAttributes();
            Attribute attr = attrs.get(this.repository.getGroupnameAttribute());
            if (attr == null) {
                return null;
            }
            try {
                NamingEnumeration<?> membershipEnume = attr.getAll();
                while (membershipEnume.hasMoreElements()) {
                    boolean wrapping = false;
                    if (parsedQuery == null) {
                        parsedQuery = new StringBuffer();
                    } else {
                        parsedQuery.insert(0, OR);
                        parsedQuery.insert(0, OPEN_PARAN);
                        wrapping = true;
                    }
                    parsedQuery.append(OPEN_PARAN);
                    parsedQuery.append(this.repository.getGroupnameAttribute());
                    parsedQuery.append(EQ);
                    parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                    parsedQuery.append(CLOSE_PARAN);
                    if (!wrapping) continue;
                    parsedQuery.append(CLOSE_PARAN);
                }
            }
            catch (Exception e) {
                throw new RepositoryException(e);
            }
        }
        return parsedQuery;
    }

    private StringBuffer buildMemberQueryForDynamicGroup(UsersInGroupTwoTermQuery q) throws EntityException {
        throw new UnsupportedOperationException();
    }

    private StringBuffer buildMemberQueryForStaticGroup(UsersInGroupTwoTermQuery q) throws EntityException {
        StringBuffer parsedQuery = null;
        String groupName = null;
        LDAPPagerInfo pagerInfo = this.groupAdaptor.getGroupEntries(groupName);
        NamingEnumeration enume = pagerInfo.getNamingEnumeration();
        parsedQuery = this.parseMembershipAttributesForGroupNames(enume);
        return parsedQuery;
    }

    private StringBuffer parseMembershipAttributesForGroupNames(NamingEnumeration enume) {
        StringBuffer parsedQuery = null;
        while (enume.hasMoreElements()) {
            javax.naming.directory.SearchResult result = (javax.naming.directory.SearchResult)enume.nextElement();
            Attributes attrs = result.getAttributes();
            Attribute attr = null;
            attr = this.repository.hasStaticGroupStructure() ? attrs.get(this.repository.getMembershipAttribute()) : attrs.get(this.repository.getGroupnameAttribute());
            try {
                if (parsedQuery == null) {
                    parsedQuery = this.parseMembershipAttributeForGroupNames(attr);
                    continue;
                }
                parsedQuery.insert(0, "(|");
                parsedQuery = parsedQuery.append(this.parseMembershipAttributeForGroupNames(attr));
                parsedQuery.append(CLOSE_PARAN);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return parsedQuery;
    }

    private StringBuffer parseMembershipAttributeForGroupNames(Attribute attr) throws NamingException {
        if (attr == null) {
            return null;
        }
        StringBuffer parsedQuery = null;
        NamingEnumeration<?> membershipEnume = attr.getAll();
        while (membershipEnume.hasMoreElements()) {
            boolean wrapping = false;
            if (parsedQuery == null) {
                parsedQuery = new StringBuffer();
            } else {
                parsedQuery.insert(0, OR);
                parsedQuery.insert(0, OPEN_PARAN);
                wrapping = true;
            }
            if (this.repository.hasStaticGroupStructure()) {
                parsedQuery.append(OPEN_PARAN);
                parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                parsedQuery.append(CLOSE_PARAN);
            } else {
                parsedQuery.append(OPEN_PARAN);
                parsedQuery.append(this.repository.getGroupnameAttribute());
                parsedQuery.append(EQ);
                parsedQuery.append(((String)membershipEnume.nextElement()).split(",")[0]);
                parsedQuery.append(CLOSE_PARAN);
            }
            if (!wrapping) continue;
            parsedQuery.append(CLOSE_PARAN);
        }
        return parsedQuery;
    }

    private StringBuffer parseTermQuery(TermQuery q, String attributeType) {
        StringBuffer parsedQuery = new StringBuffer();
        parsedQuery.append(OPEN_PARAN);
        parsedQuery.append(attributeType);
        parsedQuery.append(EQ);
        if (q.isMatchingSubstring() && (q.getMatchingRule().equals("ends_with") || q.getMatchingRule().equals("contains"))) {
            parsedQuery.append(WILDCARD);
        }
        parsedQuery.append(LdapEncoder.filterEncode((String)q.getTerm()));
        if (q.isMatchingSubstring() && (q.getMatchingRule().equals("starts_with") || q.getMatchingRule().equals("contains"))) {
            parsedQuery.append(WILDCARD);
        }
        parsedQuery.append(CLOSE_PARAN);
        return parsedQuery;
    }
}

