/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.search;

import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPEntity;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.LDAPPagerInfo;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.util.LDAPUtils;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.HashMap;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.sf.ldaptemplate.support.filter.EqualsFilter;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Logger;

public class DefaultLDAPUserAdaptor
implements LDAPUserAdaptor {
    private static final Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor == null ? (class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor = DefaultLDAPUserAdaptor.class$("com.atlassian.user.impl.ldap.search.DefaultLDAPUserAdaptor")) : class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor));
    private LDAPRepository repository;
    private String[] defaultAttributesToReturn = null;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$search$DefaultLDAPUserAdaptor;

    public DefaultLDAPUserAdaptor() {
    }

    public DefaultLDAPUserAdaptor(LDAPRepository repository) {
        this.repository = repository;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.repository = (LDAPRepository)args.get("repository");
        InitializationCheck.validateArgs(args, new String[]{"repository"}, this);
    }

    private String[] getDefaultAttributes() {
        if (this.defaultAttributesToReturn != null) {
            return this.defaultAttributesToReturn;
        }
        this.defaultAttributesToReturn = this.defaultAttributesToReturn == null && this.repository.getPasswordAttribute() != null ? new String[5] : new String[4];
        this.defaultAttributesToReturn[0] = this.repository.getUsernameAttribute();
        this.defaultAttributesToReturn[1] = this.repository.getFirstnameAttribute();
        this.defaultAttributesToReturn[2] = this.repository.getSurnameAttribute();
        this.defaultAttributesToReturn[3] = this.repository.getEmailAttribute();
        if (this.repository.getPasswordAttribute() != null) {
            this.defaultAttributesToReturn[4] = this.repository.getPasswordAttribute();
        }
        return this.defaultAttributesToReturn;
    }

    public LDAPPagerInfo search(Filter searchFilter) throws RepositoryException {
        return this.search(searchFilter, this.getDefaultAttributes());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LDAPPagerInfo search(Filter searchFilter, String[] attributesToReturnFromSearch) throws RepositoryException {
        DirContext ctx = null;
        SearchControls ctls = this.repository.getUserSearchControls(attributesToReturnFromSearch);
        NamingEnumeration<SearchResult> userSearchEnume = null;
        searchFilter = searchFilter != null ? LDAPUtils.makeAndFilter(this.repository.getUserSearchFilter(), searchFilter) : this.repository.getUserSearchFilter();
        try {
            try {
                ctx = this.repository.getLDAPContext();
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.push((String)(this.getClass().getName() + "_search_JNDI_RAW_" + searchFilter));
                }
                userSearchEnume = ctx.search(this.repository.getBaseUserNamespace(), searchFilter.encode(), ctls);
                if (UtilTimerStack.isActive()) {
                    UtilTimerStack.pop((String)(this.getClass().getName() + "_search_JNDI_RAW_" + searchFilter));
                }
            }
            catch (NamingException e) {
                e.printStackTrace();
                throw new RepositoryException(e);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (ctx == null) throw throwable;
                ctx.close();
                throw throwable;
            }
            catch (NamingException e) {
                log.error((Object)e.getMessage());
                throw new RepositoryException(e);
            }
        }
        try {}
        catch (NamingException e) {
            log.error((Object)e.getMessage());
            throw new RepositoryException(e);
        }
        if (ctx == null) return new LDAPPagerInfo(userSearchEnume, searchFilter, this.repository.getBaseUserNamespace(), this.repository.isUserSearchScopeAllDepths(), attributesToReturnFromSearch);
        ctx.close();
        return new LDAPPagerInfo(userSearchEnume, searchFilter, this.repository.getBaseUserNamespace(), this.repository.isUserSearchScopeAllDepths(), attributesToReturnFromSearch);
    }

    public LDAPPagerInfo getUserAttributes(String username, String[] specifiedAttributes) throws RepositoryException {
        EqualsFilter searchFilter = new EqualsFilter(this.repository.getUsernameAttribute(), username);
        return this.search(LDAPUtils.makeAndFilter(this.repository.getUserSearchFilter(), (Filter)searchFilter), specifiedAttributes);
    }

    public String getUserDN(User user) throws EntityException {
        if (user instanceof LDAPEntity) {
            LDAPEntity entity = (LDAPEntity)((Object)user);
            return entity.getDistinguishedName();
        }
        return this.getUserDN(user.getName());
    }

    public String getUserDN(String username) throws EntityException {
        LDAPPagerInfo ldapPagerInfo;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getUserDN(" + username + ")"));
        }
        if ((ldapPagerInfo = this.getUserAttributes(username, this.getDefaultAttributes())).getNamingEnumeration().hasMoreElements()) {
            SearchResult result = (SearchResult)ldapPagerInfo.getNamingEnumeration().nextElement();
            String userDN = result.getName();
            if (userDN.indexOf(this.repository.getBaseUserNamespace()) == -1) {
                userDN = userDN + "," + this.repository.getBaseUserNamespace();
            }
            try {
                ldapPagerInfo.getNamingEnumeration().close();
            }
            catch (NamingException e) {
                throw new EntityException(e);
            }
            if (UtilTimerStack.isActive()) {
                UtilTimerStack.pop((String)(this.getClass().getName() + "_getUserDN(" + username + ")"));
            }
            return userDN;
        }
        throw new RepositoryException("Could not locate a DN for user [" + username + "]");
    }

    public StringBuffer addSearchTermToFilter(StringBuffer firstTerm, String addedFilter) {
        firstTerm = firstTerm != null ? (addedFilter.indexOf("(") == 0 && addedFilter.lastIndexOf(")") == addedFilter.length() - 1 ? new StringBuffer("(&" + firstTerm + addedFilter + ")") : new StringBuffer("(&" + firstTerm + "(" + addedFilter + "))")) : new StringBuffer(addedFilter);
        return firstTerm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

