/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap.repository;

import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.LDAPGroupFactory;
import com.atlassian.user.impl.ldap.LDAPUserFactory;
import com.atlassian.user.impl.ldap.LiteralFilter;
import com.atlassian.user.impl.ldap.adaptor.LDAPGroupAdaptor;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import com.atlassian.user.impl.ldap.search.LDAPUserAdaptor;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.DefaultRepository;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.util.TextUtils;
import com.sun.jndi.ldap.LdapCtxFactory;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Logger;

public class DefaultLDAPRepository
extends DefaultRepository
implements LDAPRepository {
    private static final transient Logger log = Logger.getLogger((Class)(class$com$atlassian$user$impl$ldap$repository$DefaultLDAPRepository == null ? (class$com$atlassian$user$impl$ldap$repository$DefaultLDAPRepository = DefaultLDAPRepository.class$("com.atlassian.user.impl.ldap.repository.DefaultLDAPRepository")) : class$com$atlassian$user$impl$ldap$repository$DefaultLDAPRepository));
    public static final transient int UNINITIALISED_PORT = -1;
    transient int port = -1;
    protected transient Properties schemaMappingsProperties;
    protected transient Properties connectionProperties;
    protected transient Properties ldapConnectionPoolProperties;
    protected transient Hashtable env;
    protected transient Authenticator ldapAuthenticator;
    protected transient PropertySetFactory propertySetFactory;
    private transient Boolean userSearchAllDepths;
    private transient Boolean groupSearchAllDepths;
    protected transient LdapContext ctx;
    protected transient LDAPGroupAdaptor groupAdaptor;
    protected transient LDAPUserAdaptor userAdaptor;
    protected transient LDAPGroupFactory ldapGroupFactory;
    protected transient LDAPUserFactory ldapUserFactory;
    protected transient String batchSize;
    protected transient String providerURL;
    protected transient Boolean poolingOn;
    public transient LdapCtxFactory ctxFactory;
    public Integer ttl;
    static /* synthetic */ Class class$com$atlassian$user$impl$ldap$repository$DefaultLDAPRepository;

    public DefaultLDAPRepository() {
    }

    public DefaultLDAPRepository(Properties systemProperties) {
        this.ldapConnectionPoolProperties = systemProperties;
        if (systemProperties != null) {
            Enumeration<?> enume = systemProperties.propertyNames();
            while (enume.hasMoreElements()) {
                String keyx = (String)enume.nextElement();
                String value = (String)systemProperties.get(keyx);
                System.setProperty(keyx, value);
            }
        }
    }

    private void init() {
        this.env = new Hashtable();
        if (this.getProviderURL() == null) {
            log.fatal((Object)"There is no providerURL specified in the connection properties. The LDAP configuration will be not be able to gain a connection to the nominated system.");
        } else {
            this.env.put("java.naming.provider.url", this.getProviderURL());
        }
        if (this.getJNDIInitialContextFactoryIdentifier() == null) {
            log.fatal((Object)"There is no initialContextFactory specified in the connection properties. The LDAP configuration will not be able to build a context to use with the nominated system.");
        } else {
            this.env.put("java.naming.factory.initial", this.getJNDIInitialContextFactoryIdentifier());
        }
        if (this.getSecurityAuthentication() == null) {
            log.fatal((Object)"There is no securityAuthentication specified in the connection properties. This might be fine in some systems, others will require the authentication type to be specified.");
        } else {
            this.env.put("java.naming.security.authentication", this.getSecurityAuthentication());
        }
        if (this.getSecurityPrincipal() == null) {
            log.info((Object)"There is no securityPrincipal specified in the connection properties. This will probably result in a failed LDAP operation, unless anonymous users can administer the LDAP system.");
        } else {
            this.env.put("java.naming.security.principal", this.getSecurityPrincipal());
        }
        if (this.getSecurityCredential() == null) {
            log.info((Object)"There is no securityCredential specified in the connection properties. This will probably result in a failed LDAP operation, unless anonymous users can administer the LDAP system.");
        } else {
            this.env.put("java.naming.security.credentials", this.getSecurityCredential());
        }
        if (this.getSecurityProtocol() != null) {
            this.env.put("java.naming.security.protocol", this.getSecurityProtocol());
            log.info((Object)"Found security protocol instruction [securityProtocol].");
        }
        this.env.put("java.naming.batchsize", this.getSearchBatchSize() + "");
        Enumeration<?> enume = this.connectionProperties.propertyNames();
        while (enume.hasMoreElements()) {
            Object keyx = enume.nextElement();
            Object value = this.connectionProperties.get(keyx);
            if (this.env.contains(value)) continue;
            this.env.put(keyx, value);
        }
        if (this.isPoolingOn()) {
            this.env.put("com.sun.jndi.ldap.connect.pool", "true");
        }
        if (this.ttl == null) {
            this.getTimeToLive();
        }
    }

    public Hashtable getJNDIEnv() {
        if (this.env == null) {
            this.init();
        }
        return new Hashtable(this.env);
    }

    public int getPort() {
        if (this.port != -1) {
            return this.port;
        }
        String configPort = this.connectionProperties.getProperty("port", "389");
        int portInt = 0;
        try {
            portInt = Integer.parseInt(configPort);
        }
        catch (NumberFormatException e) {
            log.fatal((Object)"Could not find a valid integer in the port mapping: ", (Throwable)e);
        }
        return portInt;
    }

    public String getHost() {
        return this.connectionProperties.getProperty("host");
    }

    public String getSecurityPrincipal() {
        return this.connectionProperties.getProperty("securityPrincipal");
    }

    public String getSecurityCredential() {
        return this.connectionProperties.getProperty("securityCredential");
    }

    public String getProviderURL() {
        boolean sslEnabled;
        boolean bl = sslEnabled = this.getSecurityProtocol() != null && this.getSecurityProtocol().toLowerCase().indexOf("ssl") != -1;
        if (this.providerURL == null && !sslEnabled) {
            this.providerURL = "ldap://" + this.getHost() + ":" + this.getPort();
        } else if (sslEnabled) {
            this.providerURL = "ldaps://" + this.getHost() + ":" + this.getPort();
        }
        log.debug((Object)"");
        return this.providerURL;
    }

    public String getJNDIInitialContextFactoryIdentifier() {
        return this.connectionProperties.getProperty("initialContextFactory");
    }

    public String getSearchBatchSize() {
        if (this.batchSize == null) {
            this.batchSize = String.valueOf(1000);
            String customBatchSize = this.connectionProperties.getProperty("batchSize");
            if (TextUtils.stringSet((String)customBatchSize)) {
                try {
                    Integer.parseInt(customBatchSize);
                    this.batchSize = customBatchSize;
                }
                catch (NumberFormatException e) {
                    log.debug((Object)"Using default batch size: 1000");
                }
            }
        }
        return this.batchSize;
    }

    public String getSecurityAuthentication() {
        return this.connectionProperties.getProperty("securityAuthentication");
    }

    public String getSecurityProtocol() {
        return this.connectionProperties.getProperty("securityProtocol");
    }

    public String getBaseUserNamespace() {
        return this.schemaMappingsProperties.getProperty("baseUserNamespace");
    }

    public String getBaseGroupNamespace() {
        return this.schemaMappingsProperties.getProperty("baseGroupNamespace");
    }

    public String getUsernameAttribute() {
        return this.schemaMappingsProperties.getProperty("usernameAttribute");
    }

    public String getGroupnameAttribute() {
        return this.schemaMappingsProperties.getProperty("groupnameAttribute");
    }

    public String getFirstnameAttribute() {
        return this.schemaMappingsProperties.getProperty("firstnameAttribute");
    }

    public String getSurnameAttribute() {
        return this.schemaMappingsProperties.getProperty("surnameAttribute");
    }

    public String getEmailAttribute() {
        return this.schemaMappingsProperties.getProperty("emailAttribute");
    }

    public String getMembershipAttribute() {
        return this.schemaMappingsProperties.getProperty("membershipAttribute");
    }

    public boolean isUserSearchScopeAllDepths() {
        if (this.userSearchAllDepths == null) {
            this.userSearchAllDepths = new Boolean(this.schemaMappingsProperties.getProperty("userSearchAllDepths"));
        }
        return this.userSearchAllDepths;
    }

    public boolean isGroupSearchScopeAllDepths() {
        if (this.groupSearchAllDepths == null) {
            this.groupSearchAllDepths = new Boolean(this.schemaMappingsProperties.getProperty("groupSearchAllDepths"));
        }
        return this.groupSearchAllDepths;
    }

    public Filter getGroupSearchFilter() {
        return new LiteralFilter(this.schemaMappingsProperties.getProperty("groupSearchFilter"));
    }

    public String getPasswordAttribute() {
        return this.schemaMappingsProperties.getProperty("passwordAttribute");
    }

    public Filter getUserSearchFilter() {
        return new LiteralFilter(this.schemaMappingsProperties.getProperty("userSearchFilter"));
    }

    public boolean hasStaticGroupStructure() {
        String staticGroups = this.schemaMappingsProperties.getProperty("staticGroups");
        return Boolean.valueOf(staticGroups);
    }

    public boolean useUnqualifiedUsernameForMembershipComparison() {
        String staticGroups = this.schemaMappingsProperties.getProperty("useUnqualifiedUsernameForMembershipComparison");
        return Boolean.valueOf(staticGroups);
    }

    public DirContext getLDAPContext() throws RepositoryException {
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(this.getClass().getName() + "_getLDAPContext"));
        }
        InitialDirContext dirContext = null;
        try {
            dirContext = new InitialDirContext(this.getJNDIEnv());
        }
        catch (NamingException e) {
            throw new RepositoryException(e);
        }
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(this.getClass().getName() + "_getLDAPContext"));
        }
        return dirContext;
    }

    protected InitialContextFactory getCtxFactory() {
        if (this.ctxFactory == null) {
            this.ctxFactory = new LdapCtxFactory();
        }
        return this.ctxFactory;
    }

    public void setCtx(LdapContext ctx) {
        this.ctx = ctx;
    }

    public void setSchemaMappingsProperties(Properties schemaMappings) {
        this.schemaMappingsProperties = schemaMappings;
    }

    public void setConnectionProperties(Properties connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public void setJNDIEnv(Hashtable env) {
        this.env = env;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Properties getSchemaMappingsProperties() {
        return this.schemaMappingsProperties;
    }

    public Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    public Properties getSystemProperties() {
        return this.ldapConnectionPoolProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.ldapConnectionPoolProperties = systemProperties;
    }

    public boolean isPoolingOn() {
        if (this.poolingOn == null) {
            this.poolingOn = Boolean.valueOf((String)this.ldapConnectionPoolProperties.get("poolingOn"));
        }
        return this.poolingOn;
    }

    public int getTimeToLive() {
        if (this.ttl == null) {
            String ttlString = (String)this.connectionProperties.get("timeToLive");
            if (ttlString != null) {
                try {
                    this.ttl = new Integer(ttlString);
                }
                catch (NumberFormatException e) {
                    log.error((Object)("Defaulting to 0 (infinite TTL): " + e.getMessage()));
                }
            } else {
                this.ttl = new Integer(0);
            }
        }
        return this.ttl;
    }

    public SearchControls getUserSearchControls(String[] attributesToReturn) {
        SearchControls ctls = new SearchControls();
        int searchScope = this.isUserSearchScopeAllDepths() ? 2 : 1;
        ctls.setSearchScope(searchScope);
        if (attributesToReturn != null) {
            ctls.setReturningAttributes(attributesToReturn);
        }
        ctls.setTimeLimit(this.getTimeToLive());
        return ctls;
    }

    public SearchControls getGroupSearchControls(String[] attributesToReturn) {
        SearchControls ctls = new SearchControls();
        int searchScope = this.isGroupSearchScopeAllDepths() ? 2 : 1;
        ctls.setSearchScope(searchScope);
        if (attributesToReturn != null) {
            ctls.setReturningAttributes(attributesToReturn);
        }
        ctls.setTimeLimit(this.getTimeToLive());
        return ctls;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.name = (String)args.get("name");
        this.description = (String)args.get("description");
        this.key = (String)args.get("key");
        this.schemaMappingsProperties = (Properties)args.get("schemaMappings");
        this.connectionProperties = (Properties)args.get("server");
        this.ldapConnectionPoolProperties = (Properties)args.get("connectionPool");
        InitializationCheck.validateArgs(args, new String[]{"key", "schemaMappings", "server", "connectionPool"}, this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

