/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.ldap;

import com.atlassian.user.User;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.impl.RepositoryException;
import com.atlassian.user.impl.ldap.DefaultLDAPUserFactory;
import com.atlassian.user.impl.ldap.repository.LDAPRepository;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

public class PasswordCarriedLDAPUserFactory
extends DefaultLDAPUserFactory {
    public PasswordCarriedLDAPUserFactory(LDAPRepository repository) {
        super(repository);
    }

    public User getUser(Attributes attrs) throws RepositoryException {
        DefaultUser user = null;
        try {
            Attribute passwordAttr;
            Attribute emailAttr;
            Attribute uidAttr = attrs.get(this.repository.getUsernameAttribute());
            user = new DefaultUser((String)uidAttr.get());
            if (uidAttr == null) {
                return null;
            }
            Attribute givenNameAttr = attrs.get(this.repository.getFirstnameAttribute());
            Attribute surNameAttr = attrs.get(this.repository.getSurnameAttribute());
            if (givenNameAttr != null) {
                String givenName = (String)givenNameAttr.get();
                String surName = "";
                if (surNameAttr != null) {
                    surName = (String)surNameAttr.get();
                }
                givenName = givenName.concat(" ");
                user.setFullName(givenName.concat(surName));
            }
            if ((emailAttr = attrs.get(this.repository.getEmailAttribute())) != null) {
                user.setEmail((String)emailAttr.get());
            }
            if ((passwordAttr = attrs.get(this.repository.getPasswordAttribute())) != null) {
                user.setPassword(new String((byte[])passwordAttr.get()));
            }
        }
        catch (NamingException e) {
            throw new RepositoryException(e);
        }
        return user;
    }
}

