/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate.configuration;

import com.atlassian.user.Caching;
import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.AbstractRepositoryProcessor;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.cache.properties.CachingPropertySetFactory;
import com.atlassian.user.impl.hibernate.ExternalEntityDAO;
import com.atlassian.user.impl.hibernate.configuration.HibernateAccessor;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.hibernate.HibernateConfigurationProvider;
import java.util.HashMap;
import net.sf.hibernate.SessionFactory;

public class DefaultHibernateRepositoryProcessor
extends AbstractRepositoryProcessor {
    public SessionFactory sessionFactory;
    public HibernateConfigurationProvider hibernateProvider;
    public HibernateAccessor accessor;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$configuration$HibernateAccessor;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$ExternalEntityDAO;

    public RepositoryAccessor process(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        processorData.put("sessionFactory", this.accessor.getSessionFactory());
        this.repository = this.configureRepository(processorData, processorClassNames);
        this.repositoryAccessor.setRepository(this.repository);
        this.externalEntityDAO = this.configureExternalEntityDAO(processorData, processorClassNames);
        this.passwordEncryptor = this.configurePasswordEncryptor(processorData, processorClassNames);
        this.repositoryAccessor.setPasswordEncryptor(this.passwordEncryptor);
        this.userManager = this.configureUserManager(processorData, processorClassNames);
        this.repositoryAccessor.setUserManager(this.userManager);
        this.propertySetFactory = this.configurePropertySetFactory(processorData, processorClassNames);
        this.repositoryAccessor.setPropertySetFactory(this.propertySetFactory);
        this.authenticator = this.configureAuthenticator(processorData, processorClassNames);
        this.repositoryAccessor.setAuthenticator(this.authenticator);
        this.groupManager = this.configureGroupManager(processorData, processorClassNames);
        this.repositoryAccessor.setGroupManager(this.groupManager);
        this.entityQueryParser = this.configureEntityQueryParser(processorData, processorClassNames);
        this.repositoryAccessor.setEntityQueryParser(this.entityQueryParser);
        return this.repositoryAccessor;
    }

    public UserManager configureUserManager(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        super.configureUserManager(components, componentClassNames);
        this.wireCacheManager(components, this.userManager);
        return this.userManager;
    }

    public GroupManager configureGroupManager(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        super.configureGroupManager(components, componentClassNames);
        this.wireCacheManager(components, this.groupManager);
        return this.groupManager;
    }

    public PropertySetFactory configurePropertySetFactory(HashMap components, HashMap componentClassNames) throws ConfigurationException {
        super.configurePropertySetFactory(components, componentClassNames);
        this.propertySetFactory = new CachingPropertySetFactory();
        this.propertySetFactory.init(components);
        components.put("propertySetFactory", this.propertySetFactory);
        return this.propertySetFactory;
    }

    public void init(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        this.accessor = (HibernateAccessor)processorData.get("accessor");
        if (this.accessor != null) {
            return;
        }
        InitializationCheck.validateArgs(processorClassNames, new String[]{"accessor"}, this);
        String accessorClassName = (String)processorClassNames.get("accessor");
        this.accessor = (HibernateAccessor)this.instantiateComponent(accessorClassName, class$com$atlassian$user$impl$hibernate$configuration$HibernateAccessor == null ? (class$com$atlassian$user$impl$hibernate$configuration$HibernateAccessor = DefaultHibernateRepositoryProcessor.class$("com.atlassian.user.impl.hibernate.configuration.HibernateAccessor")) : class$com$atlassian$user$impl$hibernate$configuration$HibernateAccessor);
    }

    protected ExternalEntityDAO configureExternalEntityDAO(HashMap processorData, HashMap processorClassNames) throws ConfigurationException {
        String externalEntityDAOClassName = (String)processorClassNames.get("externalEntityDAO");
        this.externalEntityDAO = (ExternalEntityDAO)this.instantiateComponent(externalEntityDAOClassName, class$com$atlassian$user$impl$hibernate$ExternalEntityDAO == null ? (class$com$atlassian$user$impl$hibernate$ExternalEntityDAO = DefaultHibernateRepositoryProcessor.class$("com.atlassian.user.impl.hibernate.ExternalEntityDAO")) : class$com$atlassian$user$impl$hibernate$ExternalEntityDAO);
        this.externalEntityDAO.init(processorData);
        processorData.put("externalEntityDAO", this.externalEntityDAO);
        this.wireCacheManager(processorData, this.externalEntityDAO);
        return this.externalEntityDAO;
    }

    private void wireCacheManager(HashMap processorData, Object caching) {
        if (caching instanceof Caching) {
            ((Caching)caching).setCacheManager((CacheManager)processorData.get("cacheManager"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

