/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.hibernate;

import com.atlassian.user.Caching;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.impl.cache.Cache;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.hibernate.DefaultHibernateUser;
import com.atlassian.user.impl.hibernate.HibernateUserManager;
import java.io.Serializable;
import net.sf.hibernate.HibernateException;

public class CachingHibernateUserManager
extends HibernateUserManager
implements Caching {
    protected static final String CACHE_KEY = (class$com$atlassian$user$impl$hibernate$CachingHibernateUserManager == null ? (class$com$atlassian$user$impl$hibernate$CachingHibernateUserManager = CachingHibernateUserManager.class$("com.atlassian.user.impl.hibernate.CachingHibernateUserManager")) : class$com$atlassian$user$impl$hibernate$CachingHibernateUserManager).getName() + ".username";
    private CacheManager cacheManager;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$CachingHibernateUserManager;
    static /* synthetic */ Class class$com$atlassian$user$impl$hibernate$DefaultHibernateUser;

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public User getUser(String username) throws EntityException {
        Cache nameCache = this.cacheManager.getCache(CACHE_KEY);
        Long id = (Long)nameCache.get(username);
        if (id != null) {
            try {
                return (User)this.getSession().get(class$com$atlassian$user$impl$hibernate$DefaultHibernateUser == null ? (class$com$atlassian$user$impl$hibernate$DefaultHibernateUser = CachingHibernateUserManager.class$("com.atlassian.user.impl.hibernate.DefaultHibernateUser")) : class$com$atlassian$user$impl$hibernate$DefaultHibernateUser, (Serializable)id);
            }
            catch (HibernateException e) {
                throw new EntityException(e);
            }
        }
        User user = super.getUser(username);
        if (user != null) {
            nameCache.put(username, new Long(((DefaultHibernateUser)user).getId()));
        }
        return user;
    }

    public void removeUser(User user) throws EntityException {
        Cache nameCache = this.cacheManager.getCache(CACHE_KEY);
        try {
            super.removeUser(user);
            nameCache.remove(user.getName());
        }
        catch (Exception e) {
            throw new EntityException("Error removing username from cache: " + user.getName(), e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

