/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class DelegatingListUserManager
implements UserManager {
    private List userManagers;

    public DelegatingListUserManager(List userManagers) {
        this.userManagers = userManagers;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.userManagers = (List)args.get("userManagers");
        InitializationCheck.validateArgs(args, new String[]{"userManagers"}, this);
    }

    public Pager getUsers() throws EntityException {
        ArrayList<Pager> pagers = new ArrayList<Pager>();
        Iterator userManagersIter = this.userManagers.iterator();
        while (userManagersIter.hasNext()) {
            UserManager userManager = (UserManager)userManagersIter.next();
            pagers.add(userManager.getUsers());
        }
        return PagerFactory.getPager(pagers);
    }

    public Pager getUserNames() throws EntityException {
        ArrayList<Pager> pagers = new ArrayList<Pager>();
        Iterator userManagersIter = this.userManagers.iterator();
        while (userManagersIter.hasNext()) {
            UserManager userManager = (UserManager)userManagersIter.next();
            pagers.add(userManager.getUserNames());
        }
        return PagerFactory.getPager(pagers);
    }

    public User getUser(String username) throws EntityException {
        UserManager userManager;
        User foundUser = null;
        Iterator userManagersIter = this.userManagers.iterator();
        while (userManagersIter.hasNext() && (foundUser = (userManager = (UserManager)userManagersIter.next()).getUser(username)) == null) {
        }
        return foundUser;
    }

    public User createUser(String username) throws EntityException {
        User createdUser = null;
        Iterator userManagersIter = this.userManagers.iterator();
        while (userManagersIter.hasNext()) {
            UserManager userManager = (UserManager)userManagersIter.next();
            if (userManager.isCreative()) {
                createdUser = userManager.createUser(username);
            }
            if (createdUser == null) continue;
            break;
        }
        if (createdUser == null) {
            throw new EntityException("Could not create user: " + username);
        }
        return createdUser;
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager == null) {
            throw new EntityException("Cannot find a userManager responsible for user [" + user.getName() + "]");
        }
        userManager.alterPassword(user, plainTextPass);
    }

    public void saveUser(User user) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager == null) {
            throw new EntityException("Cannot find a userManager responsible for user [" + user.getName() + "]");
        }
        userManager.saveUser(user);
    }

    public void removeUser(User user) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager == null) {
            throw new EntityException("Cannot find a userManager responsible for user [" + user.getName() + "]");
        }
        userManager.removeUser(user);
    }

    public boolean isReadOnly(User user) throws EntityException {
        UserManager userManager = this.getMatchingUserManager(user);
        if (userManager != null) {
            return userManager.isReadOnly(user);
        }
        throw new EntityException("Cannot find a userManager responsible for user [" + user.getName() + "]");
    }

    public Repository getRepository() {
        Iterator iter = this.userManagers.iterator();
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        while (iter.hasNext()) {
            UserManager userManager = (UserManager)iter.next();
            repositories.add(userManager.getRepository());
        }
        return new DelegatingRepository(repositories);
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Iterator iter = this.userManagers.iterator();
        while (iter.hasNext()) {
            UserManager userManager = (UserManager)iter.next();
            Repository repo = userManager.getRepository(entity);
            if (repo == null) continue;
            return repo;
        }
        return null;
    }

    public boolean isCreative() {
        Iterator iter = this.userManagers.iterator();
        while (iter.hasNext()) {
            UserManager userManager = (UserManager)iter.next();
            if (!userManager.isCreative()) continue;
            return true;
        }
        return false;
    }

    protected UserManager getMatchingUserManager(User user) throws EntityException {
        User foundUser = null;
        Iterator userManagersIter = this.userManagers.iterator();
        UserManager matchingUserManager = null;
        while (userManagersIter.hasNext()) {
            matchingUserManager = (UserManager)userManagersIter.next();
            foundUser = matchingUserManager.getUser(user.getName());
            if (foundUser == null) continue;
            return matchingUserManager;
        }
        return null;
    }
}

