/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.cache.CacheManager;
import com.atlassian.user.impl.cache.EntityRepositoryCache;
import com.atlassian.user.impl.cache.GroupCache;
import com.atlassian.user.impl.cache.GroupsForUserCache;
import com.atlassian.user.impl.cache.MembershipCache;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Category;

public class CachingGroupManager
implements GroupManager {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$user$impl$cache$CachingGroupManager == null ? (class$com$atlassian$user$impl$cache$CachingGroupManager = CachingGroupManager.class$("com.atlassian.user.impl.cache.CachingGroupManager")) : class$com$atlassian$user$impl$cache$CachingGroupManager));
    protected GroupManager underlyingGroupManager;
    protected CacheManager cacheManager;
    protected GroupCache groupCache = null;
    protected MembershipCache membershipCache = null;
    protected GroupsForUserCache groupsForUserCache = null;
    protected EntityRepositoryCache entityRepositoryCache = null;
    static /* synthetic */ Class class$com$atlassian$user$impl$cache$CachingGroupManager;

    public CachingGroupManager() {
    }

    public CachingGroupManager(GroupManager underlyingGroupManager, CacheManager cacheManager) {
        this.underlyingGroupManager = underlyingGroupManager;
        this.cacheManager = cacheManager;
        this.initialiseCaches();
    }

    public Pager getGroups(User user) throws EntityException {
        List groupNames;
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null.");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Retrieving groups for user [" + user.getName() + "]"));
        }
        if ((groupNames = this.groupsForUserCache.get(user)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cache miss. Retrieving groups from underlying group manager.");
            }
            groupNames = PagerUtils.toListOfEntityNames(this.underlyingGroupManager.getGroups(user));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Retrieved " + groupNames.size() + " groups for user [" + user + "], putting in cache."));
            }
            this.groupsForUserCache.put(user, groupNames);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Cache hit. Returning pager with " + groupNames.size() + " items."));
        }
        ArrayList<Group> groups = new ArrayList<Group>();
        Iterator iter = groupNames.iterator();
        while (iter.hasNext()) {
            String groupName = (String)iter.next();
            groups.add(this.getGroup(groupName));
        }
        return new DefaultPager(groups);
    }

    public Group getGroup(String groupName) throws EntityException {
        Group cachedGroup = this.groupCache.get(groupName);
        if (cachedGroup != null) {
            return GroupCache.NULL_GROUP.equals(cachedGroup) ? null : cachedGroup;
        }
        Group group = this.underlyingGroupManager.getGroup(groupName);
        this.groupCache.put(groupName, group);
        return group;
    }

    public Group createGroup(String groupName) throws EntityException {
        Group createdGroup = this.underlyingGroupManager.createGroup(groupName);
        if (createdGroup != null) {
            this.groupCache.put(createdGroup.getName(), createdGroup);
        }
        return createdGroup;
    }

    public void removeGroup(Group group) throws EntityException {
        List memberNames = PagerUtils.toList(this.getMemberNames(group));
        this.underlyingGroupManager.removeGroup(group);
        this.groupCache.remove(group.getName());
        this.groupsForUserCache.remove(memberNames);
        this.membershipCache.remove(memberNames, group);
        this.entityRepositoryCache.remove(group);
    }

    public void addMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.addMembership(group, user);
        this.membershipCache.put(user, group, true);
        this.groupsForUserCache.remove(user);
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        Boolean membershipCheckElement = this.membershipCache.get(user, group);
        if (membershipCheckElement != null) {
            return membershipCheckElement;
        }
        boolean isMember = this.underlyingGroupManager.hasMembership(group, user);
        this.membershipCache.put(user, group, isMember);
        return isMember;
    }

    public void removeMembership(Group group, User user) throws EntityException {
        this.underlyingGroupManager.removeMembership(group, user);
        this.membershipCache.remove(user, group);
        this.groupsForUserCache.remove(user);
    }

    public Repository getRepository(Entity entity) throws EntityException {
        Repository cachedRepository = this.entityRepositoryCache.get(entity);
        if (cachedRepository != null) {
            return cachedRepository;
        }
        Repository repository = this.underlyingGroupManager.getRepository(entity);
        this.entityRepositoryCache.put(entity, repository);
        return repository;
    }

    public Pager getGroups() throws EntityException {
        return this.underlyingGroupManager.getGroups();
    }

    public Pager getMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getLocalMemberNames(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return this.underlyingGroupManager.getExternalMemberNames(group);
    }

    public boolean supportsExternalMembership() throws EntityException {
        return this.underlyingGroupManager.supportsExternalMembership();
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return this.underlyingGroupManager.isReadOnly(group);
    }

    public Repository getRepository() {
        return this.underlyingGroupManager.getRepository();
    }

    public boolean isCreative() {
        return this.underlyingGroupManager.isCreative();
    }

    public void init(HashMap args) throws ConfigurationException {
        InitializationCheck.validateArgs(args, new String[]{"cacheManager", "groupManager"}, this);
        this.cacheManager = (CacheManager)args.get("cacheManager");
        this.underlyingGroupManager = (GroupManager)args.get("groupManager");
        this.initialiseCaches();
    }

    private void initialiseCaches() {
        String namePrefix = this.underlyingGroupManager.getClass().getName();
        this.entityRepositoryCache = new EntityRepositoryCache(this.cacheManager, namePrefix + ".repositories");
        this.groupCache = new GroupCache(this.cacheManager, namePrefix + ".groups");
        this.membershipCache = new MembershipCache(this.cacheManager, namePrefix + ".groups_hasMembership");
        this.groupsForUserCache = new GroupsForUserCache(this.cacheManager, namePrefix + ".groups_getGroupsForUser");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

