/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler.metadata;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.servlet.handler.AbstractUrlHandlerMapping;
import org.springframework.web.servlet.handler.metadata.PathMap;

public abstract class AbstractPathMapHandlerMapping
extends AbstractUrlHandlerMapping {
    public void initApplicationContext() throws BeansException {
        if (!(this.getApplicationContext() instanceof ConfigurableApplicationContext)) {
            throw new ApplicationContextException("[" + this.getClass().getName() + "] needs to run in a ConfigurableApplicationContext");
        }
        ConfigurableListableBeanFactory beanFactory = ((ConfigurableApplicationContext)this.getApplicationContext()).getBeanFactory();
        try {
            Class[] handlerClasses = this.getClassesWithPathMapAttributes();
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Found " + handlerClasses.length + " attribute-targeted handlers"));
            }
            for (int i = 0; i < handlerClasses.length; ++i) {
                Class handlerClass = handlerClasses[i];
                Object handler = beanFactory.autowire(handlerClass, 4, true);
                beanFactory.registerSingleton(handlerClass.getName(), handler);
                PathMap[] pathMaps = this.getPathMapAttributes(handlerClass);
                for (int j = 0; j < pathMaps.length; ++j) {
                    PathMap pathMap = pathMaps[j];
                    String path = pathMap.getUrl();
                    if (!path.startsWith("/")) {
                        path = "/" + path;
                    }
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)("Mapping path [" + path + "] to class [" + handlerClass.getName() + "]"));
                    }
                    this.registerHandler(path, handler);
                }
            }
        }
        catch (BeansException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new BeanInitializationException("Could not retrieve PathMap attributes", ex);
        }
    }

    protected abstract Class[] getClassesWithPathMapAttributes() throws Exception;

    protected abstract PathMap[] getPathMapAttributes(Class var1) throws Exception;
}

